/*
 * Decompiled with CFR 0.152.
 */
package net.java.stun4j.attribute;

import java.util.Arrays;
import junit.framework.TestCase;
import net.java.stun4j.MsgFixture;
import net.java.stun4j.StunException;
import net.java.stun4j.attribute.OptionalAttribute;

public class OptionalAttributeAttributeTest
extends TestCase {
    private OptionalAttribute optionalAttribute = null;
    private MsgFixture msgFixture = null;
    byte[] expectedAttributeValue = null;

    protected void setUp() throws Exception {
        super.setUp();
        this.msgFixture = new MsgFixture();
        int offset = 4;
        this.expectedAttributeValue = new byte[this.msgFixture.unknownOptionalAttribute.length - offset];
        System.arraycopy(this.msgFixture.unknownOptionalAttribute, offset, this.expectedAttributeValue, 0, this.expectedAttributeValue.length);
        this.optionalAttribute = new OptionalAttribute(this.msgFixture.optionalAttributeType);
    }

    protected void tearDown() throws Exception {
        this.optionalAttribute = null;
        this.expectedAttributeValue = null;
        super.tearDown();
    }

    public void testDecodeAttributeBody() throws StunException {
        char offset = '\u0004';
        char length = (char)(this.msgFixture.unknownOptionalAttribute.length - offset);
        this.optionalAttribute.decodeAttributeBody(this.msgFixture.unknownOptionalAttribute, offset, length);
        OptionalAttributeAttributeTest.assertTrue((String)"OptionalAttribute did not decode properly.", (boolean)Arrays.equals(this.expectedAttributeValue, this.optionalAttribute.getBody()));
        OptionalAttributeAttributeTest.assertEquals((String)"Lenght was not properly decoded", (char)length, (char)this.optionalAttribute.getDataLength());
    }

    public void testEncode() {
        this.optionalAttribute.setBody(this.expectedAttributeValue, 0, this.expectedAttributeValue.length);
        byte[] actualReturn = this.optionalAttribute.encode();
        OptionalAttributeAttributeTest.assertTrue((String)"encode failed", (boolean)Arrays.equals(this.msgFixture.unknownOptionalAttribute, actualReturn));
    }

    public void testEquals() {
        Object obj = null;
        boolean expectedReturn = false;
        this.optionalAttribute.setBody(this.expectedAttributeValue, 0, this.expectedAttributeValue.length);
        boolean actualReturn = this.optionalAttribute.equals(obj);
        OptionalAttributeAttributeTest.assertEquals((String)"failed null comparison", (boolean)expectedReturn, (boolean)actualReturn);
        obj = new String("hehe :)");
        actualReturn = this.optionalAttribute.equals(obj);
        OptionalAttributeAttributeTest.assertEquals((String)"failed wrong type comparison", (boolean)expectedReturn, (boolean)actualReturn);
        obj = new OptionalAttribute(this.msgFixture.optionalAttributeType);
        ((OptionalAttribute)obj).setBody(this.expectedAttributeValue, 0, this.expectedAttributeValue.length);
        expectedReturn = true;
        actualReturn = this.optionalAttribute.equals(obj);
        OptionalAttributeAttributeTest.assertEquals((String)"failed null comparison", (boolean)expectedReturn, (boolean)actualReturn);
    }

    public void testGetDataLength() {
        char expectedReturn = (char)this.expectedAttributeValue.length;
        this.optionalAttribute.setBody(this.expectedAttributeValue, 0, this.expectedAttributeValue.length);
        char actualReturn = this.optionalAttribute.getDataLength();
        OptionalAttributeAttributeTest.assertEquals((String)"return value", (char)expectedReturn, (char)actualReturn);
    }
}

