/*
 * Decompiled with CFR 0.152.
 */
package net.java.stun4j.attribute;

import java.util.Arrays;
import junit.framework.TestCase;
import net.java.stun4j.MsgFixture;
import net.java.stun4j.StunException;
import net.java.stun4j.attribute.ErrorCodeAttribute;

public class ErrorCodeAttributeTest
extends TestCase {
    private ErrorCodeAttribute errorCodeAttribute = null;
    private MsgFixture msgFixture;

    public ErrorCodeAttributeTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.errorCodeAttribute = new ErrorCodeAttribute();
        this.msgFixture = new MsgFixture();
        this.msgFixture.setUp();
    }

    protected void tearDown() throws Exception {
        this.errorCodeAttribute = null;
        this.msgFixture.tearDown();
        this.msgFixture = null;
        super.tearDown();
    }

    public void testErrorCodeAttribute() {
        this.errorCodeAttribute = new ErrorCodeAttribute();
        ErrorCodeAttributeTest.assertEquals((String)"ErrorCodeAttribute() constructed an attribute with an invalid type", (char)'\t', (char)this.errorCodeAttribute.getAttributeType());
    }

    public void testDecodeAttributeBody() throws StunException {
        byte[] attributeValue = this.msgFixture.errCodeTestValue;
        char offset = '\u0004';
        char length = (char)(attributeValue.length - 4);
        this.errorCodeAttribute.decodeAttributeBody(attributeValue, offset, length);
        ErrorCodeAttributeTest.assertEquals((String)"Error Class was not correctly decoded", (byte)4, (byte)this.errorCodeAttribute.getErrorClass());
        ErrorCodeAttributeTest.assertEquals((String)"Error Number was not correctly decoded", (byte)20, (byte)this.errorCodeAttribute.getErrorNumber());
        ErrorCodeAttributeTest.assertEquals((String)"Reason phrase was not correctly decoded", (String)"Test error reason phrase.".trim(), (String)this.errorCodeAttribute.getReasonPhrase().trim());
    }

    public void testEncode() throws StunException {
        byte[] expectedReturn = this.msgFixture.errCodeTestValue;
        this.errorCodeAttribute.setErrorClass((byte)4);
        this.errorCodeAttribute.setErrorNumber((byte)20);
        this.errorCodeAttribute.setReasonPhrase("Test error reason phrase.");
        byte[] actualReturn = this.errorCodeAttribute.encode();
        ErrorCodeAttributeTest.assertTrue((String)"encode() did not return the expected binary array.", (boolean)Arrays.equals(expectedReturn, actualReturn));
    }

    public void testEquals() throws StunException {
        ErrorCodeAttribute target = null;
        boolean expectedReturn = false;
        boolean actualReturn = this.errorCodeAttribute.equals(target);
        ErrorCodeAttributeTest.assertEquals((String)"equals() failed against a null value target.", (boolean)expectedReturn, (boolean)actualReturn);
        target = new ErrorCodeAttribute();
        expectedReturn = false;
        target.setErrorClass((byte)4);
        target.setErrorNumber((byte)20);
        this.errorCodeAttribute.setErrorClass((byte)(4 + 1));
        this.errorCodeAttribute.setErrorNumber((byte)(20 + 1));
        actualReturn = this.errorCodeAttribute.equals(target);
        ErrorCodeAttributeTest.assertEquals((String)"equals() failed against a not equal target.", (boolean)expectedReturn, (boolean)actualReturn);
        target = new ErrorCodeAttribute();
        this.errorCodeAttribute = new ErrorCodeAttribute();
        expectedReturn = true;
        target.setErrorClass((byte)4);
        target.setErrorNumber((byte)20);
        this.errorCodeAttribute.setErrorClass((byte)4);
        this.errorCodeAttribute.setErrorNumber((byte)20);
        actualReturn = this.errorCodeAttribute.equals(target);
        ErrorCodeAttributeTest.assertEquals((String)"equals() failed against a not equal target.", (boolean)expectedReturn, (boolean)actualReturn);
    }

    public void testGetDataLength() throws StunException {
        char expectedReturn = (char)(this.msgFixture.errCodeTestValue.length - 4);
        this.errorCodeAttribute.setErrorClass((byte)4);
        this.errorCodeAttribute.setErrorNumber((byte)20);
        this.errorCodeAttribute.setReasonPhrase("Test error reason phrase.");
        char actualReturn = this.errorCodeAttribute.getDataLength();
        ErrorCodeAttributeTest.assertEquals((String)"return value", (char)expectedReturn, (char)actualReturn);
    }

    public void testGetErrorCode() throws StunException {
        char expectedReturn = (char)(100 * 4 + 20);
        this.errorCodeAttribute.setErrorClass((byte)4);
        this.errorCodeAttribute.setErrorNumber((byte)20);
        char actualReturn = this.errorCodeAttribute.getErrorCode();
        ErrorCodeAttributeTest.assertEquals((String)"return value", (char)expectedReturn, (char)actualReturn);
    }

    public void testGetName() {
        String expectedReturn = "ERROR-CODE";
        String actualReturn = this.errorCodeAttribute.getName();
        ErrorCodeAttributeTest.assertEquals((String)"return value", (String)expectedReturn, (String)actualReturn);
    }

    public void testSetErrorCode() throws StunException {
        char errorCode = (char)(4 * 100 + 20);
        this.errorCodeAttribute.setErrorCode(errorCode);
        ErrorCodeAttributeTest.assertEquals((String)"An error class was not properly set after decoding an error code.", (int)4, (int)this.errorCodeAttribute.getErrorClass());
        ErrorCodeAttributeTest.assertEquals((String)"An error number was not properly set after decoding an error code.", (int)20, (int)this.errorCodeAttribute.getErrorNumber());
    }
}

