/*
 * Decompiled with CFR 0.152.
 */
package net.java.stun4j.attribute;

import junit.framework.TestCase;
import net.java.stun4j.MsgFixture;
import net.java.stun4j.StunAddress;
import net.java.stun4j.StunException;
import net.java.stun4j.attribute.Attribute;
import net.java.stun4j.attribute.AttributeDecoder;
import net.java.stun4j.attribute.ChangeRequestAttribute;
import net.java.stun4j.attribute.ErrorCodeAttribute;
import net.java.stun4j.attribute.MappedAddressAttribute;
import net.java.stun4j.attribute.OptionalAttribute;
import net.java.stun4j.attribute.UnknownAttributesAttribute;

public class AttributeDecoderTest
extends TestCase {
    private AttributeDecoder attributeDecoder = null;
    private MsgFixture msgFixture;
    private byte[] expectedAttributeValue = null;

    public AttributeDecoderTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.attributeDecoder = new AttributeDecoder();
        this.msgFixture = new MsgFixture();
        int offset = 4;
        this.expectedAttributeValue = new byte[this.msgFixture.unknownOptionalAttribute.length - offset];
        System.arraycopy(this.msgFixture.unknownOptionalAttribute, offset, this.expectedAttributeValue, 0, this.expectedAttributeValue.length);
        this.msgFixture.setUp();
    }

    protected void tearDown() throws Exception {
        this.attributeDecoder = null;
        this.msgFixture.tearDown();
        this.msgFixture = null;
        super.tearDown();
    }

    public void testDecodeMappedAddress() throws StunException {
        byte[] bytes = this.msgFixture.mappedAddress;
        char offset = '\u0000';
        char length = (char)bytes.length;
        MappedAddressAttribute expectedReturn = new MappedAddressAttribute();
        expectedReturn.setAddress(new StunAddress(MsgFixture.ADDRESS_ATTRIBUTE_ADDRESS, 1904));
        Attribute actualReturn = AttributeDecoder.decode(bytes, offset, length);
        AttributeDecoderTest.assertEquals((String)"AttributeDecoder.decode() failed for a MAPPED-ADDRESS attribute", (Object)expectedReturn, (Object)actualReturn);
    }

    public void testDecodeMappedAddress_v6() throws StunException {
        byte[] bytes = this.msgFixture.mappedAddressv6;
        char offset = '\u0000';
        char length = (char)bytes.length;
        MappedAddressAttribute expectedReturn = new MappedAddressAttribute();
        expectedReturn.setAddress(new StunAddress(MsgFixture.ADDRESS_ATTRIBUTE_ADDRESS_V6, 1904));
        Attribute actualReturn = AttributeDecoder.decode(bytes, offset, length);
        AttributeDecoderTest.assertEquals((String)"AttributeDecoder.decode() failed for a MAPPED-ADDRESS attribute", (Object)expectedReturn, (Object)actualReturn);
    }

    public void testDecodeChangeRequest() throws StunException {
        byte[] bytes = this.msgFixture.chngReqTestValue1;
        char offset = '\u0000';
        char length = (char)bytes.length;
        ChangeRequestAttribute expectedReturn = new ChangeRequestAttribute();
        expectedReturn.setChangeIpFlag(false);
        expectedReturn.setChangePortFlag(false);
        Attribute actualReturn = AttributeDecoder.decode(bytes, offset, length);
        AttributeDecoderTest.assertEquals((String)"AttributeDecoder.decode() failed for a CHANGE-REQUEST attribute", (Object)expectedReturn, (Object)actualReturn);
    }

    public void testDecodeErrorCode() throws StunException {
        byte[] bytes = this.msgFixture.errCodeTestValue;
        char offset = '\u0000';
        char length = (char)bytes.length;
        ErrorCodeAttribute expectedReturn = new ErrorCodeAttribute();
        expectedReturn.setErrorClass((byte)4);
        expectedReturn.setErrorNumber((byte)20);
        expectedReturn.setReasonPhrase("Test error reason phrase.");
        Attribute actualReturn = AttributeDecoder.decode(bytes, offset, length);
        AttributeDecoderTest.assertEquals((String)"AttributeDecoder.decode() failed for a ERROR-CODE attribute", (Object)expectedReturn, (Object)actualReturn);
    }

    public void testDecodeUnknownAttributes() throws StunException {
        byte[] bytes = this.msgFixture.unknownAttsDecodeTestValue;
        char offset = '\u0000';
        char length = (char)this.msgFixture.mappedAddress.length;
        UnknownAttributesAttribute expectedReturn = new UnknownAttributesAttribute();
        expectedReturn.addAttributeID(' ');
        expectedReturn.addAttributeID('!');
        expectedReturn.addAttributeID('\"');
        Attribute actualReturn = AttributeDecoder.decode(bytes, offset, length);
        AttributeDecoderTest.assertEquals((String)"AttributeDecoder.decode() failed for a ERROR-CODE attribute", (Object)expectedReturn, (Object)actualReturn);
    }

    public void testDecodeUnknownOptionalAttribute() throws StunException {
        byte[] bytes = this.msgFixture.unknownOptionalAttribute;
        char offset = '\u0000';
        char length = (char)this.msgFixture.mappedAddress.length;
        OptionalAttribute expectedReturn = new OptionalAttribute('\u8000');
        expectedReturn.setBody(this.expectedAttributeValue, 0, this.expectedAttributeValue.length);
        Attribute actualReturn = AttributeDecoder.decode(bytes, offset, length);
        AttributeDecoderTest.assertEquals((String)"AttributeDecoder.decode() failed for a UNKNOWN_OPTIONAL attribute", (Object)expectedReturn, (Object)actualReturn);
    }
}

