/*
 * Decompiled with CFR 0.152.
 */
package net.java.stun4j.attribute;

import java.util.Arrays;
import junit.framework.TestCase;
import net.java.stun4j.MsgFixture;
import net.java.stun4j.StunAddress;
import net.java.stun4j.StunException;
import net.java.stun4j.attribute.AddressAttribute;
import net.java.stun4j.attribute.ChangedAddressAttribute;
import net.java.stun4j.attribute.MappedAddressAttribute;
import net.java.stun4j.attribute.ReflectedFromAttribute;
import net.java.stun4j.attribute.ResponseAddressAttribute;
import net.java.stun4j.attribute.SourceAddressAttribute;
import net.java.stun4j.attribute.XorMappedAddressAttribute;

public class AddressAttributeTest
extends TestCase {
    private AddressAttribute addressAttribute = null;
    private MsgFixture msgFixture;

    public AddressAttributeTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.addressAttribute = new MappedAddressAttribute();
        this.msgFixture = new MsgFixture();
        this.msgFixture.setUp();
    }

    protected void tearDown() throws Exception {
        this.addressAttribute = null;
        this.msgFixture.tearDown();
        this.msgFixture = null;
        super.tearDown();
    }

    public void testAddressAttributeDescendants() {
        this.addressAttribute = new MappedAddressAttribute();
        char expectedType = '\u0001';
        char actualType = this.addressAttribute.getAttributeType();
        String expectedName = "MAPPED-ADDRESS";
        String actualName = this.addressAttribute.getName();
        AddressAttributeTest.assertEquals((String)"MappedAddressAttribute does not the right type.", (char)expectedType, (char)actualType);
        AddressAttributeTest.assertEquals((String)"MappedAddressAttribute does not the right name.", (String)expectedName, (String)actualName);
        this.addressAttribute = new SourceAddressAttribute();
        expectedType = '\u0004';
        actualType = this.addressAttribute.getAttributeType();
        expectedName = "SOURCE-ADDRESS";
        actualName = this.addressAttribute.getName();
        AddressAttributeTest.assertEquals((String)"SourceAddressAttribute does not the right type.", (char)expectedType, (char)actualType);
        AddressAttributeTest.assertEquals((String)"SourceAddressAttribute does not the right name.", (String)expectedName, (String)actualName);
        this.addressAttribute = new ChangedAddressAttribute();
        expectedType = '\u0005';
        actualType = this.addressAttribute.getAttributeType();
        expectedName = "CHANGED-ADDRESS";
        actualName = this.addressAttribute.getName();
        AddressAttributeTest.assertEquals((String)"ChangedAddressAttribute does not the right type.", (char)expectedType, (char)actualType);
        AddressAttributeTest.assertEquals((String)"ChangedAddressAttribute does not the right name.", (String)expectedName, (String)actualName);
        this.addressAttribute = new ResponseAddressAttribute();
        expectedType = '\u0002';
        actualType = this.addressAttribute.getAttributeType();
        expectedName = "RESPONSE-ADDRESS";
        actualName = this.addressAttribute.getName();
        AddressAttributeTest.assertEquals((String)"ResponseAddressAttribute does not the right type.", (char)expectedType, (char)actualType);
        AddressAttributeTest.assertEquals((String)"ResponseAddressAttribute does not the right name.", (String)expectedName, (String)actualName);
        this.addressAttribute = new ReflectedFromAttribute();
        expectedType = '\u000b';
        actualType = this.addressAttribute.getAttributeType();
        expectedName = "REFLECTED-FROM";
        actualName = this.addressAttribute.getName();
        AddressAttributeTest.assertEquals((String)"ReflectedFromAttribute does not the right type.", (char)expectedType, (char)actualType);
        AddressAttributeTest.assertEquals((String)"ReflectedFromAttribute does not the right name.", (String)expectedName, (String)actualName);
        this.addressAttribute = new ReflectedFromAttribute();
        expectedType = '\u000b';
        actualType = this.addressAttribute.getAttributeType();
        expectedName = "REFLECTED-FROM";
        actualName = this.addressAttribute.getName();
        AddressAttributeTest.assertEquals((String)"ReflectedFromAttribute does not the right type.", (char)expectedType, (char)actualType);
        AddressAttributeTest.assertEquals((String)"ReflectedFromAttribute does not the right name.", (String)expectedName, (String)actualName);
        this.addressAttribute = new XorMappedAddressAttribute();
        expectedType = '\u8020';
        actualType = this.addressAttribute.getAttributeType();
        expectedName = "XOR-MAPPED-ADDRESS";
        actualName = this.addressAttribute.getName();
        AddressAttributeTest.assertEquals((String)"XorMappedAddressAttribute does not the right type.", (char)expectedType, (char)actualType);
        AddressAttributeTest.assertEquals((String)"XorMappedAddressAttribute does not the right name.", (String)expectedName, (String)actualName);
    }

    public void testXorMappedAddressXoring_v4() {
        XorMappedAddressAttribute addressAttribute = new XorMappedAddressAttribute();
        StunAddress testAddress = new StunAddress("130.79.95.53", 12120);
        addressAttribute.setAddress(testAddress);
        StunAddress xorredAddr = addressAttribute.applyXor(new byte[]{-126, 79, 95, 53, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0});
        AddressAttributeTest.assertTrue((String)"Xorring the address with itself didn't return 00000...", (boolean)Arrays.equals(xorredAddr.getAddressBytes(), new byte[]{0, 0, 0, 0}));
        AddressAttributeTest.assertTrue((String)"Port was not xorred", (testAddress.getPort() != xorredAddr.getPort() ? 1 : 0) != 0);
        addressAttribute.setAddress(testAddress);
        xorredAddr = addressAttribute.applyXor(new byte[]{21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36});
        xorredAddr = addressAttribute.applyXor(xorredAddr.getAddressBytes());
        AddressAttributeTest.assertTrue((String)"Xorring the original with the xor-ed didn't return the code..", (boolean)Arrays.equals(xorredAddr.getAddressBytes(), new byte[]{21, 22, 23, 24}));
        AddressAttributeTest.assertTrue((String)"Port was not xorred", (testAddress.getPort() != '\uffff' ? 1 : 0) != 0);
        addressAttribute.setAddress(testAddress);
        xorredAddr = addressAttribute.applyXor(new byte[]{21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36});
        addressAttribute.setAddress(xorredAddr);
        xorredAddr = addressAttribute.applyXor(new byte[]{21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36});
        AddressAttributeTest.assertEquals((String)"Double xorring didn't give the original ...", (Object)testAddress, (Object)xorredAddr);
    }

    public void testXorMappedAddressXoring_v6() {
        XorMappedAddressAttribute addressAttribute = new XorMappedAddressAttribute();
        StunAddress testAddress = new StunAddress("2001:660:4701:1001:202:8aff:febe:130b", 12120);
        addressAttribute.setAddress(testAddress);
        StunAddress xorredAddr = addressAttribute.applyXor(new byte[]{32, 1, 6, 96, 71, 1, 16, 1, 2, 2, -118, -1, -2, -66, 19, 11});
        AddressAttributeTest.assertTrue((String)"Xorring the address with itself didn't return 00000...", (boolean)Arrays.equals(xorredAddr.getAddressBytes(), new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}));
        AddressAttributeTest.assertTrue((String)"Port was not xorred", (testAddress.getPort() != xorredAddr.getPort() ? 1 : 0) != 0);
        addressAttribute.setAddress(testAddress);
        xorredAddr = addressAttribute.applyXor(new byte[]{21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36});
        xorredAddr = addressAttribute.applyXor(xorredAddr.getAddressBytes());
        AddressAttributeTest.assertTrue((String)"Xorring the original with the xor-ed didn't return the code..", (boolean)Arrays.equals(xorredAddr.getAddressBytes(), new byte[]{21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36}));
        AddressAttributeTest.assertTrue((String)"Port was not xorred", (testAddress.getPort() != '\uffff' ? 1 : 0) != 0);
        addressAttribute.setAddress(testAddress);
        xorredAddr = addressAttribute.applyXor(new byte[]{21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36});
        addressAttribute.setAddress(xorredAddr);
        xorredAddr = addressAttribute.applyXor(new byte[]{21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36});
        AddressAttributeTest.assertEquals((String)"Double xorring didn't give the original ...", (Object)testAddress, (Object)xorredAddr);
    }

    public void testDecodeAttributeBody() throws StunException {
        byte[] attributeValue = this.msgFixture.mappedAddress;
        char offset = '\u0004';
        char length = (char)(attributeValue.length - offset);
        this.addressAttribute.decodeAttributeBody(attributeValue, offset, length);
        AddressAttributeTest.assertEquals((String)"AddressAttribute.decode() did not properly decode the port field.", (char)'\u0770', (char)this.addressAttribute.getPort());
        AddressAttributeTest.assertTrue((String)"AddressAttribute.decode() did not properly decode the address field.", (boolean)Arrays.equals(MsgFixture.ADDRESS_ATTRIBUTE_ADDRESS, this.addressAttribute.getAddressBytes()));
    }

    public void testDecodeAttributeBodyv6() throws StunException {
        byte[] attributeValue = this.msgFixture.mappedAddressv6;
        char offset = '\u0004';
        char length = (char)(attributeValue.length - offset);
        this.addressAttribute.decodeAttributeBody(attributeValue, offset, length);
        AddressAttributeTest.assertEquals((String)"decode() failed for an IPv6 Addr's port.", (char)'\u0770', (char)this.addressAttribute.getPort());
        AddressAttributeTest.assertTrue((String)"AddressAttribute.decode() failed for an IPv6 address.", (boolean)Arrays.equals(MsgFixture.ADDRESS_ATTRIBUTE_ADDRESS_V6, this.addressAttribute.getAddressBytes()));
    }

    public void testEncode() throws StunException {
        byte[] expectedReturn = this.msgFixture.mappedAddress;
        this.addressAttribute.setAddress(new StunAddress(MsgFixture.ADDRESS_ATTRIBUTE_ADDRESS, 1904));
        byte[] actualReturn = this.addressAttribute.encode();
        AddressAttributeTest.assertTrue((String)"AddressAttribute.encode() did not properly encode a sample attribute", (boolean)Arrays.equals(expectedReturn, actualReturn));
    }

    public void testEncodev6() throws StunException {
        byte[] expectedReturn = this.msgFixture.mappedAddressv6;
        this.addressAttribute.setAddress(new StunAddress(MsgFixture.ADDRESS_ATTRIBUTE_ADDRESS_V6, 1904));
        byte[] actualReturn = this.addressAttribute.encode();
        AddressAttributeTest.assertTrue((String)"An AddressAttribute did not properly encode an IPv6 addr.", (boolean)Arrays.equals(expectedReturn, actualReturn));
    }

    public void testEquals() throws StunException {
        MappedAddressAttribute target = null;
        boolean expectedReturn = false;
        boolean actualReturn = this.addressAttribute.equals(target);
        AddressAttributeTest.assertEquals((String)"AddressAttribute.equals() failed against a null target.", (boolean)expectedReturn, (boolean)actualReturn);
        target = new MappedAddressAttribute();
        char port = (char)(1904 + 1);
        target.setAddress(new StunAddress(MsgFixture.ADDRESS_ATTRIBUTE_ADDRESS, (int)port));
        this.addressAttribute.setAddress(new StunAddress(MsgFixture.ADDRESS_ATTRIBUTE_ADDRESS, 1904));
        expectedReturn = false;
        actualReturn = this.addressAttribute.equals(target);
        AddressAttributeTest.assertEquals((String)"AddressAttribute.equals() failed against a different target.", (boolean)expectedReturn, (boolean)actualReturn);
        target.setAddress(new StunAddress(MsgFixture.ADDRESS_ATTRIBUTE_ADDRESS, 1904));
        expectedReturn = true;
        actualReturn = this.addressAttribute.equals(target);
        AddressAttributeTest.assertEquals((String)"AddressAttribute.equals() failed against an equal target.", (boolean)expectedReturn, (boolean)actualReturn);
        target.setAddress(new StunAddress(MsgFixture.ADDRESS_ATTRIBUTE_ADDRESS_V6, 1904));
        this.addressAttribute.setAddress(new StunAddress(MsgFixture.ADDRESS_ATTRIBUTE_ADDRESS_V6, 1904));
        expectedReturn = true;
        actualReturn = this.addressAttribute.equals(target);
        AddressAttributeTest.assertEquals((String)"AddressAttribute.equals() failed for IPv6 addresses.", (boolean)expectedReturn, (boolean)actualReturn);
    }

    public void testGetDataLength() throws StunException {
        char expectedReturn = '\b';
        this.addressAttribute.setAddress(new StunAddress(MsgFixture.ADDRESS_ATTRIBUTE_ADDRESS, 1904));
        char actualReturn = this.addressAttribute.getDataLength();
        AddressAttributeTest.assertEquals((String)"Datalength is not propoerly calculated", (char)expectedReturn, (char)actualReturn);
        expectedReturn = '\u0014';
        this.addressAttribute.setAddress(new StunAddress(MsgFixture.ADDRESS_ATTRIBUTE_ADDRESS_V6, 1904));
        actualReturn = this.addressAttribute.getDataLength();
        AddressAttributeTest.assertEquals((String)"Datalength is not propoerly calculated", (char)expectedReturn, (char)actualReturn);
    }

    public void testGetFamily() {
        byte expectedReturn = 1;
        this.addressAttribute.setAddress(new StunAddress(MsgFixture.ADDRESS_ATTRIBUTE_ADDRESS, 1904));
        byte actualReturn = this.addressAttribute.getFamily();
        AddressAttributeTest.assertEquals((String)"Address family was not 1 for an IPv4", (byte)expectedReturn, (byte)actualReturn);
        expectedReturn = 2;
        this.addressAttribute.setAddress(new StunAddress(MsgFixture.ADDRESS_ATTRIBUTE_ADDRESS_V6, 1904));
        actualReturn = this.addressAttribute.getFamily();
        AddressAttributeTest.assertEquals((String)"Address family was not 2 for an IPv6 address", (byte)expectedReturn, (byte)actualReturn);
    }
}

