/*
 * Decompiled with CFR 0.152.
 */
package net.java.stun4j.attribute;

import java.net.Inet6Address;
import net.java.stun4j.StunAddress;
import net.java.stun4j.StunException;
import net.java.stun4j.attribute.Attribute;

abstract class AddressAttribute
extends Attribute {
    static final byte ADDRESS_FAMILY_IPV4 = 1;
    static final byte ADDRESS_FAMILY_IPV6 = 2;
    protected StunAddress address = null;
    private static final char DATA_LENGTH_FOR_IPV6 = '\u0014';
    private static final char DATA_LENGTH_FOR_IPV4 = '\b';

    AddressAttribute(char attributeType) {
        super(attributeType);
    }

    private boolean isTypeValid(char type) {
        return type == '\u0001' || type == '\u0002' || type == '\u0004' || type == '\u0005' || type == '\u000b' || type == '\u8020';
    }

    protected void setAttributeType(char type) {
        if (!this.isTypeValid(type)) {
            throw new IllegalArgumentException(type + "is not a valid address attribute!");
        }
        super.setAttributeType(type);
    }

    public String getName() {
        switch (this.getAttributeType()) {
            case '\u0001': {
                return "MAPPED-ADDRESS";
            }
            case '\u0002': {
                return "RESPONSE-ADDRESS";
            }
            case '\u0004': {
                return "SOURCE-ADDRESS";
            }
            case '\u0005': {
                return "CHANGED-ADDRESS";
            }
            case '\u000b': {
                return "REFLECTED-FROM";
            }
            case '\u8020': {
                return "XOR-MAPPED-ADDRESS";
            }
        }
        return "UNKNOWN ATTRIBUTE";
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AddressAttribute) || obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        AddressAttribute att = (AddressAttribute)obj;
        if (att.getAttributeType() != this.getAttributeType() || att.getDataLength() != this.getDataLength() || att.getFamily() != this.getFamily() || att.getAddress() != null && !this.address.equals(att.getAddress())) {
            return false;
        }
        if (att.getAddress() == null && this.getAddress() == null) {
            return true;
        }
        return true;
    }

    public char getDataLength() {
        if (this.getFamily() == 2) {
            return '\u0014';
        }
        return '\b';
    }

    public byte[] encode() {
        char type = this.getAttributeType();
        if (!this.isTypeValid(type)) {
            throw new IllegalStateException(type + "is not a valid address attribute!");
        }
        byte[] binValue = new byte[4 + this.getDataLength()];
        binValue[0] = (byte)(type >> 8);
        binValue[1] = (byte)(type & 0xFF);
        binValue[2] = (byte)(this.getDataLength() >> 8);
        binValue[3] = (byte)(this.getDataLength() & 0xFF);
        binValue[4] = 0;
        binValue[5] = this.getFamily();
        binValue[6] = (byte)(this.getPort() >> 8);
        binValue[7] = (byte)(this.getPort() & 0xFF);
        if (this.getFamily() == 2) {
            System.arraycopy(this.getAddressBytes(), 0, binValue, 8, 16);
        } else {
            System.arraycopy(this.getAddressBytes(), 0, binValue, 8, 4);
        }
        return binValue;
    }

    public void setAddress(StunAddress address) {
        this.address = address;
    }

    public StunAddress getAddress() {
        return this.address;
    }

    public byte[] getAddressBytes() {
        return this.address.getAddressBytes();
    }

    public byte getFamily() {
        if (this.address.getSocketAddress().getAddress() instanceof Inet6Address) {
            return 2;
        }
        return 1;
    }

    public char getPort() {
        return this.address.getPort();
    }

    void decodeAttributeBody(byte[] attributeValue, char offset, char length) throws StunException {
        char c = offset = (char)(offset + '\u0001');
        offset = (char)(offset + '\u0001');
        byte family = attributeValue[c];
        char c2 = offset;
        char c3 = offset = (char)(offset + '\u0001');
        offset = (char)(offset + '\u0001');
        char port = (char)(attributeValue[c2] << 8 | attributeValue[c3] & 0xFF);
        byte[] address = null;
        address = family == 2 ? new byte[16] : new byte[4];
        System.arraycopy(attributeValue, offset, address, 0, address.length);
        this.setAddress(new StunAddress(address, (int)port));
    }
}

