/*
 * Decompiled with CFR 0.152.
 */
package net.java.stun4j;

import java.util.Arrays;
import java.util.Vector;
import junit.framework.TestCase;
import net.java.stun4j.NetAccessPointDescriptor;
import net.java.stun4j.ResponseCollector;
import net.java.stun4j.StunAddress;
import net.java.stun4j.StunMessageEvent;
import net.java.stun4j.message.MessageFactory;
import net.java.stun4j.message.Request;
import net.java.stun4j.message.Response;
import net.java.stun4j.stack.RequestListener;
import net.java.stun4j.stack.StunStack;

public class TransactionSupportTests
extends TestCase {
    StunStack stunStack = null;
    StunAddress clientAddress = new StunAddress("127.0.0.1", 5216);
    StunAddress serverAddress = new StunAddress("127.0.0.2", 5255);
    NetAccessPointDescriptor clientAccessPoint = null;
    NetAccessPointDescriptor serverAccessPoint = null;
    Request bindingRequest = null;
    Response bindingResponse = null;
    PlainRequestCollector requestCollector = null;
    PlainResponseCollector responseCollector = null;

    protected void setUp() throws Exception {
        super.setUp();
        this.stunStack = StunStack.getInstance();
        this.stunStack.start();
        this.clientAccessPoint = new NetAccessPointDescriptor(this.clientAddress);
        this.serverAccessPoint = new NetAccessPointDescriptor(this.serverAddress);
        this.stunStack.installNetAccessPoint(this.clientAccessPoint);
        this.stunStack.installNetAccessPoint(this.serverAccessPoint);
        this.bindingRequest = MessageFactory.createBindingRequest();
        this.bindingResponse = MessageFactory.createBindingResponse(this.clientAddress, this.clientAddress, this.serverAddress);
        this.requestCollector = new PlainRequestCollector();
        this.responseCollector = new PlainResponseCollector();
        System.setProperty("net.java.stun4j.PROPAGATE_RECEIVED_RETRANSMISSIONS", "false");
        System.setProperty("net.java.stun4j.KEEP_CLIENT_TRANS_AFTER_A_RESPONSE", "false");
        System.setProperty("net.java.stun4j.MAX_RETRANSMISSIONS", "");
        System.setProperty("net.java.stun4j.MAX_WAIT_INTERVAL", "");
        System.setProperty("net.java.stun4j.ORIGINAL_WAIT_INTERVAL", "");
    }

    protected void tearDown() throws Exception {
        this.clientAccessPoint = null;
        this.serverAccessPoint = null;
        this.requestCollector = null;
        this.responseCollector = null;
        System.setProperty("net.java.stun4j.PROPAGATE_RECEIVED_RETRANSMISSIONS", "false");
        System.setProperty("net.java.stun4j.KEEP_CLIENT_TRANS_AFTER_A_RESPONSE", "false");
        System.setProperty("net.java.stun4j.MAX_RETRANSMISSIONS", "");
        System.setProperty("net.java.stun4j.MAX_WAIT_INTERVAL", "");
        System.setProperty("net.java.stun4j.ORIGINAL_WAIT_INTERVAL", "");
        TransactionSupportTests transactionSupportTests = this;
        transactionSupportTests.stunStack.shutDown();
        super.tearDown();
    }

    public void testClientRetransmissions() throws Exception {
        System.setProperty("net.java.stun4j.PROPAGATE_RECEIVED_RETRANSMISSIONS", "true");
        this.stunStack.getProvider().addRequestListener(this.serverAccessPoint, this.requestCollector);
        this.stunStack.getProvider().sendRequest(this.bindingRequest, this.serverAddress, this.clientAccessPoint, this.responseCollector);
        Thread.currentThread();
        Thread.sleep(12000L);
        TransactionSupportTests.assertTrue((String)"No retransmissions of the request have been received", (this.requestCollector.receivedRequests.size() > 1 ? 1 : 0) != 0);
        TransactionSupportTests.assertTrue((String)"The binding request has not been retransmitted enough!", (this.requestCollector.receivedRequests.size() >= 9 ? 1 : 0) != 0);
    }

    public void testServerRetransmissionHiding() throws Exception {
        this.stunStack.getProvider().addRequestListener(this.serverAccessPoint, this.requestCollector);
        this.stunStack.getProvider().sendRequest(this.bindingRequest, this.serverAddress, this.clientAccessPoint, this.responseCollector);
        Thread.currentThread();
        Thread.sleep(12000L);
        TransactionSupportTests.assertTrue((String)"Retransmissions of a binding request were propagated to the server", (this.requestCollector.receivedRequests.size() <= 1 ? 1 : 0) != 0);
    }

    public void testServerResponseRetransmissions() throws Exception {
        System.setProperty("net.java.stun4j.KEEP_CLIENT_TRANS_AFTER_A_RESPONSE", "true");
        this.stunStack.getProvider().addRequestListener(this.serverAccessPoint, this.requestCollector);
        this.stunStack.getProvider().sendRequest(this.bindingRequest, this.serverAddress, this.clientAccessPoint, this.responseCollector);
        Thread.currentThread();
        Thread.sleep(500L);
        StunMessageEvent evt = (StunMessageEvent)this.requestCollector.receivedRequests.get(0);
        byte[] tid = evt.getMessage().getTransactionID();
        this.stunStack.getProvider().sendResponse(tid, this.bindingResponse, this.serverAccessPoint, this.clientAddress);
        Thread.currentThread();
        Thread.sleep(12000L);
        TransactionSupportTests.assertTrue((String)"There were no retransmissions of a binding response", (this.responseCollector.receivedResponses.size() < 5 ? 1 : 0) != 0);
    }

    public void testUniqueIDs() throws Exception {
        this.stunStack.getProvider().addRequestListener(this.serverAccessPoint, this.requestCollector);
        this.stunStack.getProvider().sendRequest(this.bindingRequest, this.serverAddress, this.clientAccessPoint, this.responseCollector);
        Thread.currentThread();
        Thread.sleep(500L);
        StunMessageEvent evt1 = (StunMessageEvent)this.requestCollector.receivedRequests.get(0);
        byte[] tid = evt1.getMessage().getTransactionID();
        this.stunStack.getProvider().sendResponse(tid, this.bindingResponse, this.serverAccessPoint, this.clientAddress);
        this.stunStack.getProvider().sendRequest(this.bindingRequest, this.serverAddress, this.clientAccessPoint, this.responseCollector);
        Thread.currentThread();
        Thread.sleep(12000L);
        StunMessageEvent evt2 = (StunMessageEvent)this.requestCollector.receivedRequests.get(0);
        TransactionSupportTests.assertTrue((String)"Consecutive requests were assigned the same transaction id", (boolean)Arrays.equals(evt1.getMessage().getTransactionID(), evt2.getMessage().getTransactionID()));
    }

    public void testClientTransactionMaxRetransmisssionsConfigurationParameter() throws Exception {
        System.setProperty("net.java.stun4j.MAX_RETRANSMISSIONS", "2");
        System.setProperty("net.java.stun4j.PROPAGATE_RECEIVED_RETRANSMISSIONS", "true");
        this.stunStack.getProvider().addRequestListener(this.serverAccessPoint, this.requestCollector);
        this.stunStack.getProvider().sendRequest(this.bindingRequest, this.serverAddress, this.clientAccessPoint, this.responseCollector);
        Thread.currentThread();
        Thread.sleep(1600L);
        TransactionSupportTests.assertTrue((String)"No retransmissions of the request have been received", (this.requestCollector.receivedRequests.size() > 1 ? 1 : 0) != 0);
        TransactionSupportTests.assertTrue((String)"The MAX_RETRANSMISSIONS param was not taken into account!", (this.requestCollector.receivedRequests.size() == 3 ? 1 : 0) != 0);
    }

    public void testMinWaitIntervalConfigurationParameter() throws Exception {
        System.setProperty("net.java.stun4j.ORIGINAL_WAIT_INTERVAL", "1000");
        System.setProperty("net.java.stun4j.PROPAGATE_RECEIVED_RETRANSMISSIONS", "true");
        this.stunStack.getProvider().addRequestListener(this.serverAccessPoint, this.requestCollector);
        this.stunStack.getProvider().sendRequest(this.bindingRequest, this.serverAddress, this.clientAccessPoint, this.responseCollector);
        Thread.currentThread();
        Thread.sleep(500L);
        TransactionSupportTests.assertTrue((String)"A retransmissions of the request was sent too early", (this.requestCollector.receivedRequests.size() < 2 ? 1 : 0) != 0);
        Thread.currentThread();
        Thread.sleep(600L);
        TransactionSupportTests.assertTrue((String)"A retransmissions of the request was not sent", (this.requestCollector.receivedRequests.size() == 2 ? 1 : 0) != 0);
    }

    public void testMaxWaitIntervalConfigurationParameter() throws Exception {
        System.setProperty("net.java.stun4j.MAX_WAIT_INTERVAL", "100");
        System.setProperty("net.java.stun4j.PROPAGATE_RECEIVED_RETRANSMISSIONS", "true");
        this.stunStack.getProvider().addRequestListener(this.serverAccessPoint, this.requestCollector);
        this.stunStack.getProvider().sendRequest(this.bindingRequest, this.serverAddress, this.clientAccessPoint, this.responseCollector);
        Thread.currentThread();
        Thread.sleep(1100L);
        TransactionSupportTests.assertTrue((String)"Not all retransmissions were made for the expected period of time", (this.requestCollector.receivedRequests.size() == 9 ? 1 : 0) != 0);
        Thread.currentThread();
        Thread.sleep(1600L);
        TransactionSupportTests.assertTrue((String)"A retransmissions of the request was sent, while not supposed to", (this.requestCollector.receivedRequests.size() == 9 ? 1 : 0) != 0);
    }

    private class PlainResponseCollector
    implements ResponseCollector {
        public Vector receivedResponses = new Vector();

        private PlainResponseCollector() {
        }

        public void processResponse(StunMessageEvent responseEvt) {
            this.receivedResponses.add(responseEvt);
        }

        public void processTimeout() {
            this.receivedResponses.add(new String("timeout"));
        }
    }

    private class PlainRequestCollector
    implements RequestListener {
        public Vector receivedRequests = new Vector();

        private PlainRequestCollector() {
        }

        public void requestReceived(StunMessageEvent evt) {
            this.receivedRequests.add(evt);
        }
    }
}

