/*
 * Decompiled with CFR 0.152.
 */
package net.java.stun4j;

import java.util.Vector;
import junit.framework.TestCase;
import net.java.stun4j.NetAccessPointDescriptor;
import net.java.stun4j.ResponseCollector;
import net.java.stun4j.StunAddress;
import net.java.stun4j.StunMessageEvent;
import net.java.stun4j.message.MessageFactory;
import net.java.stun4j.message.Request;
import net.java.stun4j.message.Response;
import net.java.stun4j.stack.RequestListener;
import net.java.stun4j.stack.StunStack;

public class MessageEventDispatchingTest
extends TestCase {
    StunStack stunStack = null;
    StunAddress clientAddress = new StunAddress("127.0.0.1", 5216);
    StunAddress serverAddress = new StunAddress("127.0.0.2", 5255);
    StunAddress serverAddress2 = new StunAddress("127.0.0.2", 5259);
    NetAccessPointDescriptor clientAccessPoint = null;
    NetAccessPointDescriptor serverAccessPoint = null;
    NetAccessPointDescriptor serverAccessPoint2 = null;
    Request bindingRequest = null;
    Response bindingResponse = null;
    PlainRequestCollector requestCollector = null;
    PlainResponseCollector responseCollector = null;

    protected void setUp() throws Exception {
        super.setUp();
        this.stunStack = StunStack.getInstance();
        this.stunStack.start();
        this.clientAccessPoint = new NetAccessPointDescriptor(this.clientAddress);
        this.serverAccessPoint = new NetAccessPointDescriptor(this.serverAddress);
        this.serverAccessPoint2 = new NetAccessPointDescriptor(this.serverAddress2);
        this.stunStack.installNetAccessPoint(this.clientAccessPoint);
        this.stunStack.installNetAccessPoint(this.serverAccessPoint);
        this.stunStack.installNetAccessPoint(this.serverAccessPoint2);
        this.bindingRequest = MessageFactory.createBindingRequest();
        this.bindingResponse = MessageFactory.createBindingResponse(this.clientAddress, this.clientAddress, this.serverAddress);
        this.requestCollector = new PlainRequestCollector();
        this.responseCollector = new PlainResponseCollector();
    }

    protected void tearDown() throws Exception {
        this.clientAccessPoint = null;
        this.serverAccessPoint = null;
        this.requestCollector = null;
        this.responseCollector = null;
        MessageEventDispatchingTest messageEventDispatchingTest = this;
        messageEventDispatchingTest.stunStack.shutDown();
        super.tearDown();
    }

    public void testClientTransactionTimeouts() throws Exception {
        this.stunStack.getProvider().sendRequest(this.bindingRequest, this.serverAddress, this.clientAccessPoint, this.responseCollector);
        Thread.currentThread();
        Thread.sleep(12000L);
        MessageEventDispatchingTest.assertEquals((String)"No timeout was produced upon expiration of a client transaction", (int)this.responseCollector.receivedResponses.size(), (int)1);
        MessageEventDispatchingTest.assertEquals((String)"No timeout was produced upon expiration of a client transaction", this.responseCollector.receivedResponses.get(0), (Object)"timeout");
    }

    public void testEventDispatchingUponIncomingRequests() throws Exception {
        this.stunStack.getProvider().addRequestListener(this.requestCollector);
        this.stunStack.getProvider().sendRequest(this.bindingRequest, this.serverAddress, this.clientAccessPoint, this.responseCollector);
        Thread.currentThread();
        Thread.sleep(500L);
        MessageEventDispatchingTest.assertTrue((String)"No MessageEvents have been dispatched", (this.requestCollector.receivedRequests.size() == 1 ? 1 : 0) != 0);
    }

    public void testSelectiveEventDispatchingUponIncomingRequests() throws Exception {
        this.stunStack.getProvider().addRequestListener(this.serverAccessPoint, this.requestCollector);
        PlainRequestCollector requestCollector2 = new PlainRequestCollector();
        this.stunStack.getProvider().addRequestListener(this.serverAccessPoint2, requestCollector2);
        this.stunStack.getProvider().sendRequest(this.bindingRequest, this.serverAddress2, this.clientAccessPoint, this.responseCollector);
        Thread.currentThread();
        Thread.sleep(500L);
        MessageEventDispatchingTest.assertTrue((String)"A MessageEvent was received by a non-interested selective listener", (this.requestCollector.receivedRequests.size() == 0 ? 1 : 0) != 0);
        MessageEventDispatchingTest.assertTrue((String)"No MessageEvents have been dispatched for a selective listener", (requestCollector2.receivedRequests.size() == 1 ? 1 : 0) != 0);
    }

    public void testServerResponseRetransmissions() throws Exception {
        this.stunStack.getProvider().addRequestListener(this.serverAccessPoint, this.requestCollector);
        this.stunStack.getProvider().sendRequest(this.bindingRequest, this.serverAddress, this.clientAccessPoint, this.responseCollector);
        Thread.currentThread();
        Thread.sleep(500L);
        StunMessageEvent evt = (StunMessageEvent)this.requestCollector.receivedRequests.get(0);
        byte[] tid = evt.getMessage().getTransactionID();
        this.stunStack.getProvider().sendResponse(tid, this.bindingResponse, this.serverAccessPoint, this.clientAddress);
        Thread.currentThread();
        Thread.sleep(500L);
        MessageEventDispatchingTest.assertTrue((String)"There were no retransmissions of a binding response", (this.responseCollector.receivedResponses.size() == 1 ? 1 : 0) != 0);
    }

    private class PlainResponseCollector
    implements ResponseCollector {
        public Vector receivedResponses = new Vector();

        private PlainResponseCollector() {
        }

        public void processResponse(StunMessageEvent responseEvt) {
            this.receivedResponses.add(responseEvt);
        }

        public void processTimeout() {
            this.receivedResponses.add(new String("timeout"));
        }
    }

    private class PlainRequestCollector
    implements RequestListener {
        public Vector receivedRequests = new Vector();

        private PlainRequestCollector() {
        }

        public void requestReceived(StunMessageEvent evt) {
            this.receivedRequests.add(evt);
        }
    }
}

