/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.sts.operation;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBElement;
import javax.xml.ws.WebServiceContext;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.sts.QNameConstants;
import org.apache.cxf.sts.RealmParser;
import org.apache.cxf.sts.operation.AbstractOperation;
import org.apache.cxf.sts.request.KeyRequirements;
import org.apache.cxf.sts.request.ReceivedToken;
import org.apache.cxf.sts.request.RequestParser;
import org.apache.cxf.sts.request.TokenRequirements;
import org.apache.cxf.sts.service.EncryptionProperties;
import org.apache.cxf.sts.token.provider.TokenProviderParameters;
import org.apache.cxf.sts.token.provider.TokenReference;
import org.apache.cxf.sts.token.renewer.TokenRenewer;
import org.apache.cxf.sts.token.renewer.TokenRenewerParameters;
import org.apache.cxf.sts.token.renewer.TokenRenewerResponse;
import org.apache.cxf.sts.token.validator.TokenValidatorResponse;
import org.apache.cxf.ws.security.sts.provider.STSException;
import org.apache.cxf.ws.security.sts.provider.model.LifetimeType;
import org.apache.cxf.ws.security.sts.provider.model.RequestSecurityTokenResponseType;
import org.apache.cxf.ws.security.sts.provider.model.RequestSecurityTokenType;
import org.apache.cxf.ws.security.sts.provider.model.RequestedReferenceType;
import org.apache.cxf.ws.security.sts.provider.model.RequestedSecurityTokenType;
import org.apache.cxf.ws.security.sts.provider.operation.RenewOperation;
import org.apache.ws.security.WSSecurityException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TokenRenewOperation
extends AbstractOperation
implements RenewOperation {
    private static final Logger LOG = LogUtils.getL7dLogger(TokenRenewOperation.class);
    private List<TokenRenewer> tokenRenewers = new ArrayList<TokenRenewer>();

    public void setTokenRenewers(List<TokenRenewer> tokenRenewerList) {
        this.tokenRenewers = tokenRenewerList;
    }

    public List<TokenRenewer> getTokenRenewers() {
        return this.tokenRenewers;
    }

    public RequestSecurityTokenResponseType renew(RequestSecurityTokenType request, WebServiceContext context) {
        TokenValidatorResponse tokenResponse;
        RequestParser requestParser = this.parseRequest(request, context);
        KeyRequirements keyRequirements = requestParser.getKeyRequirements();
        TokenRequirements tokenRequirements = requestParser.getTokenRequirements();
        ReceivedToken renewTarget = tokenRequirements.getRenewTarget();
        if (renewTarget == null || renewTarget.getToken() == null) {
            throw new STSException("No element presented for renewal", STSException.INVALID_REQUEST);
        }
        if (tokenRequirements.getTokenType() == null) {
            LOG.fine("Received TokenType is null");
        }
        String realm = null;
        if (this.stsProperties.getRealmParser() != null) {
            RealmParser realmParser = this.stsProperties.getRealmParser();
            realm = realmParser.parseRealm(context);
        }
        if ((tokenResponse = this.validateReceivedToken(context, realm, tokenRequirements, renewTarget)) == null) {
            LOG.fine("No Token Validator has been found that can handle this token");
            renewTarget.setState(ReceivedToken.STATE.INVALID);
            throw new STSException("No Token Validator has been found that can handle this token" + tokenRequirements.getTokenType(), STSException.REQUEST_FAILED);
        }
        if (tokenResponse.getToken().getState() != ReceivedToken.STATE.EXPIRED && tokenResponse.getToken().getState() != ReceivedToken.STATE.VALID) {
            LOG.fine("The token is not valid or expired, and so it cannot be renewed");
            throw new STSException("No Token Validator has been found that can handle this token" + tokenRequirements.getTokenType(), STSException.REQUEST_FAILED);
        }
        TokenRenewerResponse tokenRenewerResponse = null;
        TokenRenewerParameters renewerParameters = this.createTokenRenewerParameters(requestParser, context);
        Map<String, Object> additionalProperties = tokenResponse.getAdditionalProperties();
        if (additionalProperties != null) {
            renewerParameters.setAdditionalProperties(additionalProperties);
        }
        renewerParameters.setRealm(tokenResponse.getTokenRealm());
        renewerParameters.setToken(tokenResponse.getToken());
        realm = tokenResponse.getTokenRealm();
        for (TokenRenewer tokenRenewer : this.tokenRenewers) {
            boolean canHandle = false;
            canHandle = realm == null ? tokenRenewer.canHandleToken(tokenResponse.getToken()) : tokenRenewer.canHandleToken(tokenResponse.getToken(), realm);
            if (!canHandle) continue;
            try {
                tokenRenewerResponse = tokenRenewer.renewToken(renewerParameters);
                break;
            }
            catch (STSException ex) {
                LOG.log(Level.WARNING, "", ex);
                throw ex;
            }
            catch (RuntimeException ex) {
                LOG.log(Level.WARNING, "", ex);
                throw new STSException("Error in providing a token", (Throwable)ex, STSException.REQUEST_FAILED);
            }
        }
        if (tokenRenewerResponse == null || tokenRenewerResponse.getToken() == null) {
            LOG.fine("No Token Renewer has been found that can handle this token");
            throw new STSException("No token renewer found for requested token type", STSException.REQUEST_FAILED);
        }
        try {
            EncryptionProperties encryptionProperties = renewerParameters.getEncryptionProperties();
            RequestSecurityTokenResponseType response = this.createResponse(encryptionProperties, tokenRenewerResponse, tokenRequirements, keyRequirements, context);
            return response;
        }
        catch (Throwable ex) {
            LOG.log(Level.WARNING, "", ex);
            throw new STSException("Error in creating the response", ex, STSException.REQUEST_FAILED);
        }
    }

    private RequestSecurityTokenResponseType createResponse(EncryptionProperties encryptionProperties, TokenRenewerResponse tokenRenewerResponse, TokenRequirements tokenRequirements, KeyRequirements keyRequirements, WebServiceContext webServiceContext) throws WSSecurityException {
        RequestSecurityTokenResponseType response = QNameConstants.WS_TRUST_FACTORY.createRequestSecurityTokenResponseType();
        String context = tokenRequirements.getContext();
        if (context != null) {
            response.setContext(context);
        }
        JAXBElement jaxbTokenType = QNameConstants.WS_TRUST_FACTORY.createTokenType(tokenRequirements.getTokenType());
        response.getAny().add(jaxbTokenType);
        RequestedSecurityTokenType requestedTokenType = QNameConstants.WS_TRUST_FACTORY.createRequestedSecurityTokenType();
        JAXBElement requestedToken = QNameConstants.WS_TRUST_FACTORY.createRequestedSecurityToken(requestedTokenType);
        LOG.fine("Encrypting Issued Token: " + this.encryptIssuedToken);
        if (!this.encryptIssuedToken) {
            requestedTokenType.setAny((Object)tokenRenewerResponse.getToken());
        } else {
            requestedTokenType.setAny((Object)this.encryptToken(tokenRenewerResponse.getToken(), tokenRenewerResponse.getTokenId(), encryptionProperties, keyRequirements, webServiceContext));
        }
        response.getAny().add(requestedToken);
        if (this.returnReferences) {
            TokenReference attachedReference = tokenRenewerResponse.getAttachedReference();
            RequestedReferenceType requestedAttachedReferenceType = null;
            requestedAttachedReferenceType = attachedReference != null ? TokenRenewOperation.createRequestedReference(attachedReference, true) : TokenRenewOperation.createRequestedReference(tokenRenewerResponse.getTokenId(), tokenRequirements.getTokenType(), true);
            JAXBElement requestedAttachedReference = QNameConstants.WS_TRUST_FACTORY.createRequestedAttachedReference(requestedAttachedReferenceType);
            response.getAny().add(requestedAttachedReference);
            TokenReference unAttachedReference = tokenRenewerResponse.getUnAttachedReference();
            RequestedReferenceType requestedUnattachedReferenceType = null;
            requestedUnattachedReferenceType = unAttachedReference != null ? TokenRenewOperation.createRequestedReference(unAttachedReference, false) : TokenRenewOperation.createRequestedReference(tokenRenewerResponse.getTokenId(), tokenRequirements.getTokenType(), false);
            JAXBElement requestedUnattachedReference = QNameConstants.WS_TRUST_FACTORY.createRequestedUnattachedReference(requestedUnattachedReferenceType);
            response.getAny().add(requestedUnattachedReference);
        }
        response.getAny().add(tokenRequirements.getAppliesTo());
        LifetimeType lifetime = TokenRenewOperation.createLifetime(tokenRenewerResponse.getLifetime());
        JAXBElement lifetimeType = QNameConstants.WS_TRUST_FACTORY.createLifetime(lifetime);
        response.getAny().add(lifetimeType);
        return response;
    }

    private TokenRenewerParameters createTokenRenewerParameters(RequestParser requestParser, WebServiceContext context) {
        TokenProviderParameters providerParameters = this.createTokenProviderParameters(requestParser, context);
        TokenRenewerParameters renewerParameters = new TokenRenewerParameters();
        renewerParameters.setAppliesToAddress(providerParameters.getAppliesToAddress());
        renewerParameters.setEncryptionProperties(providerParameters.getEncryptionProperties());
        renewerParameters.setKeyRequirements(providerParameters.getKeyRequirements());
        renewerParameters.setPrincipal(providerParameters.getPrincipal());
        renewerParameters.setStsProperties(providerParameters.getStsProperties());
        renewerParameters.setTokenRequirements(providerParameters.getTokenRequirements());
        renewerParameters.setTokenStore(providerParameters.getTokenStore());
        renewerParameters.setWebServiceContext(providerParameters.getWebServiceContext());
        return renewerParameters;
    }
}

