/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.restcomm.ussd.telephony;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.Props;
import akka.actor.UntypedActor;
import akka.actor.UntypedActorFactory;
import akka.event.Logging;
import akka.event.LoggingAdapter;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;
import javax.servlet.sip.ServletParseException;
import javax.servlet.sip.SipApplicationSession;
import javax.servlet.sip.SipFactory;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipServletResponse;
import javax.servlet.sip.SipURI;
import org.apache.commons.configuration.Configuration;
import org.mobicents.servlet.restcomm.dao.AccountsDao;
import org.mobicents.servlet.restcomm.dao.ApplicationsDao;
import org.mobicents.servlet.restcomm.dao.DaoManager;
import org.mobicents.servlet.restcomm.dao.IncomingPhoneNumbersDao;
import org.mobicents.servlet.restcomm.entities.Account;
import org.mobicents.servlet.restcomm.entities.Application;
import org.mobicents.servlet.restcomm.entities.IncomingPhoneNumber;
import org.mobicents.servlet.restcomm.entities.Sid;
import org.mobicents.servlet.restcomm.interpreter.StartInterpreter;
import org.mobicents.servlet.restcomm.telephony.CallManagerResponse;
import org.mobicents.servlet.restcomm.telephony.CreateCall;
import org.mobicents.servlet.restcomm.telephony.ExecuteCallScript;
import org.mobicents.servlet.restcomm.telephony.InitializeOutbound;
import org.mobicents.servlet.restcomm.telephony.util.CallControlHelper;
import org.mobicents.servlet.restcomm.ussd.interpreter.UssdInterpreter;
import org.mobicents.servlet.restcomm.ussd.interpreter.UssdInterpreterBuilder;
import org.mobicents.servlet.restcomm.ussd.telephony.UssdCall;
import org.mobicents.servlet.restcomm.util.UriUtils;

public class UssdCallManager
extends UntypedActor {
    static final int ERROR_NOTIFICATION = 0;
    static final int WARNING_NOTIFICATION = 1;
    static final Pattern PATTERN = Pattern.compile("[\\*#0-9]{1,12}");
    static final String EMAIL_SENDER = "restcomm@restcomm.org";
    static final String EMAIL_SUBJECT = "RestComm Error Notification - Attention Required";
    private final ActorSystem system;
    private final Configuration configuration;
    private final ServletContext context;
    private final SipFactory sipFactory;
    private final DaoManager storage;
    private CreateCall createCallRequest;
    private final String ussdGatewayUri;
    private final String ussdGatewayUsername;
    private final String ussdGatewayPassword;
    private boolean useTo;
    private final LoggingAdapter logger = Logging.getLogger((ActorSystem)this.getContext().system(), (Object)((Object)this));

    public UssdCallManager(Configuration configuration, ServletContext context, ActorSystem system, ActorRef conferences, ActorRef sms, SipFactory factory, DaoManager storage) {
        this.system = system;
        this.configuration = configuration;
        this.context = context;
        this.sipFactory = factory;
        this.storage = storage;
        Configuration runtime = configuration.subset("runtime-settings");
        Configuration ussdGatewayConfig = runtime.subset("ussd-gateway");
        this.ussdGatewayUri = ussdGatewayConfig.getString("ussd-gateway-uri");
        this.ussdGatewayUsername = ussdGatewayConfig.getString("ussd-gateway-user");
        this.ussdGatewayPassword = ussdGatewayConfig.getString("ussd-gateway-password");
    }

    private ActorRef ussdCall() {
        return this.system.actorOf(new Props(new UntypedActorFactory(){
            private static final long serialVersionUID = 1L;

            public UntypedActor create() throws Exception {
                return new UssdCall(UssdCallManager.this.sipFactory);
            }
        }));
    }

    private void check(Object message) throws IOException {
        String contentType;
        SipServletRequest request = (SipServletRequest)message;
        if (request.getContentLength() == 0 && !"application/vnd.3gpp.ussd+xml".equals(contentType = request.getContentType())) {
            SipServletResponse response = request.createResponse(400);
            response.send();
        }
    }

    public void onReceive(Object message) throws Exception {
        Class<?> klass = message.getClass();
        ActorRef self = this.self();
        ActorRef sender = this.sender();
        if (message instanceof SipServletRequest) {
            SipServletRequest request = (SipServletRequest)message;
            String method = request.getMethod();
            if ("INVITE".equalsIgnoreCase(method)) {
                this.check(request);
                this.invite(request);
            } else if ("INFO".equalsIgnoreCase(method)) {
                this.processRequest(request);
            } else if ("ACK".equalsIgnoreCase(method)) {
                this.processRequest(request);
            } else if ("BYE".equalsIgnoreCase(method)) {
                this.processRequest(request);
            } else if ("CANCEL".equalsIgnoreCase(method)) {
                this.processRequest(request);
            }
        } else if (message instanceof SipServletResponse) {
            this.response(message);
        } else if (CreateCall.class.equals(klass)) {
            try {
                this.createCallRequest = (CreateCall)message;
                sender.tell((Object)new CallManagerResponse((Object)this.outbound(message)), self);
            }
            catch (Exception exception) {
                sender.tell((Object)new CallManagerResponse((Throwable)exception), self);
            }
        } else if (ExecuteCallScript.class.equals(klass)) {
            this.execute(message);
        }
    }

    private void invite(Object message) throws Exception {
        String toUser;
        ApplicationsDao applications;
        ActorRef self = this.self();
        SipServletRequest request = (SipServletRequest)message;
        if (!request.isInitial()) {
            SipServletResponse okay = request.createResponse(200);
            okay.send();
            return;
        }
        AccountsDao accounts = this.storage.getAccountsDao();
        if (this.redirectToHostedVoiceApp(self, request, accounts, applications = this.storage.getApplicationsDao(), toUser = CallControlHelper.getUserSipId((SipServletRequest)request, (boolean)this.useTo))) {
            return;
        }
        SipServletResponse response = request.createResponse(404);
        response.send();
    }

    private boolean redirectToHostedVoiceApp(ActorRef self, SipServletRequest request, AccountsDao accounts, ApplicationsDao applications, String id) throws Exception {
        boolean isFoundHostedApp = false;
        IncomingPhoneNumbersDao numbersDao = this.storage.getIncomingPhoneNumbersDao();
        IncomingPhoneNumber number = null;
        if (request.getContentType().equals("application/vnd.3gpp.ussd+xml")) {
            number = numbersDao.getIncomingPhoneNumber(id);
            if (number != null) {
                UssdInterpreterBuilder builder = new UssdInterpreterBuilder(this.system);
                builder.setConfiguration(this.configuration);
                builder.setStorage(this.storage);
                builder.setCallManager(self);
                builder.setAccount(number.getAccountSid());
                builder.setVersion(number.getApiVersion());
                Account account = accounts.getAccount(number.getAccountSid());
                builder.setEmailAddress(account.getEmailAddress());
                Sid sid = number.getVoiceApplicationSid();
                if (sid != null) {
                    Application application = applications.getApplication(sid);
                    builder.setUrl(UriUtils.resolve((String)request.getLocalAddr(), (int)8080, (URI)application.getVoiceUrl()));
                    builder.setMethod(application.getVoiceMethod());
                    builder.setFallbackUrl(application.getVoiceFallbackUrl());
                    builder.setFallbackMethod(application.getVoiceFallbackMethod());
                    builder.setStatusCallback(application.getStatusCallback());
                    builder.setStatusCallbackMethod(application.getStatusCallbackMethod());
                } else {
                    builder.setUrl(UriUtils.resolve((String)request.getLocalAddr(), (int)8080, (URI)number.getVoiceUrl()));
                    builder.setMethod(number.getVoiceMethod());
                    builder.setFallbackUrl(number.getVoiceFallbackUrl());
                    builder.setFallbackMethod(number.getVoiceFallbackMethod());
                    builder.setStatusCallback(number.getStatusCallback());
                    builder.setStatusCallbackMethod(number.getStatusCallbackMethod());
                }
                ActorRef ussdInterpreter = builder.build();
                ActorRef ussdCall = this.ussdCall();
                ussdCall.tell((Object)request, self);
                ussdInterpreter.tell((Object)new StartInterpreter(ussdCall), self);
                SipApplicationSession applicationSession = request.getApplicationSession();
                applicationSession.setAttribute("UssdCall", (Object)"true");
                applicationSession.setAttribute(UssdInterpreter.class.getName(), (Object)ussdInterpreter);
                applicationSession.setAttribute(UssdCall.class.getName(), (Object)ussdCall);
                isFoundHostedApp = true;
            } else {
                this.logger.info("USSD Number registration NOT FOUND");
                request.createResponse(404).send();
            }
        }
        return isFoundHostedApp;
    }

    private void processRequest(SipServletRequest request) throws IOException {
        ActorRef ussdInterpreter = (ActorRef)request.getApplicationSession().getAttribute(UssdInterpreter.class.getName());
        if (ussdInterpreter != null) {
            this.logger.info("Dispatching Request: " + request.getMethod() + " to UssdInterpreter: " + ussdInterpreter);
            ussdInterpreter.tell((Object)request, this.self());
        } else {
            SipServletResponse notFound = request.createResponse(404);
            notFound.send();
        }
    }

    private ActorRef outbound(Object message) throws ServletParseException {
        CreateCall request = (CreateCall)message;
        Configuration runtime = this.configuration.subset("runtime-settings");
        String uri = this.ussdGatewayUri;
        String ussdUsername = request.username() != null ? request.username() : this.ussdGatewayUsername;
        String ussdPassword = request.password() != null ? request.password() : this.ussdGatewayPassword;
        SipURI from = this.sipFactory.createSipURI(request.from(), uri);
        SipURI to = this.sipFactory.createSipURI(request.to(), uri);
        String transport = to.getTransportParam() != null ? to.getTransportParam() : "udp";
        from = this.outboundInterface(transport);
        ActorRef ussdCall = this.ussdCall();
        ActorRef self = this.self();
        InitializeOutbound init = new InitializeOutbound(null, from, to, ussdUsername, ussdPassword, (long)request.timeout(), request.isFromApi(), runtime.getString("api-version"), request.accountId(), request.type(), this.storage);
        ussdCall.tell((Object)init, self);
        return ussdCall;
    }

    private SipURI outboundInterface(String transport) {
        SipURI result = null;
        List uris = (List)this.context.getAttribute("javax.servlet.sip.outboundInterfaces");
        for (SipURI uri : uris) {
            String interfaceTransport = uri.getTransportParam();
            if (!transport.equalsIgnoreCase(interfaceTransport)) continue;
            result = uri;
        }
        return result;
    }

    private void execute(Object message) {
        ExecuteCallScript request = (ExecuteCallScript)message;
        ActorRef self = this.self();
        UssdInterpreterBuilder builder = new UssdInterpreterBuilder(this.system);
        builder.setConfiguration(this.configuration);
        builder.setStorage(this.storage);
        builder.setCallManager(self);
        builder.setAccount(request.account());
        builder.setVersion(request.version());
        builder.setUrl(request.url());
        builder.setMethod(request.method());
        builder.setFallbackUrl(request.fallbackUrl());
        builder.setFallbackMethod(request.fallbackMethod());
        builder.setStatusCallback(request.callback());
        builder.setStatusCallbackMethod(request.callbackMethod());
        ActorRef interpreter = builder.build();
        interpreter.tell((Object)new StartInterpreter(request.call()), self);
    }

    public void response(Object message) throws IOException {
        ActorRef self = this.self();
        SipServletResponse response = (SipServletResponse)message;
        SipApplicationSession application = response.getApplicationSession();
        if (application.isValid()) {
            ActorRef ussdCall = (ActorRef)application.getAttribute(UssdCall.class.getName());
            ussdCall.tell((Object)response, self);
        }
    }
}

