/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.restcomm.ussd.interpreter;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.Props;
import akka.actor.UntypedActor;
import akka.actor.UntypedActorContext;
import akka.actor.UntypedActorFactory;
import akka.event.Logging;
import akka.event.LoggingAdapter;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Currency;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.regex.Pattern;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipServletResponse;
import org.apache.commons.configuration.Configuration;
import org.apache.http.NameValuePair;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.message.BasicNameValuePair;
import org.joda.time.DateTime;
import org.mobicents.servlet.restcomm.dao.CallDetailRecordsDao;
import org.mobicents.servlet.restcomm.dao.DaoManager;
import org.mobicents.servlet.restcomm.dao.NotificationsDao;
import org.mobicents.servlet.restcomm.email.Mail;
import org.mobicents.servlet.restcomm.email.MailMan;
import org.mobicents.servlet.restcomm.entities.CallDetailRecord;
import org.mobicents.servlet.restcomm.entities.Notification;
import org.mobicents.servlet.restcomm.entities.Sid;
import org.mobicents.servlet.restcomm.fsm.Action;
import org.mobicents.servlet.restcomm.fsm.FiniteStateMachine;
import org.mobicents.servlet.restcomm.fsm.State;
import org.mobicents.servlet.restcomm.fsm.Transition;
import org.mobicents.servlet.restcomm.http.client.Downloader;
import org.mobicents.servlet.restcomm.http.client.DownloaderResponse;
import org.mobicents.servlet.restcomm.http.client.HttpRequestDescriptor;
import org.mobicents.servlet.restcomm.http.client.HttpResponseDescriptor;
import org.mobicents.servlet.restcomm.interpreter.StartInterpreter;
import org.mobicents.servlet.restcomm.interpreter.StopInterpreter;
import org.mobicents.servlet.restcomm.interpreter.rcml.Attribute;
import org.mobicents.servlet.restcomm.interpreter.rcml.End;
import org.mobicents.servlet.restcomm.interpreter.rcml.GetNextVerb;
import org.mobicents.servlet.restcomm.interpreter.rcml.Parser;
import org.mobicents.servlet.restcomm.interpreter.rcml.Tag;
import org.mobicents.servlet.restcomm.patterns.Observe;
import org.mobicents.servlet.restcomm.telephony.Answer;
import org.mobicents.servlet.restcomm.telephony.CallInfo;
import org.mobicents.servlet.restcomm.telephony.CallResponse;
import org.mobicents.servlet.restcomm.telephony.CallStateChanged;
import org.mobicents.servlet.restcomm.telephony.CreateCall;
import org.mobicents.servlet.restcomm.telephony.GetCallInfo;
import org.mobicents.servlet.restcomm.ussd.commons.UssdInfoRequest;
import org.mobicents.servlet.restcomm.ussd.commons.UssdMessageType;
import org.mobicents.servlet.restcomm.ussd.commons.UssdRestcommResponse;
import org.mobicents.servlet.restcomm.util.UriUtils;

public class UssdInterpreter
extends UntypedActor {
    private final LoggingAdapter logger = Logging.getLogger((ActorSystem)this.getContext().system(), (Object)((Object)this));
    static final int ERROR_NOTIFICATION = 0;
    static final int WARNING_NOTIFICATION = 1;
    static final Pattern PATTERN = Pattern.compile("[\\*#0-9]{1,12}");
    static final String EMAIL_SENDER = "restcomm@restcomm.org";
    static final String EMAIL_SUBJECT = "RestComm Error Notification - Attention Required";
    final State uninitialized;
    final State observeCall;
    final State acquiringCallInfo;
    final State disconnecting;
    final State cancelling;
    final State finished;
    private final State preparingMessage;
    private final State processingInfoRequest;
    FiniteStateMachine fsm = null;
    Sid accountId;
    Sid phoneId;
    String version;
    URI statusCallback;
    String statusCallbackMethod;
    String emailAddress;
    ActorRef ussdCall = null;
    CallInfo callInfo = null;
    ActorRef outboundCall = null;
    CallInfo outboundCallInfo = null;
    CallStateChanged.State callState = null;
    CallDetailRecord callRecord = null;
    ActorRef downloader = null;
    HttpRequestDescriptor request;
    HttpResponseDescriptor response;
    ActorRef parser;
    Tag verb;
    DaoManager storage = null;
    final Set<Transition> transitions = new HashSet<Transition>();
    ActorRef mailer = null;
    URI url;
    String method;
    URI fallbackUrl;
    String fallbackMethod;
    Tag ussdLanguageTag = null;
    int maxMessageLength;
    private final int englishLength = 182;
    private final int nonEnglishLength = 80;
    Queue<Tag> ussdMessageTags = new LinkedBlockingQueue<Tag>();
    Tag ussdCollectTag = null;
    String ussdCollectAction = "";
    Configuration configuration = null;
    private final State downloadingRcml;
    private final State downloadingFallbackRcml;
    private final State ready;
    private final State notFound;

    public UssdInterpreter(Configuration configuration, Sid account, Sid phone, String version, URI url, String method, URI fallbackUrl, String fallbackMethod, URI statusCallback, String statusCallbackMethod, String emailAddress, ActorRef callManager, ActorRef conferenceManager, ActorRef sms, DaoManager storage) {
        ActorRef source = this.self();
        this.uninitialized = new State("uninitialized", null, null);
        this.observeCall = new State("observe call", (Action)new ObserveCall(source), null);
        this.acquiringCallInfo = new State("acquiring call info", (Action)new AcquiringCallInfo(source), null);
        this.downloadingRcml = new State("downloading rcml", (Action)new DownloadingRcml(source), null);
        this.downloadingFallbackRcml = new State("downloading fallback rcml", (Action)new DownloadingFallbackRcml(source), null);
        this.preparingMessage = new State("Preparing message", (Action)new PreparingMessage(source), null);
        this.processingInfoRequest = new State("Processing info request from client", (Action)new ProcessingInfoRequest(source), null);
        this.ready = new State("ready", (Action)new Ready(source), null);
        this.notFound = new State("notFound", (Action)new NotFound(source), null);
        this.cancelling = new State("Cancelling", (Action)new Cancelling(source), null);
        this.disconnecting = new State("Disconnecting", (Action)new Disconnecting(source), null);
        this.finished = new State("finished", (Action)new Finished(source), null);
        this.transitions.add(new Transition(this.uninitialized, this.acquiringCallInfo));
        this.transitions.add(new Transition(this.uninitialized, this.cancelling));
        this.transitions.add(new Transition(this.acquiringCallInfo, this.downloadingRcml));
        this.transitions.add(new Transition(this.acquiringCallInfo, this.cancelling));
        this.transitions.add(new Transition(this.downloadingRcml, this.ready));
        this.transitions.add(new Transition(this.downloadingRcml, this.cancelling));
        this.transitions.add(new Transition(this.downloadingRcml, this.notFound));
        this.transitions.add(new Transition(this.downloadingRcml, this.downloadingFallbackRcml));
        this.transitions.add(new Transition(this.downloadingRcml, this.finished));
        this.transitions.add(new Transition(this.downloadingRcml, this.ready));
        this.transitions.add(new Transition(this.ready, this.preparingMessage));
        this.transitions.add(new Transition(this.preparingMessage, this.downloadingRcml));
        this.transitions.add(new Transition(this.preparingMessage, this.processingInfoRequest));
        this.transitions.add(new Transition(this.preparingMessage, this.disconnecting));
        this.transitions.add(new Transition(this.preparingMessage, this.finished));
        this.transitions.add(new Transition(this.processingInfoRequest, this.preparingMessage));
        this.transitions.add(new Transition(this.processingInfoRequest, this.ready));
        this.transitions.add(new Transition(this.processingInfoRequest, this.finished));
        this.transitions.add(new Transition(this.disconnecting, this.finished));
        this.fsm = new FiniteStateMachine(this.uninitialized, this.transitions);
        this.accountId = account;
        this.phoneId = phone;
        this.version = version;
        this.url = url;
        this.method = method;
        this.fallbackUrl = fallbackUrl;
        this.fallbackMethod = fallbackMethod;
        this.statusCallback = statusCallback;
        this.statusCallbackMethod = statusCallbackMethod;
        this.emailAddress = emailAddress;
        this.configuration = configuration;
        this.storage = storage;
        this.mailer = this.mailer(configuration.subset("smtp"));
        Configuration runtime = configuration.subset("runtime-settings");
        String path = runtime.getString("cache-path");
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        path = path + this.accountId.toString();
        this.downloader = this.downloader();
    }

    private Notification notification(int log, int error, String message) {
        Notification.Builder builder = Notification.builder();
        Sid sid = Sid.generate((Sid.Type)Sid.Type.NOTIFICATION);
        builder.setSid(sid);
        builder.setAccountSid(this.accountId);
        builder.setCallSid(this.callInfo.sid());
        builder.setApiVersion(this.version);
        builder.setLog(log);
        builder.setErrorCode(error);
        String base = this.configuration.subset("runtime-settings").getString("error-dictionary-uri");
        StringBuilder buffer = new StringBuilder();
        buffer.append(base);
        if (!base.endsWith("/")) {
            buffer.append("/");
        }
        buffer.append(error).append(".html");
        URI info = URI.create(buffer.toString());
        builder.setMoreInfo(info);
        builder.setMessageText(message);
        DateTime now = DateTime.now();
        builder.setMessageDate(now);
        if (this.request != null) {
            builder.setRequestUrl(this.request.getUri());
            builder.setRequestMethod(this.request.getMethod());
            builder.setRequestVariables(this.request.getParametersAsString());
        }
        if (this.response != null) {
            builder.setResponseHeaders(this.response.getHeadersAsString());
            String type = this.response.getContentType();
            if (type.contains("text/xml") || type.contains("application/xml") || type.contains("text/html")) {
                try {
                    builder.setResponseBody(this.response.getContentAsString());
                }
                catch (IOException exception) {
                    this.logger.error("There was an error while reading the contents of the resource located @ " + this.url.toString(), (Object)exception);
                }
            }
        }
        buffer = new StringBuilder();
        buffer.append("/").append(this.version).append("/Accounts/");
        buffer.append(this.accountId.toString()).append("/Notifications/");
        buffer.append(sid.toString());
        URI uri = URI.create(buffer.toString());
        builder.setUri(uri);
        return builder.build();
    }

    ActorRef mailer(final Configuration configuration) {
        UntypedActorContext context = this.getContext();
        return context.actorOf(new Props(new UntypedActorFactory(){
            private static final long serialVersionUID = 1L;

            public UntypedActor create() throws Exception {
                return new MailMan(configuration);
            }
        }));
    }

    ActorRef downloader() {
        UntypedActorContext context = this.getContext();
        return context.actorOf(new Props(new UntypedActorFactory(){
            private static final long serialVersionUID = 1L;

            public UntypedActor create() throws Exception {
                return new Downloader();
            }
        }));
    }

    ActorRef parser(final String xml) {
        UntypedActorContext context = this.getContext();
        return context.actorOf(new Props(new UntypedActorFactory(){
            private static final long serialVersionUID = 1L;

            public UntypedActor create() throws Exception {
                return new Parser(xml);
            }
        }));
    }

    void invalidVerb(Tag verb) {
        ActorRef self = this.self();
        GetNextVerb next = GetNextVerb.instance();
        this.parser.tell((Object)next, self);
    }

    List<NameValuePair> parameters() {
        SipServletResponse lastResponse;
        ArrayList<NameValuePair> parameters = new ArrayList<NameValuePair>();
        String callSid = this.callInfo.sid().toString();
        parameters.add((NameValuePair)new BasicNameValuePair("CallSid", callSid));
        String accountSid = this.accountId.toString();
        parameters.add((NameValuePair)new BasicNameValuePair("AccountSid", accountSid));
        String from = this.callInfo.from();
        parameters.add((NameValuePair)new BasicNameValuePair("From", from));
        String to = this.callInfo.to();
        parameters.add((NameValuePair)new BasicNameValuePair("To", to));
        String state = this.callState.toString();
        parameters.add((NameValuePair)new BasicNameValuePair("CallStatus", state));
        parameters.add((NameValuePair)new BasicNameValuePair("ApiVersion", this.version));
        String direction = this.callInfo.direction();
        parameters.add((NameValuePair)new BasicNameValuePair("Direction", direction));
        String callerName = this.callInfo.fromName();
        parameters.add((NameValuePair)new BasicNameValuePair("CallerName", callerName));
        String forwardedFrom = this.callInfo.forwardedFrom();
        parameters.add((NameValuePair)new BasicNameValuePair("ForwardedFrom", forwardedFrom));
        if (CreateCall.Type.SIP == this.callInfo.type() && (lastResponse = this.callInfo.lastResponse()) != null) {
            int statusCode = lastResponse.getStatus();
            String method = lastResponse.getMethod();
            if (statusCode >= 400 && "INVITE".equalsIgnoreCase(method) || statusCode >= 200 && statusCode < 300 && "BYE".equalsIgnoreCase(method)) {
                String sipCallId = lastResponse.getCallId();
                parameters.add((NameValuePair)new BasicNameValuePair("DialSipCallId", sipCallId));
                parameters.add((NameValuePair)new BasicNameValuePair("DialSipResponseCode", "" + statusCode));
                Iterator headerIt = lastResponse.getHeaderNames();
                while (headerIt.hasNext()) {
                    String headerName = (String)headerIt.next();
                    if (!headerName.startsWith("X-")) continue;
                    parameters.add((NameValuePair)new BasicNameValuePair("DialSipHeader_" + headerName, lastResponse.getHeader(headerName)));
                }
            }
        }
        return parameters;
    }

    void sendMail(Notification notification) {
        if (this.emailAddress == null || this.emailAddress.isEmpty()) {
            return;
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append("<strong>").append("Sid: ").append("</strong></br>");
        buffer.append(notification.getSid().toString()).append("</br>");
        buffer.append("<strong>").append("Account Sid: ").append("</strong></br>");
        buffer.append(notification.getAccountSid().toString()).append("</br>");
        buffer.append("<strong>").append("Call Sid: ").append("</strong></br>");
        buffer.append(notification.getCallSid().toString()).append("</br>");
        buffer.append("<strong>").append("API Version: ").append("</strong></br>");
        buffer.append(notification.getApiVersion()).append("</br>");
        buffer.append("<strong>").append("Log: ").append("</strong></br>");
        buffer.append(notification.getLog() == 0 ? "ERROR" : "WARNING").append("</br>");
        buffer.append("<strong>").append("Error Code: ").append("</strong></br>");
        buffer.append(notification.getErrorCode()).append("</br>");
        buffer.append("<strong>").append("More Information: ").append("</strong></br>");
        buffer.append(notification.getMoreInfo().toString()).append("</br>");
        buffer.append("<strong>").append("Message Text: ").append("</strong></br>");
        buffer.append(notification.getMessageText()).append("</br>");
        buffer.append("<strong>").append("Message Date: ").append("</strong></br>");
        buffer.append(notification.getMessageDate().toString()).append("</br>");
        buffer.append("<strong>").append("Request URL: ").append("</strong></br>");
        buffer.append(notification.getRequestUrl().toString()).append("</br>");
        buffer.append("<strong>").append("Request Method: ").append("</strong></br>");
        buffer.append(notification.getRequestMethod()).append("</br>");
        buffer.append("<strong>").append("Request Variables: ").append("</strong></br>");
        buffer.append(notification.getRequestVariables()).append("</br>");
        buffer.append("<strong>").append("Response Headers: ").append("</strong></br>");
        buffer.append(notification.getResponseHeaders()).append("</br>");
        buffer.append("<strong>").append("Response Body: ").append("</strong></br>");
        buffer.append(notification.getResponseBody()).append("</br>");
        Mail email = new Mail(EMAIL_SENDER, this.emailAddress, EMAIL_SUBJECT, buffer.toString());
        this.mailer.tell((Object)email, this.self());
    }

    void callback() {
        if (this.statusCallback != null) {
            if (this.statusCallbackMethod == null) {
                this.statusCallbackMethod = "POST";
            }
            List<NameValuePair> parameters = this.parameters();
            this.request = new HttpRequestDescriptor(this.statusCallback, this.statusCallbackMethod, parameters);
            this.downloader.tell((Object)this.request, null);
        }
    }

    public void onReceive(Object message) throws Exception {
        Class<?> klass = message.getClass();
        State state = this.fsm.state();
        ActorRef sender = this.sender();
        ActorRef source = this.self();
        if (this.logger.isInfoEnabled()) {
            this.logger.info(" ********** UssdInterpreter's Current State: " + state.toString());
            this.logger.info(" ********** UssdInterpreter's Processing Message: " + klass.getName());
        }
        if (StartInterpreter.class.equals(klass)) {
            this.ussdCall = ((StartInterpreter)message).resource();
            this.fsm.transition(message, this.acquiringCallInfo);
        } else if (message instanceof SipServletRequest) {
            SipServletRequest request = (SipServletRequest)message;
            String method = request.getMethod();
            if ("INFO".equalsIgnoreCase(method)) {
                this.fsm.transition(message, this.processingInfoRequest);
            } else if ("ACK".equalsIgnoreCase(method)) {
                this.fsm.transition(message, this.downloadingRcml);
            } else if ("BYE".equalsIgnoreCase(method)) {
                this.fsm.transition(message, this.disconnecting);
            } else if ("CANCEL".equalsIgnoreCase(method)) {
                this.fsm.transition(message, this.cancelling);
            }
        } else if (CallStateChanged.class.equals(klass)) {
            CallStateChanged event = (CallStateChanged)message;
            this.callState = event.state();
            if (CallStateChanged.State.RINGING == event.state()) {
                this.logger.info("CallStateChanged.State.RINGING");
            } else if (CallStateChanged.State.IN_PROGRESS == event.state()) {
                this.logger.info("CallStateChanged.State.IN_PROGRESS");
            } else if (CallStateChanged.State.NO_ANSWER == event.state() || CallStateChanged.State.COMPLETED == event.state() || CallStateChanged.State.FAILED == event.state() || CallStateChanged.State.CANCELED == event.state()) {
                this.logger.info("CallStateChanged.State.NO_ANSWER OR  CallStateChanged.State.COMPLETED OR CallStateChanged.State.FAILED or CallStateChanged.State.CANCELED");
                this.fsm.transition(message, this.finished);
            } else if (CallStateChanged.State.BUSY == event.state()) {
                this.logger.info("CallStateChanged.State.BUSY");
            }
        } else if (CallResponse.class.equals(klass)) {
            if (this.acquiringCallInfo.equals((Object)state)) {
                CallResponse response = (CallResponse)message;
                if (sender == this.ussdCall) {
                    this.callInfo = (CallInfo)response.get();
                } else {
                    this.outboundCallInfo = (CallInfo)response.get();
                }
                String direction = this.callInfo.direction();
                if ("inbound".equals(direction)) {
                    this.ussdCall.tell((Object)new Answer(), source);
                } else {
                    this.fsm.transition(message, this.downloadingRcml);
                }
            }
        } else if (DownloaderResponse.class.equals(klass)) {
            DownloaderResponse response = (DownloaderResponse)message;
            if (response.succeeded() && 200 == ((HttpResponseDescriptor)response.get()).getStatusCode()) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Rcml URI : " + ((HttpResponseDescriptor)response.get()).getURI() + "response succeeded " + response.succeeded() + ", statusCode " + ((HttpResponseDescriptor)response.get()).getStatusCode());
                }
                this.fsm.transition(message, this.ready);
            } else if (response.succeeded() && 404 == ((HttpResponseDescriptor)response.get()).getStatusCode()) {
                this.fsm.transition(message, this.notFound);
            } else if (this.downloadingRcml.equals((Object)state)) {
                if (this.fallbackUrl != null) {
                    this.fsm.transition(message, this.downloadingFallbackRcml);
                } else {
                    this.fsm.transition(message, this.finished);
                }
            } else {
                this.fsm.transition(message, this.finished);
            }
        } else if (Tag.class.equals(klass)) {
            Tag verb = (Tag)message;
            if ("Language".equals(verb.name())) {
                if (this.ussdLanguageTag == null) {
                    this.ussdLanguageTag = verb;
                    GetNextVerb next = GetNextVerb.instance();
                    this.parser.tell((Object)next, source);
                } else {
                    this.invalidVerb(verb);
                }
                return;
            }
            if ("UssdMessage".equals(verb.name())) {
                this.ussdMessageTags.add(verb);
                GetNextVerb next = GetNextVerb.instance();
                this.parser.tell((Object)next, source);
                return;
            }
            if ("UssdCollect".equals(verb.name())) {
                if (this.ussdCollectTag == null) {
                    this.ussdCollectTag = verb;
                    GetNextVerb next = GetNextVerb.instance();
                    this.parser.tell((Object)next, source);
                } else {
                    this.invalidVerb(verb);
                }
                return;
            }
            this.invalidVerb(verb);
        } else if (End.class.equals(klass)) {
            this.fsm.transition(message, this.preparingMessage);
        }
    }

    private StringBuffer processUssdMessageTags(Queue<Tag> messageTags) {
        StringBuffer message = new StringBuffer();
        while (!messageTags.isEmpty()) {
            Tag tag = messageTags.poll();
            if (tag != null) {
                message.append(tag.text());
                if (messageTags.isEmpty()) continue;
                message.append("\n");
                continue;
            }
            return message;
        }
        return message;
    }

    public void postStop() {
        this.logger.info("UssdInterpreter postStop");
        if (this.ussdCall != null) {
            this.getContext().stop(this.ussdCall);
        }
        if (this.outboundCall != null) {
            this.getContext().stop(this.outboundCall);
        }
        if (this.downloader != null) {
            this.getContext().stop(this.downloader);
        }
        if (this.parser != null) {
            this.getContext().stop(this.parser);
        }
        if (this.mailer != null) {
            this.getContext().stop(this.mailer);
        }
        super.postStop();
    }

    private final class Finished
    extends AbstractAction {
        public Finished(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            UssdInterpreter.this.logger.info("In Finished state");
            Class<?> klass = message.getClass();
            if (CallStateChanged.class.equals(klass)) {
                CallStateChanged event = (CallStateChanged)message;
                UssdInterpreter.this.callState = event.state();
                if (UssdInterpreter.this.callRecord != null) {
                    UssdInterpreter.this.callRecord = UssdInterpreter.this.callRecord.setStatus(UssdInterpreter.this.callState.toString());
                    DateTime end = DateTime.now();
                    UssdInterpreter.this.callRecord = UssdInterpreter.this.callRecord.setEndTime(end);
                    int seconds = (int)(end.getMillis() - UssdInterpreter.this.callRecord.getStartTime().getMillis()) / 1000;
                    UssdInterpreter.this.callRecord = UssdInterpreter.this.callRecord.setDuration(Integer.valueOf(seconds));
                    CallDetailRecordsDao records = UssdInterpreter.this.storage.getCallDetailRecordsDao();
                    records.updateCallDetailRecord(UssdInterpreter.this.callRecord);
                }
                UssdInterpreter.this.callback();
            }
            UssdInterpreter.this.context().stop(UssdInterpreter.this.self());
        }
    }

    private final class Disconnecting
    extends AbstractAction {
        public Disconnecting(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            UssdInterpreter.this.logger.info("Disconnecting state");
            Class<?> klass = message.getClass();
            if (message instanceof SipServletRequest) {
                SipServletRequest request = (SipServletRequest)message;
                if (UssdInterpreter.this.ussdCall != null) {
                    UssdInterpreter.this.ussdCall.tell((Object)request, UssdInterpreter.this.self());
                }
                if (UssdInterpreter.this.outboundCall != null) {
                    UssdInterpreter.this.ussdCall.tell((Object)request, UssdInterpreter.this.self());
                }
            }
        }
    }

    private final class Cancelling
    extends AbstractAction {
        public Cancelling(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            UssdInterpreter.this.logger.info("Cancelling state");
            Class<?> klass = message.getClass();
            if (message instanceof SipServletRequest) {
                SipServletRequest request = (SipServletRequest)message;
                if (UssdInterpreter.this.ussdCall != null) {
                    UssdInterpreter.this.ussdCall.tell((Object)request, UssdInterpreter.this.self());
                }
                if (UssdInterpreter.this.outboundCall != null) {
                    UssdInterpreter.this.ussdCall.tell((Object)request, UssdInterpreter.this.self());
                }
            }
        }
    }

    private final class ProcessingInfoRequest
    extends AbstractAction {
        public ProcessingInfoRequest(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            UssdInterpreter.this.logger.info("UssdInterpreter Processing INFO request");
            NotificationsDao notifications = UssdInterpreter.this.storage.getNotificationsDao();
            SipServletRequest info = (SipServletRequest)message;
            SipServletResponse okay = info.createResponse(200);
            okay.send();
            UssdInfoRequest ussdInfoRequest = new UssdInfoRequest(info);
            String ussdText = ussdInfoRequest.getMessage();
            if (UssdInterpreter.this.ussdCollectAction != null && !UssdInterpreter.this.ussdCollectAction.isEmpty() && ussdText != null) {
                URI target = null;
                try {
                    target = URI.create(UssdInterpreter.this.ussdCollectAction);
                }
                catch (Exception exception) {
                    Notification notification = UssdInterpreter.this.notification(0, 11100, UssdInterpreter.this.ussdCollectAction + " is an invalid URI.");
                    notifications.addNotification(notification);
                    UssdInterpreter.this.sendMail(notification);
                    StopInterpreter stop = new StopInterpreter();
                    this.source.tell((Object)stop, this.source);
                    return;
                }
                URI base = UssdInterpreter.this.request.getUri();
                URI uri = UriUtils.resolve((URI)base, (URI)target);
                String method = "POST";
                Attribute attribute = null;
                try {
                    attribute = UssdInterpreter.this.verb.attribute("method");
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (attribute != null) {
                    method = attribute.value();
                    if (method != null && !method.isEmpty()) {
                        if (!"GET".equalsIgnoreCase(method) && !"POST".equalsIgnoreCase(method)) {
                            Notification notification = UssdInterpreter.this.notification(1, 14104, method + " is not a valid HTTP method for <Gather>");
                            notifications.addNotification(notification);
                            method = "POST";
                        }
                    } else {
                        method = "POST";
                    }
                }
                List<NameValuePair> parameters = UssdInterpreter.this.parameters();
                parameters.add((NameValuePair)new BasicNameValuePair("Digits", ussdText));
                UssdInterpreter.this.request = new HttpRequestDescriptor(uri, method, parameters);
                UssdInterpreter.this.downloader.tell((Object)UssdInterpreter.this.request, this.source);
                UssdInterpreter.this.ussdCollectTag = null;
                UssdInterpreter.this.ussdLanguageTag = null;
                UssdInterpreter.this.ussdMessageTags = new LinkedBlockingQueue<Tag>();
                return;
            }
            if (ussdInfoRequest.getUssdMessageType().equals((Object)UssdMessageType.unstructuredSSNotify_Response)) {
                UssdRestcommResponse ussdRestcommResponse = new UssdRestcommResponse();
                ussdRestcommResponse.setErrorCode("1");
                ussdRestcommResponse.setIsFinalMessage(true);
                UssdInterpreter.this.ussdCall.tell((Object)ussdRestcommResponse, this.source);
                return;
            }
            GetNextVerb next = GetNextVerb.instance();
            UssdInterpreter.this.parser.tell((Object)next, UssdInterpreter.this.self());
        }
    }

    private final class PreparingMessage
    extends AbstractAction {
        public PreparingMessage(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            UssdInterpreter.this.logger.info("Preparing the USSD Message");
            if (End.class.equals(message.getClass())) {
                Boolean hasCollect = false;
                UssdRestcommResponse ussdRestcommResponse = new UssdRestcommResponse();
                String language = "";
                if (UssdInterpreter.this.ussdLanguageTag == null) {
                    language = "en";
                    ussdRestcommResponse.setLanguage(language);
                } else {
                    language = UssdInterpreter.this.ussdLanguageTag.text();
                    ussdRestcommResponse.setLanguage(language);
                }
                if (language.equalsIgnoreCase("en")) {
                    UssdInterpreter.this.maxMessageLength = 182;
                    ussdRestcommResponse.setMessageLength(182);
                } else {
                    UssdInterpreter.this.maxMessageLength = 80;
                    ussdRestcommResponse.setMessageLength(80);
                }
                StringBuffer ussdText = UssdInterpreter.this.processUssdMessageTags(UssdInterpreter.this.ussdMessageTags);
                if (UssdInterpreter.this.ussdCollectTag != null) {
                    hasCollect = true;
                    UssdInterpreter.this.ussdCollectAction = UssdInterpreter.this.ussdCollectTag.attribute("action").value();
                    ussdRestcommResponse.setUssdCollectAction(UssdInterpreter.this.ussdCollectAction);
                    ConcurrentLinkedQueue children = new ConcurrentLinkedQueue(UssdInterpreter.this.ussdCollectTag.children());
                    if (children != null && children.size() > 0) {
                        ussdText.append(UssdInterpreter.this.processUssdMessageTags(children));
                    } else if (UssdInterpreter.this.ussdCollectTag.text() != null) {
                        ussdText.append(UssdInterpreter.this.ussdCollectTag.text());
                    }
                }
                if (ussdText.length() > UssdInterpreter.this.maxMessageLength) {
                    String errorString = "Error while preparing the USSD response. Ussd text length more than the permitted for the selected language: " + UssdInterpreter.this.maxMessageLength;
                    Notification notification = UssdInterpreter.this.notification(0, 11100, errorString);
                    if (notification != null) {
                        NotificationsDao notifications = UssdInterpreter.this.storage.getNotificationsDao();
                        notifications.addNotification(notification);
                        UssdInterpreter.this.sendMail(notification);
                    }
                    UssdInterpreter.this.logger.info(errorString);
                    ussdText = new StringBuffer();
                    ussdText.append("Error while preparing the response.\nMessage length exceeds the maximum.");
                }
                ussdRestcommResponse.setMessage(ussdText.toString());
                UssdInterpreter.this.logger.info("UssdMessage prepared, hasCollect: " + hasCollect);
                UssdInterpreter.this.logger.info("UssdMessage prepared: " + "UssdMessage".toString() + " hasCollect: " + hasCollect);
                if (UssdInterpreter.this.callInfo.direction().equalsIgnoreCase("inbound")) {
                    if (hasCollect.booleanValue()) {
                        ussdRestcommResponse.setMessageType(UssdMessageType.unstructuredSSRequest_Request);
                        ussdRestcommResponse.setIsFinalMessage(false);
                    } else {
                        ussdRestcommResponse.setMessageType(UssdMessageType.processUnstructuredSSRequest_Response);
                        ussdRestcommResponse.setIsFinalMessage(true);
                    }
                } else if (hasCollect.booleanValue()) {
                    ussdRestcommResponse.setMessageType(UssdMessageType.unstructuredSSRequest_Request);
                    ussdRestcommResponse.setIsFinalMessage(false);
                } else {
                    ussdRestcommResponse.setMessageType(UssdMessageType.unstructuredSSNotify_Request);
                    if (ussdRestcommResponse.getErrorCode() != null) {
                        ussdRestcommResponse.setIsFinalMessage(true);
                    } else {
                        ussdRestcommResponse.setIsFinalMessage(false);
                    }
                }
                UssdInterpreter.this.logger.info("UssdRestcommResponse message prepared: " + ussdRestcommResponse);
                UssdInterpreter.this.ussdCall.tell((Object)ussdRestcommResponse, this.source);
            }
        }
    }

    private final class NotFound
    extends AbstractAction {
        public NotFound(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            UssdInterpreter.this.logger.info("In Not Found State");
            DownloaderResponse response = (DownloaderResponse)message;
            if (UssdInterpreter.this.logger.isDebugEnabled()) {
                UssdInterpreter.this.logger.debug("response succeeded " + response.succeeded() + ", statusCode " + ((HttpResponseDescriptor)response.get()).getStatusCode());
            }
            Notification notification = UssdInterpreter.this.notification(1, 21402, "URL Not Found : " + ((HttpResponseDescriptor)response.get()).getURI());
            NotificationsDao notifications = UssdInterpreter.this.storage.getNotificationsDao();
            notifications.addNotification(notification);
            UssdInterpreter.this.ussdCall.tell((Object)new org.mobicents.servlet.restcomm.telephony.NotFound(), this.source);
        }
    }

    private final class Ready
    extends AbstractAction {
        public Ready(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            UssdInterpreter.this.logger.info("In Ready state");
            UntypedActorContext context = UssdInterpreter.this.getContext();
            State state = UssdInterpreter.this.fsm.state();
            if (UssdInterpreter.this.downloadingRcml.equals((Object)state) || UssdInterpreter.this.downloadingFallbackRcml.equals((Object)state) || UssdInterpreter.this.processingInfoRequest.equals((Object)state)) {
                String type;
                UssdInterpreter.this.response = (HttpResponseDescriptor)((DownloaderResponse)message).get();
                if (UssdInterpreter.this.parser != null) {
                    context.stop(UssdInterpreter.this.parser);
                    UssdInterpreter.this.parser = null;
                }
                if ((type = UssdInterpreter.this.response.getContentType()).contains("text/xml") || type.contains("application/xml") || type.contains("text/html")) {
                    UssdInterpreter.this.parser = UssdInterpreter.this.parser(UssdInterpreter.this.response.getContentAsString());
                } else if (type.contains("text/plain")) {
                    UssdInterpreter.this.parser = UssdInterpreter.this.parser("<UssdMessage>" + UssdInterpreter.this.response.getContentAsString() + "</UssdMessage>");
                } else {
                    StopInterpreter stop = new StopInterpreter();
                    this.source.tell((Object)stop, this.source);
                    return;
                }
            }
            GetNextVerb next = GetNextVerb.instance();
            UssdInterpreter.this.parser.tell((Object)next, this.source);
        }
    }

    private final class DownloadingFallbackRcml
    extends AbstractAction {
        public DownloadingFallbackRcml(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            UssdInterpreter.this.logger.info("Downloading Fallback RCML");
            Class<?> klass = message.getClass();
            if (DownloaderResponse.class.equals(klass)) {
                DownloaderResponse result = (DownloaderResponse)message;
                Throwable cause = result.cause();
                Notification notification = null;
                if (cause instanceof ClientProtocolException) {
                    notification = UssdInterpreter.this.notification(0, 11206, cause.getMessage());
                } else if (cause instanceof IOException) {
                    notification = UssdInterpreter.this.notification(0, 11205, cause.getMessage());
                } else if (cause instanceof URISyntaxException) {
                    notification = UssdInterpreter.this.notification(0, 11100, cause.getMessage());
                }
                if (notification != null) {
                    NotificationsDao notifications = UssdInterpreter.this.storage.getNotificationsDao();
                    notifications.addNotification(notification);
                    UssdInterpreter.this.sendMail(notification);
                }
            }
            List<NameValuePair> parameters = UssdInterpreter.this.parameters();
            UssdInterpreter.this.request = new HttpRequestDescriptor(UssdInterpreter.this.fallbackUrl, UssdInterpreter.this.fallbackMethod, parameters);
            UssdInterpreter.this.downloader.tell((Object)UssdInterpreter.this.request, this.source);
        }
    }

    private final class DownloadingRcml
    extends AbstractAction {
        public DownloadingRcml(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            UssdInterpreter.this.logger.info("Downloading RCML");
            Class<?> klass = message.getClass();
            CallDetailRecordsDao records = UssdInterpreter.this.storage.getCallDetailRecordsDao();
            if (CallResponse.class.equals(klass)) {
                CallResponse response = (CallResponse)message;
                UssdInterpreter.this.callInfo = (CallInfo)response.get();
                UssdInterpreter.this.callState = UssdInterpreter.this.callInfo.state();
                if (UssdInterpreter.this.callInfo.direction().equals("inbound")) {
                    CallDetailRecord.Builder builder = CallDetailRecord.builder();
                    builder.setSid(UssdInterpreter.this.callInfo.sid());
                    builder.setDateCreated(UssdInterpreter.this.callInfo.dateCreated());
                    builder.setAccountSid(UssdInterpreter.this.accountId);
                    builder.setTo(UssdInterpreter.this.callInfo.to());
                    builder.setCallerName(UssdInterpreter.this.callInfo.fromName());
                    builder.setFrom(UssdInterpreter.this.callInfo.from());
                    builder.setForwardedFrom(UssdInterpreter.this.callInfo.forwardedFrom());
                    builder.setPhoneNumberSid(UssdInterpreter.this.phoneId);
                    builder.setStatus(UssdInterpreter.this.callState.toString());
                    DateTime now = DateTime.now();
                    builder.setStartTime(now);
                    builder.setDirection(UssdInterpreter.this.callInfo.direction());
                    builder.setApiVersion(UssdInterpreter.this.version);
                    builder.setPrice(new BigDecimal("0.00"));
                    builder.setPriceUnit(Currency.getInstance("USD"));
                    StringBuilder buffer = new StringBuilder();
                    buffer.append("/").append(UssdInterpreter.this.version).append("/Accounts/");
                    buffer.append(UssdInterpreter.this.accountId.toString()).append("/Calls/");
                    buffer.append(UssdInterpreter.this.callInfo.sid().toString());
                    URI uri = URI.create(buffer.toString());
                    builder.setUri(uri);
                    builder.setCallPath(UssdInterpreter.this.ussdCall.path().toString());
                    UssdInterpreter.this.callRecord = builder.build();
                    records.addCallDetailRecord(UssdInterpreter.this.callRecord);
                    UssdInterpreter.this.callback();
                }
            }
            List<NameValuePair> parameters = UssdInterpreter.this.parameters();
            UssdInterpreter.this.request = new HttpRequestDescriptor(UssdInterpreter.this.url, UssdInterpreter.this.method, parameters);
            UssdInterpreter.this.downloader.tell((Object)UssdInterpreter.this.request, this.source);
        }
    }

    final class AcquiringCallInfo
    extends AbstractAction {
        public AcquiringCallInfo(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            UssdInterpreter.this.logger.info("Acquiring Call Info");
            UssdInterpreter.this.ussdCall.tell((Object)new Observe(this.source), this.source);
            UssdInterpreter.this.ussdCall.tell((Object)new GetCallInfo(), this.source);
        }
    }

    final class ObserveCall
    extends AbstractAction {
        public ObserveCall(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            UssdInterpreter.this.ussdCall.tell((Object)new Observe(this.source), this.source);
        }
    }

    abstract class AbstractAction
    implements Action {
        protected final ActorRef source;

        public AbstractAction(ActorRef source) {
            this.source = source;
        }
    }
}

