/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.deployment;

import java.util.jar.Manifest;
import org.jboss.as.osgi.OSGiConstants;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.osgi.metadata.OSGiManifestBuilder;
import org.jboss.osgi.metadata.OSGiMetaData;
import org.jboss.osgi.metadata.OSGiMetaDataBuilder;

public class OSGiManifestStructureProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit depUnit = phaseContext.getDeploymentUnit();
        if (depUnit.hasAttachment(Attachments.OSGI_MANIFEST) || depUnit.hasAttachment(OSGiConstants.OSGI_METADATA_KEY)) {
            return;
        }
        ResourceRoot deploymentRoot = (ResourceRoot)depUnit.getAttachment(Attachments.DEPLOYMENT_ROOT);
        if (deploymentRoot == null) {
            return;
        }
        Manifest manifest = (Manifest)deploymentRoot.getAttachment(Attachments.MANIFEST);
        if (OSGiManifestBuilder.isValidBundleManifest((Manifest)manifest)) {
            depUnit.putAttachment(Attachments.OSGI_MANIFEST, (Object)manifest);
            OSGiMetaData metadata = OSGiMetaDataBuilder.load((Manifest)manifest);
            depUnit.putAttachment(OSGiConstants.OSGI_METADATA_KEY, (Object)metadata);
        }
    }

    public void undeploy(DeploymentUnit deploymentUnit) {
        deploymentUnit.removeAttachment(Attachments.OSGI_MANIFEST);
        deploymentUnit.removeAttachment(OSGiConstants.OSGI_METADATA_KEY);
    }
}

