/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.restcomm.entities;

import java.math.BigDecimal;
import java.net.URI;
import java.util.Currency;
import org.joda.time.DateTime;
import org.mobicents.servlet.restcomm.annotations.concurrency.Immutable;
import org.mobicents.servlet.restcomm.annotations.concurrency.NotThreadSafe;
import org.mobicents.servlet.restcomm.entities.Sid;

@Immutable
public final class SmsMessage {
    public static final int MAX_SIZE = 160;
    private final Sid sid;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;
    private final DateTime dateSent;
    private final Sid accountSid;
    private final String sender;
    private final String recipient;
    private final String body;
    private final Status status;
    private final Direction direction;
    private final BigDecimal price;
    private final Currency priceUnit;
    private final String apiVersion;
    private final URI uri;

    public SmsMessage(Sid sid, DateTime dateCreated, DateTime dateUpdated, DateTime dateSent, Sid accountSid, String sender, String recipient, String body, Status status, Direction direction, BigDecimal price, Currency priceUnit, String apiVersion, URI uri) {
        this.sid = sid;
        this.dateCreated = dateCreated;
        this.dateUpdated = dateUpdated;
        this.dateSent = dateSent;
        this.accountSid = accountSid;
        this.sender = sender;
        this.recipient = recipient;
        this.body = body;
        this.status = status;
        this.direction = direction;
        this.price = price;
        this.priceUnit = priceUnit;
        this.apiVersion = apiVersion;
        this.uri = uri;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Sid getSid() {
        return this.sid;
    }

    public DateTime getDateCreated() {
        return this.dateCreated;
    }

    public DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public DateTime getDateSent() {
        return this.dateSent;
    }

    public Sid getAccountSid() {
        return this.accountSid;
    }

    public String getSender() {
        return this.sender;
    }

    public String getRecipient() {
        return this.recipient;
    }

    public String getBody() {
        return this.body;
    }

    public Status getStatus() {
        return this.status;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public BigDecimal getPrice() {
        return this.price == null ? new BigDecimal("0.0") : this.price;
    }

    public Currency getPriceUnit() {
        return this.priceUnit == null ? Currency.getInstance("USD") : this.priceUnit;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public URI getUri() {
        return this.uri;
    }

    public SmsMessage setDateSent(DateTime dateSent) {
        return new SmsMessage(this.sid, this.dateCreated, DateTime.now(), dateSent, this.accountSid, this.sender, this.recipient, this.body, this.status, this.direction, this.price, this.priceUnit, this.apiVersion, this.uri);
    }

    public SmsMessage setStatus(Status status) {
        return new SmsMessage(this.sid, this.dateCreated, DateTime.now(), this.dateSent, this.accountSid, this.sender, this.recipient, this.body, status, this.direction, this.price, this.priceUnit, this.apiVersion, this.uri);
    }

    public static enum Status {
        QUEUED("queued"),
        SENDING("sending"),
        SENT("sent"),
        FAILED("failed"),
        RECEIVED("received");

        private final String text;

        private Status(String text) {
            this.text = text;
        }

        public static Status getStatusValue(String text) {
            Status[] values;
            for (Status value : values = Status.values()) {
                if (!value.toString().equals(text)) continue;
                return value;
            }
            throw new IllegalArgumentException(text + " is not a valid status.");
        }

        public String toString() {
            return this.text;
        }
    }

    public static enum Direction {
        INBOUND("inbound"),
        OUTBOUND_API("outbound-api"),
        OUTBOUND_CALL("outbound-call"),
        OUTBOUND_REPLY("outbound-reply");

        private final String text;

        private Direction(String text) {
            this.text = text;
        }

        public static Direction getDirectionValue(String text) {
            Direction[] values;
            for (Direction value : values = Direction.values()) {
                if (!value.toString().equals(text)) continue;
                return value;
            }
            throw new IllegalArgumentException(text + " is not a valid direction.");
        }

        public String toString() {
            return this.text;
        }
    }

    @NotThreadSafe
    public static final class Builder {
        private Sid sid;
        private DateTime dateSent;
        private Sid accountSid;
        private String sender;
        private String recipient;
        private String body;
        private Status status;
        private Direction direction;
        private BigDecimal price;
        private Currency priceUnit;
        private String apiVersion;
        private URI uri;

        private Builder() {
        }

        public SmsMessage build() {
            DateTime now = DateTime.now();
            return new SmsMessage(this.sid, now, now, this.dateSent, this.accountSid, this.sender, this.recipient, this.body, this.status, this.direction, this.price, this.priceUnit, this.apiVersion, this.uri);
        }

        public void setSid(Sid sid) {
            this.sid = sid;
        }

        public void setDateSent(DateTime dateSent) {
            this.dateSent = dateSent;
        }

        public void setAccountSid(Sid accountSid) {
            this.accountSid = accountSid;
        }

        public void setSender(String sender) {
            this.sender = sender;
        }

        public void setRecipient(String recipient) {
            this.recipient = recipient;
        }

        public void setBody(String body) {
            this.body = body;
        }

        public void setStatus(Status status) {
            this.status = status;
        }

        public void setDirection(Direction direction) {
            this.direction = direction;
        }

        public void setPrice(BigDecimal price) {
            this.price = price;
        }

        public void setPriceUnit(Currency priceUnit) {
            this.priceUnit = priceUnit;
        }

        public void setApiVersion(String apiVersion) {
            this.apiVersion = apiVersion;
        }

        public void setUri(URI uri) {
            this.uri = uri;
        }
    }
}

