/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.restcomm.entities;

import java.util.UUID;
import java.util.regex.Pattern;
import org.apache.shiro.crypto.hash.Md5Hash;
import org.mobicents.servlet.restcomm.annotations.concurrency.Immutable;

@Immutable
public final class Sid {
    public static final Pattern pattern = Pattern.compile("[a-zA-Z0-9]{34}");
    private final String id;
    private static final Sid INVALID_SID = new Sid("IN00000000000000000000000000000000");

    public Sid(String id) throws IllegalArgumentException {
        if (!pattern.matcher(id).matches()) {
            throw new IllegalArgumentException(id + " is an INVALID_SID sid value.");
        }
        this.id = id;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Sid other = (Sid)object;
        return this.toString().equals(other.toString());
    }

    public static Sid generate(Type type, String string) {
        String token = new Md5Hash((Object)string).toString();
        switch (type) {
            case ACCOUNT: {
                return new Sid("AC" + token);
            }
        }
        return Sid.generate(type);
    }

    public static Sid generate(Type type) {
        String uuid = UUID.randomUUID().toString().replace("-", "");
        switch (type) {
            case ACCOUNT: {
                return new Sid("AC" + uuid);
            }
            case APPLICATION: {
                return new Sid("AP" + uuid);
            }
            case ANNOUNCEMENT: {
                return new Sid("AN" + uuid);
            }
            case CALL: {
                return new Sid("CA" + uuid);
            }
            case CLIENT: {
                return new Sid("CL" + uuid);
            }
            case CONFERENCE: {
                return new Sid("CF" + uuid);
            }
            case GATEWAY: {
                return new Sid("GW" + uuid);
            }
            case INVALID: {
                return INVALID_SID;
            }
            case NOTIFICATION: {
                return new Sid("NO" + uuid);
            }
            case PHONE_NUMBER: {
                return new Sid("PN" + uuid);
            }
            case RECORDING: {
                return new Sid("RE" + uuid);
            }
            case REGISTRATION: {
                return new Sid("RG" + uuid);
            }
            case SHORT_CODE: {
                return new Sid("SC" + uuid);
            }
            case SMS_MESSAGE: {
                return new Sid("SM" + uuid);
            }
            case TRANSCRIPTION: {
                return new Sid("TR" + uuid);
            }
        }
        return null;
    }

    public int hashCode() {
        int prime = 5;
        int result = 1;
        result = 5 * result + this.id.hashCode();
        return result;
    }

    public String toString() {
        return this.id;
    }

    public static enum Type {
        ACCOUNT,
        APPLICATION,
        ANNOUNCEMENT,
        CALL,
        CLIENT,
        CONFERENCE,
        GATEWAY,
        INVALID,
        NOTIFICATION,
        PHONE_NUMBER,
        RECORDING,
        REGISTRATION,
        SHORT_CODE,
        SMS_MESSAGE,
        TRANSCRIPTION;

    }
}

