/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.restcomm.entities;

import org.joda.time.DateTime;
import org.mobicents.servlet.restcomm.annotations.concurrency.Immutable;
import org.mobicents.servlet.restcomm.entities.Sid;

@Immutable
public final class Registration
implements Comparable<Registration> {
    private final Sid sid;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;
    private final DateTime dateExpires;
    private final String addressOfRecord;
    private final String displayName;
    private final String userName;
    private final int timeToLive;
    private final String location;
    private final String userAgent;

    public Registration(Sid sid, DateTime dateCreated, DateTime dateUpdated, String addressOfRecord, String displayName, String userName, String userAgent, int timeToLive, String location) {
        this(sid, dateCreated, dateUpdated, DateTime.now().plusSeconds(timeToLive), addressOfRecord, displayName, userName, userAgent, timeToLive, location);
    }

    public Registration(Sid sid, DateTime dateCreated, DateTime dateUpdated, DateTime dateExpires, String addressOfRecord, String displayName, String userName, String userAgent, int timeToLive, String location) {
        this.sid = sid;
        this.dateCreated = dateCreated;
        this.dateUpdated = dateUpdated;
        this.dateExpires = dateExpires;
        this.addressOfRecord = addressOfRecord;
        this.displayName = displayName;
        this.userName = userName;
        this.location = location;
        this.userAgent = userAgent;
        this.timeToLive = timeToLive;
    }

    public Sid getSid() {
        return this.sid;
    }

    public DateTime getDateCreated() {
        return this.dateCreated;
    }

    public DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public DateTime getDateExpires() {
        return this.dateExpires;
    }

    public String getAddressOfRecord() {
        return this.addressOfRecord;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getLocation() {
        return this.location;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public int getTimeToLive() {
        return this.timeToLive;
    }

    public Registration setTimeToLive(int timeToLive) {
        DateTime now = DateTime.now();
        return new Registration(this.sid, this.dateCreated, now, now.plusSeconds(timeToLive), this.addressOfRecord, this.displayName, this.userName, this.userAgent, timeToLive, this.location);
    }

    @Override
    public int compareTo(Registration registration) {
        if (this.getDateUpdated().toDate().getTime() > registration.getDateUpdated().toDate().getTime()) {
            return -1;
        }
        return 1;
    }
}

