/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.restcomm.entities;

import java.net.URI;
import org.joda.time.DateTime;
import org.mobicents.servlet.restcomm.annotations.concurrency.Immutable;
import org.mobicents.servlet.restcomm.annotations.concurrency.NotThreadSafe;
import org.mobicents.servlet.restcomm.entities.Sid;

@Immutable
public final class Recording {
    private final Sid sid;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;
    private final Sid accountSid;
    private final Sid callSid;
    private final Double duration;
    private final String apiVersion;
    private URI uri;

    public Recording(Sid sid, DateTime dateCreated, DateTime dateUpdated, Sid accountSid, Sid callSid, Double duration, String apiVersion, URI uri) {
        this.sid = sid;
        this.dateCreated = dateCreated;
        this.dateUpdated = dateUpdated;
        this.accountSid = accountSid;
        this.callSid = callSid;
        this.duration = duration;
        this.apiVersion = apiVersion;
        this.uri = uri;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Sid getSid() {
        return this.sid;
    }

    public DateTime getDateCreated() {
        return this.dateCreated;
    }

    public DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public Sid getAccountSid() {
        return this.accountSid;
    }

    public Sid getCallSid() {
        return this.callSid;
    }

    public Double getDuration() {
        return this.duration;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public URI getUri() {
        return this.uri;
    }

    public Recording updateUri(URI newUri) {
        this.uri = newUri;
        return this;
    }

    @NotThreadSafe
    public static final class Builder {
        private Sid sid;
        private Sid accountSid;
        private Sid callSid;
        private Double duration;
        private String apiVersion;
        private URI uri;

        private Builder() {
        }

        public Recording build() {
            DateTime now = DateTime.now();
            return new Recording(this.sid, now, now, this.accountSid, this.callSid, this.duration, this.apiVersion, this.uri);
        }

        public void setSid(Sid sid) {
            this.sid = sid;
        }

        public void setAccountSid(Sid accountSid) {
            this.accountSid = accountSid;
        }

        public void setCallSid(Sid callSid) {
            this.callSid = callSid;
        }

        public void setDuration(double duration) {
            this.duration = duration;
        }

        public void setApiVersion(String apiVersion) {
            this.apiVersion = apiVersion;
        }

        public void setUri(URI uri) {
            this.uri = uri;
        }
    }
}

