/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.restcomm.entities;

import java.io.Serializable;
import java.net.URI;
import org.joda.time.DateTime;
import org.mobicents.servlet.restcomm.annotations.concurrency.Immutable;
import org.mobicents.servlet.restcomm.annotations.concurrency.NotThreadSafe;
import org.mobicents.servlet.restcomm.entities.Sid;

@Immutable
public final class Gateway
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Sid sid;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;
    private final String friendlyName;
    private final String password;
    private final String proxy;
    private final Boolean register;
    private final String userName;
    private final int timeToLive;
    private final URI uri;

    public Gateway(Sid sid, DateTime dateCreated, DateTime dateUpdated, String friendlyName, String password, String proxy, Boolean register, String userName, int timeToLive, URI uri) {
        this.sid = sid;
        this.dateCreated = dateCreated;
        this.dateUpdated = dateUpdated;
        this.friendlyName = friendlyName;
        this.password = password;
        this.proxy = proxy;
        this.register = register;
        this.userName = userName;
        this.timeToLive = timeToLive;
        this.uri = uri;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Sid getSid() {
        return this.sid;
    }

    public DateTime getDateCreated() {
        return this.dateCreated;
    }

    public DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public String getFriendlyName() {
        return this.friendlyName;
    }

    public String getPassword() {
        return this.password;
    }

    public String getProxy() {
        return this.proxy;
    }

    public String getUserName() {
        return this.userName;
    }

    public boolean register() {
        return this.register;
    }

    public int getTimeToLive() {
        return this.timeToLive;
    }

    public URI getUri() {
        return this.uri;
    }

    public Gateway setFriendlyName(String friendlyName) {
        return new Gateway(this.sid, this.dateCreated, DateTime.now(), friendlyName, this.password, this.proxy, this.register, this.userName, this.timeToLive, this.uri);
    }

    public Gateway setPassword(String password) {
        return new Gateway(this.sid, this.dateCreated, DateTime.now(), this.friendlyName, password, this.proxy, this.register, this.userName, this.timeToLive, this.uri);
    }

    public Gateway setProxy(String proxy) {
        return new Gateway(this.sid, this.dateCreated, DateTime.now(), this.friendlyName, this.password, proxy, this.register, this.userName, this.timeToLive, this.uri);
    }

    public Gateway setRegister(boolean register) {
        return new Gateway(this.sid, this.dateCreated, DateTime.now(), this.friendlyName, this.password, this.proxy, register, this.userName, this.timeToLive, this.uri);
    }

    public Gateway setUserName(String userName) {
        return new Gateway(this.sid, this.dateCreated, DateTime.now(), this.friendlyName, this.password, this.proxy, this.register, userName, this.timeToLive, this.uri);
    }

    public Gateway setTimeToLive(int timeToLive) {
        return new Gateway(this.sid, this.dateCreated, DateTime.now(), this.friendlyName, this.password, this.proxy, this.register, this.userName, timeToLive, this.uri);
    }

    @NotThreadSafe
    public static final class Builder {
        private Sid sid;
        private String friendlyName;
        private String password;
        private String proxy;
        private Boolean register;
        private String userName;
        private int timeToLive;
        private URI uri;

        private Builder() {
        }

        public Gateway build() {
            DateTime now = DateTime.now();
            return new Gateway(this.sid, now, now, this.friendlyName, this.password, this.proxy, this.register, this.userName, this.timeToLive, this.uri);
        }

        public void setSid(Sid sid) {
            this.sid = sid;
        }

        public void setFriendlyName(String friendlyName) {
            this.friendlyName = friendlyName;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public void setProxy(String proxy) {
            this.proxy = proxy;
        }

        public void setRegister(boolean register) {
            this.register = register;
        }

        public void setUserName(String userName) {
            this.userName = userName;
        }

        public void setTimeToLive(int timeToLive) {
            this.timeToLive = timeToLive;
        }

        public void setUri(URI uri) {
            this.uri = uri;
        }
    }
}

