/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.restcomm.entities;

import java.net.URI;
import org.joda.time.DateTime;
import org.mobicents.servlet.restcomm.annotations.concurrency.Immutable;
import org.mobicents.servlet.restcomm.annotations.concurrency.NotThreadSafe;
import org.mobicents.servlet.restcomm.entities.Sid;

@Immutable
public final class Client {
    public static final int DISABLED = 0;
    public static final int ENABLED = 1;
    private final Sid sid;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;
    private final Sid accountSid;
    private final String apiVersion;
    private final String friendlyName;
    private final String login;
    private final String password;
    private final Integer status;
    private final URI voiceUrl;
    private final String voiceMethod;
    private final URI voiceFallbackUrl;
    private final String voiceFallbackMethod;
    private final Sid voiceApplicationSid;
    private final URI uri;

    public Client(Sid sid, DateTime dateCreated, DateTime dateUpdated, Sid accountSid, String apiVersion, String friendlyName, String login, String password, Integer status, URI voiceUrl, String voiceMethod, URI voiceFallbackUrl, String voiceFallbackMethod, Sid voiceApplicationSid, URI uri) {
        this.sid = sid;
        this.dateCreated = dateCreated;
        this.dateUpdated = dateUpdated;
        this.accountSid = accountSid;
        this.apiVersion = apiVersion;
        this.friendlyName = friendlyName;
        this.login = login;
        this.password = password;
        this.status = status;
        this.voiceUrl = voiceUrl;
        this.voiceMethod = voiceMethod;
        this.voiceFallbackUrl = voiceFallbackUrl;
        this.voiceFallbackMethod = voiceFallbackMethod;
        this.voiceApplicationSid = voiceApplicationSid;
        this.uri = uri;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Sid getSid() {
        return this.sid;
    }

    public DateTime getDateCreated() {
        return this.dateCreated;
    }

    public DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public Sid getAccountSid() {
        return this.accountSid;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public String getFriendlyName() {
        return this.friendlyName;
    }

    public String getLogin() {
        return this.login;
    }

    public String getPassword() {
        return this.password;
    }

    public Integer getStatus() {
        return this.status;
    }

    public URI getVoiceUrl() {
        return this.voiceUrl;
    }

    public String getVoiceMethod() {
        return this.voiceMethod;
    }

    public URI getVoiceFallbackUrl() {
        return this.voiceFallbackUrl;
    }

    public String getVoiceFallbackMethod() {
        return this.voiceFallbackMethod;
    }

    public Sid getVoiceApplicationSid() {
        return this.voiceApplicationSid;
    }

    public URI getUri() {
        return this.uri;
    }

    public Client setFriendlyName(String friendlyName) {
        return new Client(this.sid, this.dateCreated, DateTime.now(), this.accountSid, this.apiVersion, friendlyName, this.login, this.password, this.status, this.voiceUrl, this.voiceMethod, this.voiceFallbackUrl, this.voiceFallbackMethod, this.voiceApplicationSid, this.uri);
    }

    public Client setPassword(String password) {
        return new Client(this.sid, this.dateCreated, DateTime.now(), this.accountSid, this.apiVersion, this.friendlyName, this.login, password, this.status, this.voiceUrl, this.voiceMethod, this.voiceFallbackUrl, this.voiceFallbackMethod, this.voiceApplicationSid, this.uri);
    }

    public Client setStatus(int status) {
        return new Client(this.sid, this.dateCreated, DateTime.now(), this.accountSid, this.apiVersion, this.friendlyName, this.login, this.password, status, this.voiceUrl, this.voiceMethod, this.voiceFallbackUrl, this.voiceFallbackMethod, this.voiceApplicationSid, this.uri);
    }

    public Client setVoiceUrl(URI voiceUrl) {
        return new Client(this.sid, this.dateCreated, DateTime.now(), this.accountSid, this.apiVersion, this.friendlyName, this.login, this.password, this.status, voiceUrl, this.voiceMethod, this.voiceFallbackUrl, this.voiceFallbackMethod, this.voiceApplicationSid, this.uri);
    }

    public Client setVoiceMethod(String voiceMethod) {
        return new Client(this.sid, this.dateCreated, DateTime.now(), this.accountSid, this.apiVersion, this.friendlyName, this.login, this.password, this.status, this.voiceUrl, voiceMethod, this.voiceFallbackUrl, this.voiceFallbackMethod, this.voiceApplicationSid, this.uri);
    }

    public Client setVoiceFallbackUrl(URI voiceFallbackUrl) {
        return new Client(this.sid, this.dateCreated, DateTime.now(), this.accountSid, this.apiVersion, this.friendlyName, this.login, this.password, this.status, this.voiceUrl, this.voiceMethod, voiceFallbackUrl, this.voiceFallbackMethod, this.voiceApplicationSid, this.uri);
    }

    public Client setVoiceFallbackMethod(String voiceFallbackMethod) {
        return new Client(this.sid, this.dateCreated, DateTime.now(), this.accountSid, this.apiVersion, this.friendlyName, this.login, this.password, this.status, this.voiceUrl, this.voiceMethod, this.voiceFallbackUrl, voiceFallbackMethod, this.voiceApplicationSid, this.uri);
    }

    public Client setVoiceApplicationSid(Sid voiceApplicationSid) {
        return new Client(this.sid, this.dateCreated, DateTime.now(), this.accountSid, this.apiVersion, this.friendlyName, this.login, this.password, this.status, this.voiceUrl, this.voiceMethod, this.voiceFallbackUrl, this.voiceFallbackMethod, voiceApplicationSid, this.uri);
    }

    @NotThreadSafe
    public static final class Builder {
        private Sid sid;
        private Sid accountSid;
        private String apiVersion;
        private String friendlyName;
        private String login;
        private String password;
        private int status;
        private URI voiceUrl;
        private String voiceMethod;
        private URI voiceFallbackUrl;
        private String voiceFallbackMethod;
        private Sid voiceApplicationSid;
        private URI uri;

        private Builder() {
        }

        public Client build() {
            DateTime now = DateTime.now();
            return new Client(this.sid, now, now, this.accountSid, this.apiVersion, this.friendlyName, this.login, this.password, this.status, this.voiceUrl, this.voiceMethod, this.voiceFallbackUrl, this.voiceFallbackMethod, this.voiceApplicationSid, this.uri);
        }

        public void setSid(Sid sid) {
            this.sid = sid;
        }

        public void setAccountSid(Sid accountSid) {
            this.accountSid = accountSid;
        }

        public void setApiVersion(String apiVersion) {
            this.apiVersion = apiVersion;
        }

        public void setFriendlyName(String friendlyName) {
            this.friendlyName = friendlyName;
        }

        public void setLogin(String login) {
            this.login = login;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public void setStatus(int status) {
            this.status = status;
        }

        public void setVoiceUrl(URI voiceUrl) {
            this.voiceUrl = voiceUrl;
        }

        public void setVoiceMethod(String voiceMethod) {
            this.voiceMethod = voiceMethod;
        }

        public void setVoiceFallbackUrl(URI voiceFallbackUrl) {
            this.voiceFallbackUrl = voiceFallbackUrl;
        }

        public void setVoiceFallbackMethod(String voiceFallbackMethod) {
            this.voiceFallbackMethod = voiceFallbackMethod;
        }

        public void setVoiceApplicationSid(Sid voiceApplicationSid) {
            this.voiceApplicationSid = voiceApplicationSid;
        }

        public void setUri(URI uri) {
            this.uri = uri;
        }
    }
}

