/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.restcomm.entities;

import java.math.BigDecimal;
import java.net.URI;
import java.util.Currency;
import org.joda.time.DateTime;
import org.mobicents.servlet.restcomm.annotations.concurrency.Immutable;
import org.mobicents.servlet.restcomm.annotations.concurrency.NotThreadSafe;
import org.mobicents.servlet.restcomm.entities.Sid;

@Immutable
public final class CallDetailRecord {
    private final Sid sid;
    private final Sid parentCallSid;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;
    private final Sid accountSid;
    private final String to;
    private final String from;
    private final Sid phoneNumberSid;
    private final String status;
    private final DateTime startTime;
    private final DateTime endTime;
    private final Integer duration;
    private final BigDecimal price;
    private final Currency priceUnit;
    private final String direction;
    private final String answeredBy;
    private final String apiVersion;
    private final String forwardedFrom;
    private final String callerName;
    private final URI uri;
    private final String callPath;

    public CallDetailRecord(Sid sid, Sid parentCallSid, DateTime dateCreated, DateTime dateUpdated, Sid accountSid, String to, String from, Sid phoneNumberSid, String status, DateTime startTime, DateTime endTime, Integer duration, BigDecimal price, Currency priceUnit, String direction, String answeredBy, String apiVersion, String forwardedFrom, String callerName, URI uri, String callPath) {
        this.sid = sid;
        this.parentCallSid = parentCallSid;
        this.dateCreated = dateCreated;
        this.dateUpdated = dateUpdated;
        this.accountSid = accountSid;
        this.to = to;
        this.from = from;
        this.phoneNumberSid = phoneNumberSid;
        this.status = status;
        this.startTime = startTime;
        this.endTime = endTime;
        this.duration = duration;
        this.price = price;
        this.priceUnit = priceUnit;
        this.direction = direction;
        this.answeredBy = answeredBy;
        this.apiVersion = apiVersion;
        this.forwardedFrom = forwardedFrom;
        this.callerName = callerName;
        this.uri = uri;
        this.callPath = callPath;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Sid getSid() {
        return this.sid;
    }

    public Sid getParentCallSid() {
        return this.parentCallSid;
    }

    public DateTime getDateCreated() {
        return this.dateCreated;
    }

    public DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public Sid getAccountSid() {
        return this.accountSid;
    }

    public String getTo() {
        return this.to;
    }

    public String getFrom() {
        return this.from;
    }

    public Sid getPhoneNumberSid() {
        return this.phoneNumberSid;
    }

    public String getStatus() {
        return this.status;
    }

    public DateTime getStartTime() {
        return this.startTime;
    }

    public DateTime getEndTime() {
        return this.endTime;
    }

    public Integer getDuration() {
        return this.duration;
    }

    public BigDecimal getPrice() {
        return this.price == null ? new BigDecimal("0.0") : this.price;
    }

    public Currency getPriceUnit() {
        return this.priceUnit == null ? Currency.getInstance("USD") : this.priceUnit;
    }

    public String getDirection() {
        return this.direction;
    }

    public String getAnsweredBy() {
        return this.answeredBy;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public String getForwardedFrom() {
        return this.forwardedFrom;
    }

    public String getCallerName() {
        return this.callerName;
    }

    public URI getUri() {
        return this.uri;
    }

    public String getCallPath() {
        return this.callPath;
    }

    public CallDetailRecord setStatus(String status) {
        return new CallDetailRecord(this.sid, this.parentCallSid, this.dateCreated, DateTime.now(), this.accountSid, this.to, this.from, this.phoneNumberSid, status, this.startTime, this.endTime, this.duration, this.price, this.priceUnit, this.direction, this.answeredBy, this.apiVersion, this.forwardedFrom, this.callerName, this.uri, this.callPath);
    }

    public CallDetailRecord setStartTime(DateTime startTime) {
        return new CallDetailRecord(this.sid, this.parentCallSid, this.dateCreated, DateTime.now(), this.accountSid, this.to, this.from, this.phoneNumberSid, this.status, startTime, this.endTime, this.duration, this.price, this.priceUnit, this.direction, this.answeredBy, this.apiVersion, this.forwardedFrom, this.callerName, this.uri, this.callPath);
    }

    public CallDetailRecord setEndTime(DateTime endTime) {
        return new CallDetailRecord(this.sid, this.parentCallSid, this.dateCreated, DateTime.now(), this.accountSid, this.to, this.from, this.phoneNumberSid, this.status, this.startTime, endTime, this.duration, this.price, this.priceUnit, this.direction, this.answeredBy, this.apiVersion, this.forwardedFrom, this.callerName, this.uri, this.callPath);
    }

    public CallDetailRecord setDuration(Integer duration) {
        return new CallDetailRecord(this.sid, this.parentCallSid, this.dateCreated, DateTime.now(), this.accountSid, this.to, this.from, this.phoneNumberSid, this.status, this.startTime, this.endTime, duration, this.price, this.priceUnit, this.direction, this.answeredBy, this.apiVersion, this.forwardedFrom, this.callerName, this.uri, this.callPath);
    }

    public CallDetailRecord setPrice(BigDecimal price) {
        return new CallDetailRecord(this.sid, this.parentCallSid, this.dateCreated, DateTime.now(), this.accountSid, this.to, this.from, this.phoneNumberSid, this.status, this.startTime, this.endTime, this.duration, price, this.priceUnit, this.direction, this.answeredBy, this.apiVersion, this.forwardedFrom, this.callerName, this.uri, this.callPath);
    }

    public CallDetailRecord setAnsweredBy(String answeredBy) {
        return new CallDetailRecord(this.sid, this.parentCallSid, this.dateCreated, DateTime.now(), this.accountSid, this.to, this.from, this.phoneNumberSid, this.status, this.startTime, this.endTime, this.duration, this.price, this.priceUnit, this.direction, answeredBy, this.apiVersion, this.forwardedFrom, this.callerName, this.uri, this.callPath);
    }

    @NotThreadSafe
    public static final class Builder {
        private Sid sid = null;
        private Sid parentCallSid = null;
        private DateTime dateCreated = null;
        private DateTime dateUpdated = DateTime.now();
        private Sid accountSid = null;
        private String to = null;
        private String from = null;
        private Sid phoneNumberSid = null;
        private String status = null;
        private DateTime startTime = null;
        private DateTime endTime = null;
        private Integer duration = null;
        private BigDecimal price = null;
        private Currency priceUnit;
        private String direction = null;
        private String answeredBy = null;
        private String apiVersion = null;
        private String forwardedFrom = null;
        private String callerName = null;
        private URI uri = null;
        private String callPath = null;

        private Builder() {
        }

        public CallDetailRecord build() {
            return new CallDetailRecord(this.sid, this.parentCallSid, this.dateCreated, this.dateUpdated, this.accountSid, this.to, this.from, this.phoneNumberSid, this.status, this.startTime, this.endTime, this.duration, this.price, this.priceUnit, this.direction, this.answeredBy, this.apiVersion, this.forwardedFrom, this.callerName, this.uri, this.callPath);
        }

        public void setSid(Sid sid) {
            this.sid = sid;
        }

        public void setParentCallSid(Sid parentCallSid) {
            this.parentCallSid = parentCallSid;
        }

        public void setDateCreated(DateTime dateCreated) {
            this.dateCreated = dateCreated;
        }

        public void setAccountSid(Sid accountSid) {
            this.accountSid = accountSid;
        }

        public void setTo(String to) {
            this.to = to;
        }

        public void setFrom(String from) {
            this.from = from;
        }

        public void setPhoneNumberSid(Sid phoneNumberSid) {
            this.phoneNumberSid = phoneNumberSid;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        public void setStartTime(DateTime startTime) {
            this.startTime = startTime;
        }

        public void setEndTime(DateTime endTime) {
            this.endTime = endTime;
        }

        public void setDuration(Integer duration) {
            this.duration = duration;
        }

        public void setPrice(BigDecimal price) {
            this.price = price;
        }

        public void setPriceUnit(Currency priceUnit) {
            this.priceUnit = priceUnit;
        }

        public void setDirection(String direction) {
            this.direction = direction;
        }

        public void setAnsweredBy(String answeredBy) {
            this.answeredBy = answeredBy;
        }

        public void setApiVersion(String apiVersion) {
            this.apiVersion = apiVersion;
        }

        public void setForwardedFrom(String forwardedFrom) {
            this.forwardedFrom = forwardedFrom;
        }

        public void setCallerName(String callerName) {
            this.callerName = callerName;
        }

        public void setUri(URI uri) {
            this.uri = uri;
        }

        public void setCallPath(String callPath) {
            this.callPath = callPath;
        }
    }
}

