/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.restcomm.entities;

import java.net.URI;
import org.joda.time.DateTime;
import org.mobicents.servlet.restcomm.annotations.concurrency.Immutable;
import org.mobicents.servlet.restcomm.entities.Sid;

@Immutable
public final class Application {
    private final Sid sid;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;
    private final String friendlyName;
    private final Sid accountSid;
    private final String apiVersion;
    private final URI voiceUrl;
    private final String voiceMethod;
    private final URI voiceFallbackUrl;
    private final String voiceFallbackMethod;
    private final URI statusCallback;
    private final String statusCallbackMethod;
    private final Boolean hasVoiceCallerIdLookup;
    private final URI smsUrl;
    private final String smsMethod;
    private final URI smsFallbackUrl;
    private final String smsFallbackMethod;
    private final URI smsStatusCallback;
    private final URI uri;

    public Application(Sid sid, DateTime dateCreated, DateTime dateUpdated, String friendlyName, Sid accountSid, String apiVersion, URI voiceUrl, String voiceMethod, URI voiceFallbackUrl, String voiceFallbackMethod, URI statusCallback, String statusCallbackMethod, Boolean hasVoiceCallerIdLookup, URI smsUrl, String smsMethod, URI smsFallbackUrl, String smsFallbackMethod, URI smsStatusCallback, URI uri) {
        this.sid = sid;
        this.dateCreated = dateCreated;
        this.dateUpdated = dateUpdated;
        this.friendlyName = friendlyName;
        this.accountSid = accountSid;
        this.apiVersion = apiVersion;
        this.hasVoiceCallerIdLookup = hasVoiceCallerIdLookup;
        this.voiceUrl = voiceUrl;
        this.voiceMethod = voiceMethod;
        this.voiceFallbackUrl = voiceFallbackUrl;
        this.voiceFallbackMethod = voiceFallbackMethod;
        this.statusCallback = statusCallback;
        this.statusCallbackMethod = statusCallbackMethod;
        this.smsUrl = smsUrl;
        this.smsMethod = smsMethod;
        this.smsFallbackUrl = smsFallbackUrl;
        this.smsFallbackMethod = smsFallbackMethod;
        this.smsStatusCallback = smsStatusCallback;
        this.uri = uri;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Sid getSid() {
        return this.sid;
    }

    public DateTime getDateCreated() {
        return this.dateCreated;
    }

    public DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public String getFriendlyName() {
        return this.friendlyName;
    }

    public Sid getAccountSid() {
        return this.accountSid;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public Boolean hasVoiceCallerIdLookup() {
        return this.hasVoiceCallerIdLookup;
    }

    public URI getVoiceUrl() {
        return this.voiceUrl;
    }

    public String getVoiceMethod() {
        return this.voiceMethod;
    }

    public URI getVoiceFallbackUrl() {
        return this.voiceFallbackUrl;
    }

    public String getVoiceFallbackMethod() {
        return this.voiceFallbackMethod;
    }

    public URI getStatusCallback() {
        return this.statusCallback;
    }

    public String getStatusCallbackMethod() {
        return this.statusCallbackMethod;
    }

    public URI getSmsUrl() {
        return this.smsUrl;
    }

    public String getSmsMethod() {
        return this.smsMethod;
    }

    public URI getSmsFallbackUrl() {
        return this.smsFallbackUrl;
    }

    public String getSmsFallbackMethod() {
        return this.smsFallbackMethod;
    }

    public URI getSmsStatusCallback() {
        return this.smsStatusCallback;
    }

    public URI getUri() {
        return this.uri;
    }

    public Application setFriendlyName(String friendlyName) {
        return new Application(this.sid, this.dateCreated, DateTime.now(), friendlyName, this.accountSid, this.apiVersion, this.voiceUrl, this.voiceMethod, this.voiceFallbackUrl, this.voiceFallbackMethod, this.statusCallback, this.statusCallbackMethod, this.hasVoiceCallerIdLookup, this.smsUrl, this.smsMethod, this.smsFallbackUrl, this.smsFallbackMethod, this.smsStatusCallback, this.uri);
    }

    public Application setVoiceCallerIdLookup(boolean hasVoiceCallerIdLookup) {
        return new Application(this.sid, this.dateCreated, DateTime.now(), this.friendlyName, this.accountSid, this.apiVersion, this.voiceUrl, this.voiceMethod, this.voiceFallbackUrl, this.voiceFallbackMethod, this.statusCallback, this.statusCallbackMethod, hasVoiceCallerIdLookup, this.smsUrl, this.smsMethod, this.smsFallbackUrl, this.smsFallbackMethod, this.smsStatusCallback, this.uri);
    }

    public Application setVoiceUrl(URI voiceUrl) {
        return new Application(this.sid, this.dateCreated, DateTime.now(), this.friendlyName, this.accountSid, this.apiVersion, voiceUrl, this.voiceMethod, this.voiceFallbackUrl, this.voiceFallbackMethod, this.statusCallback, this.statusCallbackMethod, this.hasVoiceCallerIdLookup, this.smsUrl, this.smsMethod, this.smsFallbackUrl, this.smsFallbackMethod, this.smsStatusCallback, this.uri);
    }

    public Application setVoiceMethod(String voiceMethod) {
        return new Application(this.sid, this.dateCreated, DateTime.now(), this.friendlyName, this.accountSid, this.apiVersion, this.voiceUrl, voiceMethod, this.voiceFallbackUrl, this.voiceFallbackMethod, this.statusCallback, this.statusCallbackMethod, this.hasVoiceCallerIdLookup, this.smsUrl, this.smsMethod, this.smsFallbackUrl, this.smsFallbackMethod, this.smsStatusCallback, this.uri);
    }

    public Application setVoiceFallbackUrl(URI voiceFallbackUrl) {
        return new Application(this.sid, this.dateCreated, DateTime.now(), this.friendlyName, this.accountSid, this.apiVersion, this.voiceUrl, this.voiceMethod, voiceFallbackUrl, this.voiceFallbackMethod, this.statusCallback, this.statusCallbackMethod, this.hasVoiceCallerIdLookup, this.smsUrl, this.smsMethod, this.smsFallbackUrl, this.smsFallbackMethod, this.smsStatusCallback, this.uri);
    }

    public Application setVoiceFallbackMethod(String voiceFallbackMethod) {
        return new Application(this.sid, this.dateCreated, DateTime.now(), this.friendlyName, this.accountSid, this.apiVersion, this.voiceUrl, this.voiceMethod, this.voiceFallbackUrl, voiceFallbackMethod, this.statusCallback, this.statusCallbackMethod, this.hasVoiceCallerIdLookup, this.smsUrl, this.smsMethod, this.smsFallbackUrl, this.smsFallbackMethod, this.smsStatusCallback, this.uri);
    }

    public Application setStatusCallback(URI statusCallback) {
        return new Application(this.sid, this.dateCreated, DateTime.now(), this.friendlyName, this.accountSid, this.apiVersion, this.voiceUrl, this.voiceMethod, this.voiceFallbackUrl, this.voiceFallbackMethod, statusCallback, this.statusCallbackMethod, this.hasVoiceCallerIdLookup, this.smsUrl, this.smsMethod, this.smsFallbackUrl, this.smsFallbackMethod, this.smsStatusCallback, this.uri);
    }

    public Application setStatusCallbackMethod(String statusCallbackMethod) {
        return new Application(this.sid, this.dateCreated, DateTime.now(), this.friendlyName, this.accountSid, this.apiVersion, this.voiceUrl, this.voiceMethod, this.voiceFallbackUrl, this.voiceFallbackMethod, this.statusCallback, statusCallbackMethod, this.hasVoiceCallerIdLookup, this.smsUrl, this.smsMethod, this.smsFallbackUrl, this.smsFallbackMethod, this.smsStatusCallback, this.uri);
    }

    public Application setSmsUrl(URI smsUrl) {
        return new Application(this.sid, this.dateCreated, DateTime.now(), this.friendlyName, this.accountSid, this.apiVersion, this.voiceUrl, this.voiceMethod, this.voiceFallbackUrl, this.voiceFallbackMethod, this.statusCallback, this.statusCallbackMethod, this.hasVoiceCallerIdLookup, smsUrl, this.smsMethod, this.smsFallbackUrl, this.smsFallbackMethod, this.smsStatusCallback, this.uri);
    }

    public Application setSmsMethod(String smsMethod) {
        return new Application(this.sid, this.dateCreated, DateTime.now(), this.friendlyName, this.accountSid, this.apiVersion, this.voiceUrl, this.voiceMethod, this.voiceFallbackUrl, this.voiceFallbackMethod, this.statusCallback, this.statusCallbackMethod, this.hasVoiceCallerIdLookup, this.smsUrl, smsMethod, this.smsFallbackUrl, this.smsFallbackMethod, this.smsStatusCallback, this.uri);
    }

    public Application setSmsFallbackUrl(URI smsFallbackUrl) {
        return new Application(this.sid, this.dateCreated, DateTime.now(), this.friendlyName, this.accountSid, this.apiVersion, this.voiceUrl, this.voiceMethod, this.voiceFallbackUrl, this.voiceFallbackMethod, this.statusCallback, this.statusCallbackMethod, this.hasVoiceCallerIdLookup, this.smsUrl, this.smsMethod, smsFallbackUrl, this.smsFallbackMethod, this.smsStatusCallback, this.uri);
    }

    public Application setSmsFallbackMethod(String smsFallbackMethod) {
        return new Application(this.sid, this.dateCreated, DateTime.now(), this.friendlyName, this.accountSid, this.apiVersion, this.voiceUrl, this.voiceMethod, this.voiceFallbackUrl, this.voiceFallbackMethod, this.statusCallback, this.statusCallbackMethod, this.hasVoiceCallerIdLookup, this.smsUrl, this.smsMethod, this.smsFallbackUrl, smsFallbackMethod, this.smsStatusCallback, this.uri);
    }

    public Application setSmsStatusCallback(URI smsStatusCallback) {
        return new Application(this.sid, this.dateCreated, DateTime.now(), this.friendlyName, this.accountSid, this.apiVersion, this.voiceUrl, this.voiceMethod, this.voiceFallbackUrl, this.voiceFallbackMethod, this.statusCallback, this.statusCallbackMethod, this.hasVoiceCallerIdLookup, this.smsUrl, this.smsMethod, this.smsFallbackUrl, this.smsFallbackMethod, smsStatusCallback, this.uri);
    }

    public static final class Builder {
        private Sid sid;
        private String friendlyName;
        private Sid accountSid;
        private String apiVersion;
        private URI voiceUrl;
        private String voiceMethod;
        private URI voiceFallbackUrl;
        private String voiceFallbackMethod;
        private URI statusCallback;
        private String statusCallbackMethod;
        private Boolean hasVoiceCallerIdLookup;
        private URI smsUrl;
        private String smsMethod;
        private URI smsFallbackUrl;
        private String smsFallbackMethod;
        private URI smsStatusCallback;
        private URI uri;

        private Builder() {
        }

        public Application build() {
            DateTime now = DateTime.now();
            return new Application(this.sid, now, now, this.friendlyName, this.accountSid, this.apiVersion, this.voiceUrl, this.voiceMethod, this.voiceFallbackUrl, this.voiceFallbackMethod, this.statusCallback, this.statusCallbackMethod, this.hasVoiceCallerIdLookup, this.smsUrl, this.smsMethod, this.smsFallbackUrl, this.smsFallbackMethod, this.smsStatusCallback, this.uri);
        }

        public void setSid(Sid sid) {
            this.sid = sid;
        }

        public void setFriendlyName(String friendlyName) {
            this.friendlyName = friendlyName;
        }

        public void setAccountSid(Sid accountSid) {
            this.accountSid = accountSid;
        }

        public void setApiVersion(String apiVersion) {
            this.apiVersion = apiVersion;
        }

        public void setVoiceUrl(URI voiceUrl) {
            this.voiceUrl = voiceUrl;
        }

        public void setVoiceMethod(String voiceMethod) {
            this.voiceMethod = voiceMethod;
        }

        public void setVoiceFallbackUrl(URI voiceFallbackUrl) {
            this.voiceFallbackUrl = voiceFallbackUrl;
        }

        public void setVoiceFallbackMethod(String voiceFallbackMethod) {
            this.voiceFallbackMethod = voiceFallbackMethod;
        }

        public void setStatusCallback(URI statusCallback) {
            this.statusCallback = statusCallback;
        }

        public void setStatusCallbackMethod(String statusCallbackMethod) {
            this.statusCallbackMethod = statusCallbackMethod;
        }

        public void setHasVoiceCallerIdLookup(boolean hasVoiceCallerIdLookup) {
            this.hasVoiceCallerIdLookup = hasVoiceCallerIdLookup;
        }

        public void setSmsUrl(URI smsUrl) {
            this.smsUrl = smsUrl;
        }

        public void setSmsMethod(String smsMethod) {
            this.smsMethod = smsMethod;
        }

        public void setSmsFallbackUrl(URI smsFallbackUrl) {
            this.smsFallbackUrl = smsFallbackUrl;
        }

        public void setSmsFallbackMethod(String smsFallbackMethod) {
            this.smsFallbackMethod = smsFallbackMethod;
        }

        public void setSmsStatusCallback(URI smsStatusCallback) {
            this.smsStatusCallback = smsStatusCallback;
        }

        public void setUri(URI uri) {
            this.uri = uri;
        }
    }
}

