/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.restcomm.dao.mybatis;

import java.math.BigDecimal;
import java.net.URI;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Currency;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.mobicents.servlet.restcomm.annotations.concurrency.ThreadSafe;
import org.mobicents.servlet.restcomm.dao.DaoUtils;
import org.mobicents.servlet.restcomm.dao.UsageDao;
import org.mobicents.servlet.restcomm.entities.Sid;
import org.mobicents.servlet.restcomm.entities.Usage;

@ThreadSafe
public final class MybatisUsageDao
implements UsageDao {
    private static final String namespace = "org.mobicents.servlet.sip.restcomm.dao.UsageDao.";
    private final SqlSessionFactory sessions;

    public MybatisUsageDao(SqlSessionFactory sessions) {
        this.sessions = sessions;
    }

    @Override
    public List<Usage> getUsage(Sid accountSid) {
        return this.getUsageCalls(accountSid, null, null, null, "getAllTimeCalls");
    }

    @Override
    public List<Usage> getUsageDaily(Sid accountSid, Usage.Category category, DateTime startDate, DateTime endDate) {
        return this.getUsageCalls(accountSid, category, startDate, endDate, "getDailyCalls");
    }

    @Override
    public List<Usage> getUsageMonthly(Sid accountSid, Usage.Category category, DateTime startDate, DateTime endDate) {
        return this.getUsageCalls(accountSid, category, startDate, endDate, "getMonthlyCalls");
    }

    @Override
    public List<Usage> getUsageYearly(Sid accountSid, Usage.Category category, DateTime startDate, DateTime endDate) {
        return this.getUsageCalls(accountSid, category, startDate, endDate, "getYearlyCalls");
    }

    @Override
    public List<Usage> getUsageAllTime(Sid accountSid, Usage.Category category, DateTime startDate, DateTime endDate) {
        return this.getUsageCalls(accountSid, category, startDate, endDate, "getAllTimeCalls");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Usage> getUsageCalls(Sid accountSid, Usage.Category category, DateTime startDate, DateTime endDate, String queryName) {
        long startTime = System.currentTimeMillis();
        SqlSession session = this.sessions.openSession();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("sid", accountSid.toString());
        params.put("startDate", new Date(startDate.getMillis()));
        params.put("endDate", new Date(endDate.getMillis()));
        this.fillParametersByCategory(category, params);
        try {
            List results = session.selectList(namespace + queryName, params);
            ArrayList<Usage> usageRecords = new ArrayList<Usage>();
            if (results != null && !results.isEmpty()) {
                for (Map result : results) {
                    usageRecords.add(this.toUsageRecord(accountSid, result));
                }
            }
            ArrayList<Usage> arrayList = usageRecords;
            return arrayList;
        }
        finally {
            session.close();
        }
    }

    private Usage toUsageRecord(Sid accountSid, Map<String, Object> map) {
        Usage.Category category = Usage.Category.CALLS;
        String description = "Total Calls";
        DateTime startDate = DateTimeFormat.forPattern((String)"yyyyy-MM-dd").parseDateTime(map.get("start_date").toString());
        DateTime endDate = DateTimeFormat.forPattern((String)"yyyyy-MM-dd").parseDateTime(map.get("end_date").toString());
        Long usage = DaoUtils.readLong(map.get("usage"));
        String usageUnit = "minutes";
        Long count = DaoUtils.readLong(map.get("count"));
        String countUnit = "calls";
        BigDecimal price = DaoUtils.readBigDecimal(map.get("price").toString());
        Currency priceUnit = Currency.getInstance(Locale.US);
        URI uri = DaoUtils.readUri(map.get("uri"));
        return new Usage(category, "Total Calls", accountSid, startDate, endDate, usage, "minutes", count, "calls", price, priceUnit, uri);
    }

    private Map<String, Object> fillParametersByCategory(Usage.Category category, Map<String, Object> params) {
        if (category == null) {
            category = Usage.Category.CALLS;
        }
        switch (category) {
            case CALLS: 
            case CALLS_INBOUND: 
            case CALLS_INBOUND_LOCAL: 
            case CALLS_INBOUND_TOLLFREE: 
            case CALLS_OUTBOUND: 
            case CALLS_CLIENT: 
            case CALLS_SIP: {
                params.put("tableName", "restcomm_call_detail_records");
                params.put("usageExpr", "COALESCE(SUM(\"duration\"),0)");
                break;
            }
            case SMS: 
            case SMS_INBOUND: 
            case SMS_INBOUND_SHORTCODE: 
            case SMS_INBOUND_LONGCODE: 
            case SMS_OUTBOUND: 
            case SMS_OUTBOUND_SHORTCODE: 
            case SMS_OUTBOUND_LONGCODE: {
                params.put("tableName", "restcomm_sms_messages");
                params.put("usageExpr", "COUNT(1)");
                break;
            }
            default: {
                params.put("tableName", "restcomm_call_detail_records");
                params.put("usageExpr", "COALESCE(SUM(\"duration\"),0)");
            }
        }
        return params;
    }
}

