/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.restcomm.dao.mybatis;

import java.math.BigDecimal;
import java.net.URI;
import java.util.ArrayList;
import java.util.Currency;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.joda.time.DateTime;
import org.mobicents.servlet.restcomm.annotations.concurrency.ThreadSafe;
import org.mobicents.servlet.restcomm.dao.DaoUtils;
import org.mobicents.servlet.restcomm.dao.TranscriptionsDao;
import org.mobicents.servlet.restcomm.entities.Sid;
import org.mobicents.servlet.restcomm.entities.Transcription;

@ThreadSafe
public final class MybatisTranscriptionsDao
implements TranscriptionsDao {
    private static final String namespace = "org.mobicents.servlet.sip.restcomm.dao.TranscriptionsDao.";
    private final SqlSessionFactory sessions;

    public MybatisTranscriptionsDao(SqlSessionFactory sessions) {
        this.sessions = sessions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addTranscription(Transcription transcription) {
        try (SqlSession session = this.sessions.openSession();){
            session.insert("org.mobicents.servlet.sip.restcomm.dao.TranscriptionsDao.addTranscription", this.toMap(transcription));
            session.commit();
        }
    }

    @Override
    public Transcription getTranscription(Sid sid) {
        return this.getTranscription("org.mobicents.servlet.sip.restcomm.dao.TranscriptionsDao.getTranscription", sid);
    }

    @Override
    public Transcription getTranscriptionByRecording(Sid recordingSid) {
        return this.getTranscription("org.mobicents.servlet.sip.restcomm.dao.TranscriptionsDao.getTranscriptionByRecording", recordingSid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Transcription getTranscription(String selector, Sid sid) {
        try (SqlSession session = this.sessions.openSession();){
            Map result = (Map)session.selectOne(selector, (Object)sid.toString());
            if (result != null) {
                Transcription transcription = this.toTranscription(result);
                return transcription;
            }
            Transcription transcription = null;
            return transcription;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Transcription> getTranscriptions(Sid accountSid) {
        try (SqlSession session = this.sessions.openSession();){
            List results = session.selectList("org.mobicents.servlet.sip.restcomm.dao.TranscriptionsDao.getTranscriptions", (Object)accountSid.toString());
            ArrayList<Transcription> transcriptions = new ArrayList<Transcription>();
            if (results != null && !results.isEmpty()) {
                for (Map result : results) {
                    transcriptions.add(this.toTranscription(result));
                }
            }
            ArrayList<Transcription> arrayList = transcriptions;
            return arrayList;
        }
    }

    @Override
    public void removeTranscription(Sid sid) {
        this.removeTranscriptions("org.mobicents.servlet.sip.restcomm.dao.TranscriptionsDao.removeTranscription", sid);
    }

    @Override
    public void removeTranscriptions(Sid accountSid) {
        this.removeTranscriptions("org.mobicents.servlet.sip.restcomm.dao.TranscriptionsDao.removeTranscriptions", accountSid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeTranscriptions(String selector, Sid sid) {
        try (SqlSession session = this.sessions.openSession();){
            session.delete(selector, (Object)sid.toString());
            session.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateTranscription(Transcription transcription) {
        try (SqlSession session = this.sessions.openSession();){
            session.update("org.mobicents.servlet.sip.restcomm.dao.TranscriptionsDao.updateTranscription", this.toMap(transcription));
            session.commit();
        }
    }

    private Map<String, Object> toMap(Transcription transcription) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("sid", DaoUtils.writeSid(transcription.getSid()));
        map.put("date_created", DaoUtils.writeDateTime(transcription.getDateCreated()));
        map.put("date_updated", DaoUtils.writeDateTime(transcription.getDateUpdated()));
        map.put("account_sid", DaoUtils.writeSid(transcription.getAccountSid()));
        map.put("status", transcription.getStatus().toString());
        map.put("recording_sid", DaoUtils.writeSid(transcription.getRecordingSid()));
        map.put("duration", transcription.getDuration());
        map.put("transcription_text", transcription.getTranscriptionText());
        map.put("price", DaoUtils.writeBigDecimal(transcription.getPrice()));
        map.put("price_unit", DaoUtils.writeCurrency(transcription.getPriceUnit()));
        map.put("uri", DaoUtils.writeUri(transcription.getUri()));
        return map;
    }

    private Transcription toTranscription(Map<String, Object> map) {
        Sid sid = DaoUtils.readSid(map.get("sid"));
        DateTime dateCreated = DaoUtils.readDateTime(map.get("date_created"));
        DateTime dateUpdated = DaoUtils.readDateTime(map.get("date_updated"));
        Sid accountSid = DaoUtils.readSid(map.get("account_sid"));
        String text = DaoUtils.readString(map.get("status"));
        Transcription.Status status = Transcription.Status.getStatusValue(text);
        Sid recordingSid = DaoUtils.readSid(map.get("recording_sid"));
        Double duration = DaoUtils.readDouble(map.get("duration"));
        String transcriptionText = DaoUtils.readString(map.get("transcription_text"));
        BigDecimal price = DaoUtils.readBigDecimal(map.get("price"));
        Currency priceUnit = DaoUtils.readCurrency(map.get("price_unit"));
        URI uri = DaoUtils.readUri(map.get("uri"));
        return new Transcription(sid, dateCreated, dateUpdated, accountSid, status, recordingSid, duration, transcriptionText, price, priceUnit, uri);
    }
}

