/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.restcomm.dao.mybatis;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.joda.time.DateTime;
import org.mobicents.servlet.restcomm.annotations.concurrency.ThreadSafe;
import org.mobicents.servlet.restcomm.dao.DaoUtils;
import org.mobicents.servlet.restcomm.dao.ShortCodesDao;
import org.mobicents.servlet.restcomm.entities.ShortCode;
import org.mobicents.servlet.restcomm.entities.Sid;

@ThreadSafe
public final class MybatisShortCodesDao
implements ShortCodesDao {
    private static final String namespace = "org.mobicents.servlet.sip.restcomm.dao.ShortCodesDao.";
    private final SqlSessionFactory sessions;

    public MybatisShortCodesDao(SqlSessionFactory sessions) {
        this.sessions = sessions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addShortCode(ShortCode shortCode) {
        try (SqlSession session = this.sessions.openSession();){
            session.insert("org.mobicents.servlet.sip.restcomm.dao.ShortCodesDao.addShortCode", this.toMap(shortCode));
            session.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ShortCode getShortCode(Sid sid) {
        try (SqlSession session = this.sessions.openSession();){
            Map result = (Map)session.selectOne("org.mobicents.servlet.sip.restcomm.dao.ShortCodesDao.getShortCode", (Object)sid.toString());
            if (result != null) {
                ShortCode shortCode = this.toShortCode(result);
                return shortCode;
            }
            ShortCode shortCode = null;
            return shortCode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ShortCode> getShortCodes(Sid accountSid) {
        try (SqlSession session = this.sessions.openSession();){
            List results = session.selectList("org.mobicents.servlet.sip.restcomm.dao.ShortCodesDao.getShortCodes", (Object)accountSid.toString());
            ArrayList<ShortCode> shortCodes = new ArrayList<ShortCode>();
            if (results != null && !results.isEmpty()) {
                for (Map result : results) {
                    shortCodes.add(this.toShortCode(result));
                }
            }
            ArrayList<ShortCode> arrayList = shortCodes;
            return arrayList;
        }
    }

    @Override
    public void removeShortCode(Sid sid) {
        this.removeShortCodes("org.mobicents.servlet.sip.restcomm.dao.ShortCodesDao.removeShortCode", sid);
    }

    @Override
    public void removeShortCodes(Sid accountSid) {
        this.removeShortCodes("org.mobicents.servlet.sip.restcomm.dao.ShortCodesDao.removeShortCodes", accountSid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeShortCodes(String selector, Sid sid) {
        try (SqlSession session = this.sessions.openSession();){
            session.delete(selector, (Object)sid.toString());
            session.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateShortCode(ShortCode shortCode) {
        try (SqlSession session = this.sessions.openSession();){
            session.update("org.mobicents.servlet.sip.restcomm.dao.ShortCodesDao.updateShortCode", this.toMap(shortCode));
            session.commit();
        }
    }

    private Map<String, Object> toMap(ShortCode shortCode) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("sid", DaoUtils.writeSid(shortCode.getSid()));
        map.put("date_created", DaoUtils.writeDateTime(shortCode.getDateCreated()));
        map.put("date_updated", DaoUtils.writeDateTime(shortCode.getDateUpdated()));
        map.put("friendly_name", shortCode.getFriendlyName());
        map.put("account_sid", DaoUtils.writeSid(shortCode.getAccountSid()));
        map.put("short_code", shortCode.getShortCode());
        map.put("api_version", shortCode.getApiVersion());
        map.put("sms_url", DaoUtils.writeUri(shortCode.getSmsUrl()));
        map.put("sms_method", shortCode.getSmsMethod());
        map.put("sms_fallback_url", DaoUtils.writeUri(shortCode.getSmsFallbackUrl()));
        map.put("sms_fallback_method", shortCode.getSmsFallbackMethod());
        map.put("uri", DaoUtils.writeUri(shortCode.getUri()));
        return map;
    }

    private ShortCode toShortCode(Map<String, Object> map) {
        Sid sid = DaoUtils.readSid(map.get("sid"));
        DateTime dateCreated = DaoUtils.readDateTime(map.get("date_created"));
        DateTime dateUpdated = DaoUtils.readDateTime(map.get("date_updated"));
        String friendlyName = DaoUtils.readString(map.get("friendly_name"));
        Sid accountSid = DaoUtils.readSid(map.get("account_sid"));
        Integer shortCode = DaoUtils.readInteger(map.get("short_code"));
        String apiVersion = DaoUtils.readString(map.get("api_version"));
        URI smsUrl = DaoUtils.readUri(map.get("sms_url"));
        String smsMethod = DaoUtils.readString(map.get("sms_method"));
        URI smsFallbackUrl = DaoUtils.readUri(map.get("sms_fallback_url"));
        String smsFallbackMethod = DaoUtils.readString(map.get("sms_fallback_method"));
        URI uri = DaoUtils.readUri(map.get("uri"));
        return new ShortCode(sid, dateCreated, dateUpdated, friendlyName, accountSid, shortCode, apiVersion, smsUrl, smsMethod, smsFallbackUrl, smsFallbackMethod, uri);
    }
}

