/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.restcomm.dao.mybatis;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.log4j.Logger;
import org.joda.time.DateTime;
import org.mobicents.servlet.restcomm.annotations.concurrency.ThreadSafe;
import org.mobicents.servlet.restcomm.dao.DaoUtils;
import org.mobicents.servlet.restcomm.dao.RegistrationsDao;
import org.mobicents.servlet.restcomm.entities.Registration;
import org.mobicents.servlet.restcomm.entities.Sid;

@ThreadSafe
public final class MybatisRegistrationsDao
implements RegistrationsDao {
    private static final Logger logger = Logger.getLogger(MybatisRegistrationsDao.class);
    private static final String namespace = "org.mobicents.servlet.sip.restcomm.dao.RegistrationsDao.";
    private final SqlSessionFactory sessions;

    public MybatisRegistrationsDao(SqlSessionFactory sessions) {
        this.sessions = sessions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addRegistration(Registration registration) {
        try (SqlSession session = this.sessions.openSession();){
            session.insert("org.mobicents.servlet.sip.restcomm.dao.RegistrationsDao.addRegistration", this.toMap(registration));
            session.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Registration getRegistration(String user) {
        try (SqlSession session = this.sessions.openSession();){
            List results = session.selectList("org.mobicents.servlet.sip.restcomm.dao.RegistrationsDao.getRegistration", (Object)user);
            ArrayList<Registration> records = new ArrayList<Registration>();
            if (results != null && !results.isEmpty()) {
                Registration registration;
                for (Map result : results) {
                    records.add(this.toPresenceRecord(result));
                }
                if (records.isEmpty()) {
                    registration = null;
                    return registration;
                }
                Collections.sort(records);
                registration = (Registration)records.get(0);
                return registration;
            }
            Registration registration = null;
            return registration;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Registration> getRegistrations() {
        try (SqlSession session = this.sessions.openSession();){
            List results = session.selectList("org.mobicents.servlet.sip.restcomm.dao.RegistrationsDao.getRegistrations");
            ArrayList<Registration> records = new ArrayList<Registration>();
            if (results != null && !results.isEmpty()) {
                for (Map result : results) {
                    records.add(this.toPresenceRecord(result));
                }
            }
            ArrayList<Registration> arrayList = records;
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasRegistration(Registration registration) {
        try (SqlSession session = this.sessions.openSession();){
            Integer result = (Integer)session.selectOne("org.mobicents.servlet.sip.restcomm.dao.RegistrationsDao.hasRegistration", this.toMap(registration));
            boolean bl = result != null && result > 0;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeRegistration(Registration registration) {
        try (SqlSession session = this.sessions.openSession();){
            session.delete("org.mobicents.servlet.sip.restcomm.dao.RegistrationsDao.removeRegistration", this.toMap(registration));
            session.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateRegistration(Registration registration) {
        try (SqlSession session = this.sessions.openSession();){
            session.update("org.mobicents.servlet.sip.restcomm.dao.RegistrationsDao.updateRegistration", this.toMap(registration));
            session.commit();
        }
    }

    private Map<String, Object> toMap(Registration registration) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("sid", DaoUtils.writeSid(registration.getSid()));
        map.put("date_created", DaoUtils.writeDateTime(registration.getDateCreated()));
        map.put("date_updated", DaoUtils.writeDateTime(registration.getDateUpdated()));
        map.put("date_expires", DaoUtils.writeDateTime(registration.getDateExpires()));
        map.put("address_of_record", registration.getAddressOfRecord());
        map.put("display_name", registration.getDisplayName());
        map.put("user_name", registration.getUserName());
        map.put("location", registration.getLocation());
        map.put("user_agent", registration.getUserAgent());
        map.put("ttl", registration.getTimeToLive());
        return map;
    }

    private Registration toPresenceRecord(Map<String, Object> map) {
        Sid sid = DaoUtils.readSid(map.get("sid"));
        DateTime dateCreated = DaoUtils.readDateTime(map.get("date_created"));
        DateTime dateUpdated = DaoUtils.readDateTime(map.get("date_updated"));
        DateTime dateExpires = DaoUtils.readDateTime(map.get("date_expires"));
        String addressOfRecord = DaoUtils.readString(map.get("address_of_record"));
        String dislplayName = DaoUtils.readString(map.get("display_name"));
        String userName = DaoUtils.readString(map.get("user_name"));
        String location = DaoUtils.readString(map.get("location"));
        String userAgent = DaoUtils.readString(map.get("user_agent"));
        Integer timeToLive = DaoUtils.readInteger(map.get("ttl"));
        return new Registration(sid, dateCreated, dateUpdated, dateExpires, addressOfRecord, dislplayName, userName, userAgent, timeToLive, location);
    }
}

