/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.restcomm.dao.mybatis;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.joda.time.DateTime;
import org.mobicents.servlet.restcomm.annotations.concurrency.ThreadSafe;
import org.mobicents.servlet.restcomm.dao.DaoUtils;
import org.mobicents.servlet.restcomm.dao.IncomingPhoneNumbersDao;
import org.mobicents.servlet.restcomm.entities.IncomingPhoneNumber;
import org.mobicents.servlet.restcomm.entities.IncomingPhoneNumberFilter;
import org.mobicents.servlet.restcomm.entities.Sid;

@ThreadSafe
public final class MybatisIncomingPhoneNumbersDao
implements IncomingPhoneNumbersDao {
    private static final String namespace = "org.mobicents.servlet.sip.restcomm.dao.IncomingPhoneNumbersDao.";
    private final SqlSessionFactory sessions;

    public MybatisIncomingPhoneNumbersDao(SqlSessionFactory sessions) {
        this.sessions = sessions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addIncomingPhoneNumber(IncomingPhoneNumber incomingPhoneNumber) {
        try (SqlSession session = this.sessions.openSession();){
            session.insert("org.mobicents.servlet.sip.restcomm.dao.IncomingPhoneNumbersDao.addIncomingPhoneNumber", this.toMap(incomingPhoneNumber));
            session.commit();
        }
    }

    @Override
    public IncomingPhoneNumber getIncomingPhoneNumber(Sid sid) {
        return this.getIncomingPhoneNumber("getIncomingPhoneNumber", sid.toString());
    }

    @Override
    public IncomingPhoneNumber getIncomingPhoneNumber(String phoneNumber) {
        return this.getIncomingPhoneNumber("getIncomingPhoneNumberByValue", phoneNumber);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IncomingPhoneNumber getIncomingPhoneNumber(String selector, Object parameter) {
        try (SqlSession session = this.sessions.openSession();){
            Map result = (Map)session.selectOne(namespace + selector, parameter);
            if (result != null) {
                IncomingPhoneNumber incomingPhoneNumber = this.toIncomingPhoneNumber(result);
                return incomingPhoneNumber;
            }
            IncomingPhoneNumber incomingPhoneNumber = null;
            return incomingPhoneNumber;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<IncomingPhoneNumber> getIncomingPhoneNumbers(Sid accountSid) {
        try (SqlSession session = this.sessions.openSession();){
            List results = session.selectList("org.mobicents.servlet.sip.restcomm.dao.IncomingPhoneNumbersDao.getIncomingPhoneNumbers", (Object)accountSid.toString());
            ArrayList<IncomingPhoneNumber> incomingPhoneNumbers = new ArrayList<IncomingPhoneNumber>();
            if (results != null && !results.isEmpty()) {
                for (Map result : results) {
                    incomingPhoneNumbers.add(this.toIncomingPhoneNumber(result));
                }
            }
            ArrayList<IncomingPhoneNumber> arrayList = incomingPhoneNumbers;
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<IncomingPhoneNumber> getIncomingPhoneNumbersByFilter(IncomingPhoneNumberFilter filter) {
        try (SqlSession session = this.sessions.openSession();){
            List results = session.selectList("org.mobicents.servlet.sip.restcomm.dao.IncomingPhoneNumbersDao.getIncomingPhoneNumbersByFriendlyName", (Object)filter);
            ArrayList<IncomingPhoneNumber> incomingPhoneNumbers = new ArrayList<IncomingPhoneNumber>();
            if (results != null && !results.isEmpty()) {
                for (Map result : results) {
                    incomingPhoneNumbers.add(this.toIncomingPhoneNumber(result));
                }
            }
            ArrayList<IncomingPhoneNumber> arrayList = incomingPhoneNumbers;
            return arrayList;
        }
    }

    @Override
    public void removeIncomingPhoneNumber(Sid sid) {
        this.removeIncomingPhoneNumbers("removeIncomingPhoneNumber", sid);
    }

    @Override
    public void removeIncomingPhoneNumbers(Sid accountSid) {
        this.removeIncomingPhoneNumbers("removeIncomingPhoneNumbers", accountSid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeIncomingPhoneNumbers(String selector, Sid sid) {
        try (SqlSession session = this.sessions.openSession();){
            session.delete(namespace + selector, (Object)sid.toString());
            session.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateIncomingPhoneNumber(IncomingPhoneNumber incomingPhoneNumber) {
        try (SqlSession session = this.sessions.openSession();){
            session.update("org.mobicents.servlet.sip.restcomm.dao.IncomingPhoneNumbersDao.updateIncomingPhoneNumber", this.toMap(incomingPhoneNumber));
            session.commit();
        }
    }

    private IncomingPhoneNumber toIncomingPhoneNumber(Map<String, Object> map) {
        Sid sid = DaoUtils.readSid(map.get("sid"));
        DateTime dateCreated = DaoUtils.readDateTime(map.get("date_created"));
        DateTime dateUpdated = DaoUtils.readDateTime(map.get("date_updated"));
        String friendlyName = DaoUtils.readString(map.get("friendly_name"));
        Sid accountSid = DaoUtils.readSid(map.get("account_sid"));
        String phoneNumber = DaoUtils.readString(map.get("phone_number"));
        String apiVersion = DaoUtils.readString(map.get("api_version"));
        Boolean hasVoiceCallerIdLookup = DaoUtils.readBoolean(map.get("voice_caller_id_lookup"));
        URI voiceUrl = DaoUtils.readUri(map.get("voice_url"));
        String voiceMethod = DaoUtils.readString(map.get("voice_method"));
        URI voiceFallbackUrl = DaoUtils.readUri(map.get("voice_fallback_url"));
        String voiceFallbackMethod = DaoUtils.readString(map.get("voice_fallback_method"));
        URI statusCallback = DaoUtils.readUri(map.get("status_callback"));
        String statusCallbackMethod = DaoUtils.readString(map.get("status_callback_method"));
        Sid voiceApplicationSid = DaoUtils.readSid(map.get("voice_application_sid"));
        URI smsUrl = DaoUtils.readUri(map.get("sms_url"));
        String smsMethod = DaoUtils.readString(map.get("sms_method"));
        URI smsFallbackUrl = DaoUtils.readUri(map.get("sms_fallback_url"));
        String smsFallbackMethod = DaoUtils.readString(map.get("sms_fallback_method"));
        Sid smsApplicationSid = DaoUtils.readSid(map.get("sms_application_sid"));
        URI uri = DaoUtils.readUri(map.get("uri"));
        URI ussdUrl = DaoUtils.readUri(map.get("ussd_url"));
        String ussdMethod = DaoUtils.readString(map.get("ussd_method"));
        URI ussdFallbackUrl = DaoUtils.readUri(map.get("ussd_fallback_url"));
        String ussdFallbackMethod = DaoUtils.readString(map.get("ussd_fallback_method"));
        Sid ussdApplicationSid = DaoUtils.readSid(map.get("ussd_application_sid"));
        Boolean voiceCapable = DaoUtils.readBoolean(map.get("voice_capable"));
        Boolean smsCapable = DaoUtils.readBoolean(map.get("sms_capable"));
        Boolean mmsCapable = DaoUtils.readBoolean(map.get("mms_capable"));
        Boolean faxCapable = DaoUtils.readBoolean(map.get("fax_capable"));
        Boolean pureSip = DaoUtils.readBoolean(map.get("pure_sip"));
        return new IncomingPhoneNumber(sid, dateCreated, dateUpdated, friendlyName, accountSid, phoneNumber, apiVersion, hasVoiceCallerIdLookup, voiceUrl, voiceMethod, voiceFallbackUrl, voiceFallbackMethod, statusCallback, statusCallbackMethod, voiceApplicationSid, smsUrl, smsMethod, smsFallbackUrl, smsFallbackMethod, smsApplicationSid, uri, ussdUrl, ussdMethod, ussdFallbackUrl, ussdFallbackMethod, ussdApplicationSid, voiceCapable, smsCapable, mmsCapable, faxCapable, pureSip);
    }

    private Map<String, Object> toMap(IncomingPhoneNumber incomingPhoneNumber) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("sid", DaoUtils.writeSid(incomingPhoneNumber.getSid()));
        map.put("date_created", DaoUtils.writeDateTime(incomingPhoneNumber.getDateCreated()));
        map.put("date_updated", DaoUtils.writeDateTime(incomingPhoneNumber.getDateUpdated()));
        map.put("friendly_name", incomingPhoneNumber.getFriendlyName());
        map.put("account_sid", DaoUtils.writeSid(incomingPhoneNumber.getAccountSid()));
        map.put("phone_number", incomingPhoneNumber.getPhoneNumber());
        map.put("api_version", incomingPhoneNumber.getApiVersion());
        map.put("voice_caller_id_lookup", incomingPhoneNumber.hasVoiceCallerIdLookup());
        map.put("voice_url", DaoUtils.writeUri(incomingPhoneNumber.getVoiceUrl()));
        map.put("voice_method", incomingPhoneNumber.getVoiceMethod());
        map.put("voice_fallback_url", DaoUtils.writeUri(incomingPhoneNumber.getVoiceFallbackUrl()));
        map.put("voice_fallback_method", incomingPhoneNumber.getVoiceFallbackMethod());
        map.put("status_callback", DaoUtils.writeUri(incomingPhoneNumber.getStatusCallback()));
        map.put("status_callback_method", incomingPhoneNumber.getStatusCallbackMethod());
        map.put("voice_application_sid", DaoUtils.writeSid(incomingPhoneNumber.getVoiceApplicationSid()));
        map.put("sms_url", DaoUtils.writeUri(incomingPhoneNumber.getSmsUrl()));
        map.put("sms_method", incomingPhoneNumber.getSmsMethod());
        map.put("sms_fallback_url", DaoUtils.writeUri(incomingPhoneNumber.getSmsFallbackUrl()));
        map.put("sms_fallback_method", incomingPhoneNumber.getSmsFallbackMethod());
        map.put("sms_application_sid", DaoUtils.writeSid(incomingPhoneNumber.getSmsApplicationSid()));
        map.put("uri", DaoUtils.writeUri(incomingPhoneNumber.getUri()));
        map.put("ussd_url", DaoUtils.writeUri(incomingPhoneNumber.getUssdUrl()));
        map.put("ussd_method", incomingPhoneNumber.getUssdMethod());
        map.put("ussd_fallback_url", DaoUtils.writeUri(incomingPhoneNumber.getUssdFallbackUrl()));
        map.put("ussd_fallback_method", incomingPhoneNumber.getUssdFallbackMethod());
        map.put("ussd_application_sid", DaoUtils.writeSid(incomingPhoneNumber.getUssdApplicationSid()));
        map.put("voice_capable", incomingPhoneNumber.isVoiceCapable());
        map.put("sms_capable", incomingPhoneNumber.isSmsCapable());
        map.put("mms_capable", incomingPhoneNumber.isMmsCapable());
        map.put("fax_capable", incomingPhoneNumber.isFaxCapable());
        map.put("pure_sip", incomingPhoneNumber.isPureSip());
        return map;
    }
}

