/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.restcomm.dao.mybatis;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.joda.time.DateTime;
import org.mobicents.servlet.restcomm.annotations.concurrency.ThreadSafe;
import org.mobicents.servlet.restcomm.dao.DaoUtils;
import org.mobicents.servlet.restcomm.dao.GatewaysDao;
import org.mobicents.servlet.restcomm.entities.Gateway;
import org.mobicents.servlet.restcomm.entities.Sid;

@ThreadSafe
public final class MybatisGatewaysDao
implements GatewaysDao {
    private static final String namespace = "org.mobicents.servlet.sip.restcomm.dao.GatewaysDao.";
    private final SqlSessionFactory sessions;

    public MybatisGatewaysDao(SqlSessionFactory sessions) {
        this.sessions = sessions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addGateway(Gateway gateway) {
        try (SqlSession session = this.sessions.openSession();){
            session.insert("org.mobicents.servlet.sip.restcomm.dao.GatewaysDao.addGateway", this.toMap(gateway));
            session.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Gateway getGateway(Sid sid) {
        try (SqlSession session = this.sessions.openSession();){
            Map result = (Map)session.selectOne("org.mobicents.servlet.sip.restcomm.dao.GatewaysDao.getGateway", (Object)sid.toString());
            if (result != null) {
                Gateway gateway = this.toGateway(result);
                return gateway;
            }
            Gateway gateway = null;
            return gateway;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Gateway> getGateways() {
        try (SqlSession session = this.sessions.openSession();){
            List results = session.selectList("org.mobicents.servlet.sip.restcomm.dao.GatewaysDao.getGateways");
            ArrayList<Gateway> gateways = new ArrayList<Gateway>();
            if (results != null && !results.isEmpty()) {
                for (Map result : results) {
                    gateways.add(this.toGateway(result));
                }
            }
            ArrayList<Gateway> arrayList = gateways;
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeGateway(Sid sid) {
        try (SqlSession session = this.sessions.openSession();){
            session.delete("org.mobicents.servlet.sip.restcomm.dao.GatewaysDao.removeGateway", (Object)sid.toString());
            session.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateGateway(Gateway gateway) {
        try (SqlSession session = this.sessions.openSession();){
            session.update("org.mobicents.servlet.sip.restcomm.dao.GatewaysDao.updateGateway", this.toMap(gateway));
            session.commit();
        }
    }

    private Gateway toGateway(Map<String, Object> map) {
        Sid sid = DaoUtils.readSid(map.get("sid"));
        DateTime dateCreated = DaoUtils.readDateTime(map.get("date_created"));
        DateTime dateUpdated = DaoUtils.readDateTime(map.get("date_updated"));
        String friendlName = DaoUtils.readString(map.get("friendly_name"));
        String password = DaoUtils.readString(map.get("password"));
        String proxy = DaoUtils.readString(map.get("proxy"));
        Boolean register = DaoUtils.readBoolean(map.get("register"));
        String userAgent = DaoUtils.readString(map.get("user_name"));
        Integer timeToLive = DaoUtils.readInteger(map.get("ttl"));
        URI uri = DaoUtils.readUri(map.get("uri"));
        return new Gateway(sid, dateCreated, dateUpdated, friendlName, password, proxy, register, userAgent, timeToLive, uri);
    }

    private Map<String, Object> toMap(Gateway gateway) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("sid", DaoUtils.writeSid(gateway.getSid()));
        map.put("date_created", DaoUtils.writeDateTime(gateway.getDateCreated()));
        map.put("date_updated", DaoUtils.writeDateTime(gateway.getDateUpdated()));
        map.put("friendly_name", gateway.getFriendlyName());
        map.put("password", gateway.getPassword());
        map.put("proxy", gateway.getProxy());
        map.put("register", gateway.register());
        map.put("user_name", gateway.getUserName());
        map.put("ttl", gateway.getTimeToLive());
        map.put("uri", DaoUtils.writeUri(gateway.getUri()));
        return map;
    }
}

