/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.restcomm.dao.mybatis;

import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.util.Properties;
import org.apache.commons.configuration.Configuration;
import org.apache.ibatis.logging.LogFactory;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.session.SqlSessionFactoryBuilder;
import org.mobicents.servlet.restcomm.amazonS3.S3AccessTool;
import org.mobicents.servlet.restcomm.annotations.concurrency.ThreadSafe;
import org.mobicents.servlet.restcomm.dao.AccountsDao;
import org.mobicents.servlet.restcomm.dao.AnnouncementsDao;
import org.mobicents.servlet.restcomm.dao.ApplicationsDao;
import org.mobicents.servlet.restcomm.dao.AvailablePhoneNumbersDao;
import org.mobicents.servlet.restcomm.dao.CallDetailRecordsDao;
import org.mobicents.servlet.restcomm.dao.ClientsDao;
import org.mobicents.servlet.restcomm.dao.DaoManager;
import org.mobicents.servlet.restcomm.dao.GatewaysDao;
import org.mobicents.servlet.restcomm.dao.HttpCookiesDao;
import org.mobicents.servlet.restcomm.dao.IncomingPhoneNumbersDao;
import org.mobicents.servlet.restcomm.dao.NotificationsDao;
import org.mobicents.servlet.restcomm.dao.OutgoingCallerIdsDao;
import org.mobicents.servlet.restcomm.dao.RecordingsDao;
import org.mobicents.servlet.restcomm.dao.RegistrationsDao;
import org.mobicents.servlet.restcomm.dao.ShortCodesDao;
import org.mobicents.servlet.restcomm.dao.SmsMessagesDao;
import org.mobicents.servlet.restcomm.dao.TranscriptionsDao;
import org.mobicents.servlet.restcomm.dao.UsageDao;
import org.mobicents.servlet.restcomm.dao.mybatis.MybatisAccountsDao;
import org.mobicents.servlet.restcomm.dao.mybatis.MybatisAnnouncementsDao;
import org.mobicents.servlet.restcomm.dao.mybatis.MybatisApplicationsDao;
import org.mobicents.servlet.restcomm.dao.mybatis.MybatisAvailablePhoneNumbersDao;
import org.mobicents.servlet.restcomm.dao.mybatis.MybatisCallDetailRecordsDao;
import org.mobicents.servlet.restcomm.dao.mybatis.MybatisClientsDao;
import org.mobicents.servlet.restcomm.dao.mybatis.MybatisGatewaysDao;
import org.mobicents.servlet.restcomm.dao.mybatis.MybatisHttpCookiesDao;
import org.mobicents.servlet.restcomm.dao.mybatis.MybatisIncomingPhoneNumbersDao;
import org.mobicents.servlet.restcomm.dao.mybatis.MybatisNotificationsDao;
import org.mobicents.servlet.restcomm.dao.mybatis.MybatisOutgoingCallerIdsDao;
import org.mobicents.servlet.restcomm.dao.mybatis.MybatisRecordingsDao;
import org.mobicents.servlet.restcomm.dao.mybatis.MybatisRegistrationsDao;
import org.mobicents.servlet.restcomm.dao.mybatis.MybatisShortCodesDao;
import org.mobicents.servlet.restcomm.dao.mybatis.MybatisSmsMessagesDao;
import org.mobicents.servlet.restcomm.dao.mybatis.MybatisTranscriptionsDao;
import org.mobicents.servlet.restcomm.dao.mybatis.MybatisUsageDao;

@ThreadSafe
public final class MybatisDaoManager
implements DaoManager {
    private Configuration configuration;
    private Configuration amazonS3Configuration;
    private Configuration runtimeConfiguration;
    private S3AccessTool s3AccessTool;
    private AccountsDao accountsDao;
    private ApplicationsDao applicationsDao;
    private AvailablePhoneNumbersDao availablePhoneNumbersDao;
    private CallDetailRecordsDao callDetailRecordsDao;
    private ClientsDao clientsDao;
    private HttpCookiesDao httpCookiesDao;
    private IncomingPhoneNumbersDao incomingPhoneNumbersDao;
    private NotificationsDao notificationsDao;
    private OutgoingCallerIdsDao outgoingCallerIdsDao;
    private RegistrationsDao presenceRecordsDao;
    private RecordingsDao recordingsDao;
    private ShortCodesDao shortCodesDao;
    private SmsMessagesDao smsMessagesDao;
    private UsageDao usageDao;
    private TranscriptionsDao transcriptionsDao;
    private GatewaysDao gatewaysDao;
    private AnnouncementsDao announcementsDao;

    public void configure(Configuration configuration) {
        this.configuration = configuration.subset("dao-manager");
        this.amazonS3Configuration = configuration.subset("amazon-s3");
        this.runtimeConfiguration = configuration.subset("runtime-settings");
    }

    @Override
    public AccountsDao getAccountsDao() {
        return this.accountsDao;
    }

    @Override
    public ApplicationsDao getApplicationsDao() {
        return this.applicationsDao;
    }

    @Override
    public AnnouncementsDao getAnnouncementsDao() {
        return this.announcementsDao;
    }

    @Override
    public AvailablePhoneNumbersDao getAvailablePhoneNumbersDao() {
        return this.availablePhoneNumbersDao;
    }

    @Override
    public CallDetailRecordsDao getCallDetailRecordsDao() {
        return this.callDetailRecordsDao;
    }

    @Override
    public ClientsDao getClientsDao() {
        return this.clientsDao;
    }

    @Override
    public HttpCookiesDao getHttpCookiesDao() {
        return this.httpCookiesDao;
    }

    @Override
    public IncomingPhoneNumbersDao getIncomingPhoneNumbersDao() {
        return this.incomingPhoneNumbersDao;
    }

    @Override
    public NotificationsDao getNotificationsDao() {
        return this.notificationsDao;
    }

    @Override
    public RegistrationsDao getRegistrationsDao() {
        return this.presenceRecordsDao;
    }

    @Override
    public OutgoingCallerIdsDao getOutgoingCallerIdsDao() {
        return this.outgoingCallerIdsDao;
    }

    @Override
    public RecordingsDao getRecordingsDao() {
        return this.recordingsDao;
    }

    @Override
    public ShortCodesDao getShortCodesDao() {
        return this.shortCodesDao;
    }

    @Override
    public SmsMessagesDao getSmsMessagesDao() {
        return this.smsMessagesDao;
    }

    @Override
    public UsageDao getUsageDao() {
        return this.usageDao;
    }

    @Override
    public TranscriptionsDao getTranscriptionsDao() {
        return this.transcriptionsDao;
    }

    @Override
    public GatewaysDao getGatewaysDao() {
        return this.gatewaysDao;
    }

    public void shutdown() {
    }

    public void start() throws RuntimeException {
        boolean amazonS3Enabled;
        LogFactory.useSlf4jLogging();
        SqlSessionFactoryBuilder builder = new SqlSessionFactoryBuilder();
        String path = this.configuration.getString("configuration-file");
        FileReader reader = null;
        try {
            reader = new FileReader(path);
        }
        catch (FileNotFoundException exception) {
            throw new RuntimeException(exception);
        }
        Properties properties = new Properties();
        String dataFiles = this.configuration.getString("data-files");
        String sqlFiles = this.configuration.getString("sql-files");
        properties.setProperty("data", dataFiles);
        properties.setProperty("sql", sqlFiles);
        SqlSessionFactory sessions = builder.build((Reader)reader, properties);
        if (!this.amazonS3Configuration.isEmpty() && (amazonS3Enabled = this.amazonS3Configuration.getBoolean("enabled"))) {
            String accessKey = this.amazonS3Configuration.getString("access-key");
            String securityKey = this.amazonS3Configuration.getString("security-key");
            String bucketName = this.amazonS3Configuration.getString("bucket-name");
            String folder = this.amazonS3Configuration.getString("folder");
            boolean reducedRedundancy = this.amazonS3Configuration.getBoolean("reduced-redundancy");
            int daysToRetainPublicUrl = this.amazonS3Configuration.getInt("days-to-retain-public-url");
            boolean removeOriginalFile = this.amazonS3Configuration.getBoolean("remove-original-file");
            this.s3AccessTool = new S3AccessTool(accessKey, securityKey, bucketName, folder, reducedRedundancy, daysToRetainPublicUrl, removeOriginalFile);
        }
        this.start(sessions);
    }

    public void start(SqlSessionFactory sessions) {
        this.accountsDao = new MybatisAccountsDao(sessions);
        this.applicationsDao = new MybatisApplicationsDao(sessions);
        this.announcementsDao = new MybatisAnnouncementsDao(sessions);
        this.availablePhoneNumbersDao = new MybatisAvailablePhoneNumbersDao(sessions);
        this.callDetailRecordsDao = new MybatisCallDetailRecordsDao(sessions);
        this.clientsDao = new MybatisClientsDao(sessions);
        this.httpCookiesDao = new MybatisHttpCookiesDao(sessions);
        this.incomingPhoneNumbersDao = new MybatisIncomingPhoneNumbersDao(sessions);
        this.notificationsDao = new MybatisNotificationsDao(sessions);
        this.outgoingCallerIdsDao = new MybatisOutgoingCallerIdsDao(sessions);
        this.presenceRecordsDao = new MybatisRegistrationsDao(sessions);
        if (this.s3AccessTool != null) {
            String recordingPath = this.runtimeConfiguration.getString("recordings-path");
            this.recordingsDao = new MybatisRecordingsDao(sessions, this.s3AccessTool, recordingPath);
        } else {
            this.recordingsDao = new MybatisRecordingsDao(sessions);
        }
        this.shortCodesDao = new MybatisShortCodesDao(sessions);
        this.smsMessagesDao = new MybatisSmsMessagesDao(sessions);
        this.usageDao = new MybatisUsageDao(sessions);
        this.transcriptionsDao = new MybatisTranscriptionsDao(sessions);
        this.gatewaysDao = new MybatisGatewaysDao(sessions);
    }
}

