/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.restcomm.dao.mybatis;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.joda.time.DateTime;
import org.mobicents.servlet.restcomm.annotations.concurrency.NotThreadSafe;
import org.mobicents.servlet.restcomm.dao.ClientsDao;
import org.mobicents.servlet.restcomm.dao.DaoUtils;
import org.mobicents.servlet.restcomm.entities.Client;
import org.mobicents.servlet.restcomm.entities.Sid;

@NotThreadSafe
public final class MybatisClientsDao
implements ClientsDao {
    private static final String namespace = "org.mobicents.servlet.sip.restcomm.dao.ClientsDao.";
    private final SqlSessionFactory sessions;

    public MybatisClientsDao(SqlSessionFactory sessions) {
        this.sessions = sessions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addClient(Client client) {
        try (SqlSession session = this.sessions.openSession();){
            session.insert("org.mobicents.servlet.sip.restcomm.dao.ClientsDao.addClient", this.toMap(client));
            session.commit();
        }
    }

    @Override
    public Client getClient(Sid sid) {
        return this.getClient("org.mobicents.servlet.sip.restcomm.dao.ClientsDao.getClient", sid.toString());
    }

    @Override
    public Client getClient(String login) {
        return this.getClient("org.mobicents.servlet.sip.restcomm.dao.ClientsDao.getClientByLogin", login);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Client getClient(String selector, String parameter) {
        try (SqlSession session = this.sessions.openSession();){
            Map result = (Map)session.selectOne(selector, (Object)parameter);
            if (result != null) {
                Client client = this.toClient(result);
                return client;
            }
            Client client = null;
            return client;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Client> getClients(Sid accountSid) {
        try (SqlSession session = this.sessions.openSession();){
            List results = session.selectList("org.mobicents.servlet.sip.restcomm.dao.ClientsDao.getClients", (Object)accountSid.toString());
            ArrayList<Client> clients = new ArrayList<Client>();
            if (results != null && !results.isEmpty()) {
                for (Map result : results) {
                    clients.add(this.toClient(result));
                }
            }
            ArrayList<Client> arrayList = clients;
            return arrayList;
        }
    }

    @Override
    public void removeClient(Sid sid) {
        this.removeClients("org.mobicents.servlet.sip.restcomm.dao.ClientsDao.removeClient", sid);
    }

    @Override
    public void removeClients(Sid accountSid) {
        this.removeClients("org.mobicents.servlet.sip.restcomm.dao.ClientsDao.removeClients", accountSid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeClients(String selector, Sid sid) {
        try (SqlSession session = this.sessions.openSession();){
            session.delete(selector, (Object)sid.toString());
            session.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateClient(Client client) {
        try (SqlSession session = this.sessions.openSession();){
            session.update("org.mobicents.servlet.sip.restcomm.dao.ClientsDao.updateClient", this.toMap(client));
            session.commit();
        }
    }

    private Client toClient(Map<String, Object> map) {
        Sid sid = DaoUtils.readSid(map.get("sid"));
        DateTime dateCreated = DaoUtils.readDateTime(map.get("date_created"));
        DateTime dateUpdated = DaoUtils.readDateTime(map.get("date_updated"));
        Sid accountSid = DaoUtils.readSid(map.get("account_sid"));
        String apiVersion = DaoUtils.readString(map.get("api_version"));
        String friendlyName = DaoUtils.readString(map.get("friendly_name"));
        String login = DaoUtils.readString(map.get("login"));
        String password = DaoUtils.readString(map.get("password"));
        int status = DaoUtils.readInteger(map.get("status"));
        URI voiceUrl = DaoUtils.readUri(map.get("voice_url"));
        String voiceMethod = DaoUtils.readString(map.get("voice_method"));
        URI voiceFallbackUrl = DaoUtils.readUri(map.get("voice_fallback_url"));
        String voiceFallbackMethod = DaoUtils.readString(map.get("voice_fallback_method"));
        Sid voiceApplicationSid = DaoUtils.readSid(map.get("voice_application_sid"));
        URI uri = DaoUtils.readUri(map.get("uri"));
        return new Client(sid, dateCreated, dateUpdated, accountSid, apiVersion, friendlyName, login, password, status, voiceUrl, voiceMethod, voiceFallbackUrl, voiceFallbackMethod, voiceApplicationSid, uri);
    }

    private Map<String, Object> toMap(Client client) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("sid", DaoUtils.writeSid(client.getSid()));
        map.put("date_created", DaoUtils.writeDateTime(client.getDateCreated()));
        map.put("date_updated", DaoUtils.writeDateTime(client.getDateUpdated()));
        map.put("account_sid", DaoUtils.writeSid(client.getAccountSid()));
        map.put("api_version", client.getApiVersion());
        map.put("friendly_name", client.getFriendlyName());
        map.put("login", client.getLogin());
        map.put("password", client.getPassword());
        map.put("status", client.getStatus());
        map.put("voice_url", DaoUtils.writeUri(client.getVoiceUrl()));
        map.put("voice_method", client.getVoiceMethod());
        map.put("voice_fallback_url", DaoUtils.writeUri(client.getVoiceFallbackUrl()));
        map.put("voice_fallback_method", client.getVoiceFallbackMethod());
        map.put("voice_application_sid", DaoUtils.writeSid(client.getVoiceApplicationSid()));
        map.put("uri", DaoUtils.writeUri(client.getUri()));
        return map;
    }
}

