/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.restcomm.dao.mybatis;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.joda.time.DateTime;
import org.mobicents.servlet.restcomm.annotations.concurrency.ThreadSafe;
import org.mobicents.servlet.restcomm.dao.ApplicationsDao;
import org.mobicents.servlet.restcomm.dao.DaoUtils;
import org.mobicents.servlet.restcomm.entities.Application;
import org.mobicents.servlet.restcomm.entities.Sid;

@ThreadSafe
public final class MybatisApplicationsDao
implements ApplicationsDao {
    private static final String namespace = "org.mobicents.servlet.sip.restcomm.dao.ApplicationsDao.";
    private final SqlSessionFactory sessions;

    public MybatisApplicationsDao(SqlSessionFactory sessions) {
        this.sessions = sessions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addApplication(Application application) {
        try (SqlSession session = this.sessions.openSession();){
            session.insert("org.mobicents.servlet.sip.restcomm.dao.ApplicationsDao.addApplication", this.toMap(application));
            session.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Application getApplication(Sid sid) {
        try (SqlSession session = this.sessions.openSession();){
            Map result = (Map)session.selectOne("org.mobicents.servlet.sip.restcomm.dao.ApplicationsDao.getApplication", (Object)sid.toString());
            if (result != null) {
                Application application = this.toApplication(result);
                return application;
            }
            Application application = null;
            return application;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Application> getApplications(Sid accountSid) {
        try (SqlSession session = this.sessions.openSession();){
            List results = session.selectList("org.mobicents.servlet.sip.restcomm.dao.ApplicationsDao.getApplications", (Object)accountSid.toString());
            ArrayList<Application> applications = new ArrayList<Application>();
            if (results != null && !results.isEmpty()) {
                for (Map result : results) {
                    applications.add(this.toApplication(result));
                }
            }
            ArrayList<Application> arrayList = applications;
            return arrayList;
        }
    }

    @Override
    public void removeApplication(Sid sid) {
        this.removeApplications("removeApplication", sid);
    }

    @Override
    public void removeApplications(Sid accountSid) {
        this.removeApplications("removeApplications", accountSid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeApplications(String selector, Sid sid) {
        try (SqlSession session = this.sessions.openSession();){
            session.delete(namespace + selector, (Object)sid.toString());
            session.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateApplication(Application application) {
        try (SqlSession session = this.sessions.openSession();){
            session.update("org.mobicents.servlet.sip.restcomm.dao.ApplicationsDao.updateApplication", this.toMap(application));
            session.commit();
        }
    }

    private Application toApplication(Map<String, Object> map) {
        Sid sid = DaoUtils.readSid(map.get("sid"));
        DateTime dateCreated = DaoUtils.readDateTime(map.get("date_created"));
        DateTime dateUpdated = DaoUtils.readDateTime(map.get("date_updated"));
        String friendlyName = DaoUtils.readString(map.get("friendly_name"));
        Sid accountSid = DaoUtils.readSid(map.get("account_sid"));
        String apiVersion = DaoUtils.readString(map.get("api_version"));
        URI voiceUrl = DaoUtils.readUri(map.get("voice_url"));
        String voiceMethod = DaoUtils.readString(map.get("voice_method"));
        URI voiceFallbackUrl = DaoUtils.readUri(map.get("voice_fallback_url"));
        String voiceFallbackMethod = DaoUtils.readString(map.get("voice_fallback_method"));
        URI statusCallback = DaoUtils.readUri(map.get("status_callback"));
        String statusCallbackMethod = DaoUtils.readString(map.get("status_callback_method"));
        Boolean hasVoiceCallerIdLookup = DaoUtils.readBoolean(map.get("voice_caller_id_lookup"));
        URI smsUrl = DaoUtils.readUri(map.get("sms_url"));
        String smsMethod = DaoUtils.readString(map.get("sms_method"));
        URI smsFallbackUrl = DaoUtils.readUri(map.get("sms_fallback_url"));
        String smsFallbackMethod = DaoUtils.readString(map.get("sms_fallback_method"));
        URI smsStatusCallback = DaoUtils.readUri(map.get("sms_status_callback"));
        URI uri = DaoUtils.readUri(map.get("uri"));
        return new Application(sid, dateCreated, dateUpdated, friendlyName, accountSid, apiVersion, voiceUrl, voiceMethod, voiceFallbackUrl, voiceFallbackMethod, statusCallback, statusCallbackMethod, hasVoiceCallerIdLookup, smsUrl, smsMethod, smsFallbackUrl, smsFallbackMethod, smsStatusCallback, uri);
    }

    private Map<String, Object> toMap(Application application) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("sid", DaoUtils.writeSid(application.getSid()));
        map.put("date_created", DaoUtils.writeDateTime(application.getDateCreated()));
        map.put("date_updated", DaoUtils.writeDateTime(application.getDateUpdated()));
        map.put("friendly_name", application.getFriendlyName());
        map.put("account_sid", DaoUtils.writeSid(application.getAccountSid()));
        map.put("api_version", application.getApiVersion());
        map.put("voice_url", DaoUtils.writeUri(application.getVoiceUrl()));
        map.put("voice_method", application.getVoiceMethod());
        map.put("voice_fallback_url", DaoUtils.writeUri(application.getVoiceFallbackUrl()));
        map.put("voice_fallback_method", application.getVoiceFallbackMethod());
        map.put("status_callback", DaoUtils.writeUri(application.getStatusCallback()));
        map.put("status_callback_method", application.getStatusCallbackMethod());
        map.put("voice_caller_id_lookup", application.hasVoiceCallerIdLookup());
        map.put("sms_url", DaoUtils.writeUri(application.getSmsUrl()));
        map.put("sms_method", application.getSmsMethod());
        map.put("sms_fallback_url", DaoUtils.writeUri(application.getSmsFallbackUrl()));
        map.put("sms_fallback_method", application.getSmsFallbackMethod());
        map.put("sms_status_callback", DaoUtils.writeUri(application.getSmsStatusCallback()));
        map.put("uri", DaoUtils.writeUri(application.getUri()));
        return map;
    }
}

