/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.restcomm.dao.mybatis;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.joda.time.DateTime;
import org.mobicents.servlet.restcomm.annotations.concurrency.ThreadSafe;
import org.mobicents.servlet.restcomm.dao.AccountsDao;
import org.mobicents.servlet.restcomm.dao.DaoUtils;
import org.mobicents.servlet.restcomm.entities.Account;
import org.mobicents.servlet.restcomm.entities.Sid;

@ThreadSafe
public final class MybatisAccountsDao
implements AccountsDao {
    private static final String namespace = "org.mobicents.servlet.sip.restcomm.dao.AccountsDao.";
    private final SqlSessionFactory sessions;

    public MybatisAccountsDao(SqlSessionFactory sessions) {
        this.sessions = sessions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addAccount(Account account) {
        try (SqlSession session = this.sessions.openSession();){
            session.insert("org.mobicents.servlet.sip.restcomm.dao.AccountsDao.addAccount", this.toMap(account));
            session.commit();
        }
    }

    @Override
    public Account getAccount(Sid sid) {
        return this.getAccount("org.mobicents.servlet.sip.restcomm.dao.AccountsDao.getAccount", sid.toString());
    }

    @Override
    public Account getAccount(String name) {
        Account account = null;
        account = this.getAccount("org.mobicents.servlet.sip.restcomm.dao.AccountsDao.getAccountByFriendlyName", name);
        if (account == null) {
            account = this.getAccount("org.mobicents.servlet.sip.restcomm.dao.AccountsDao.getAccountByEmail", name);
        }
        if (account == null) {
            account = this.getAccount("org.mobicents.servlet.sip.restcomm.dao.AccountsDao.getAccount", name);
        }
        return account;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Account getAccount(String selector, Object parameters) {
        try (SqlSession session = this.sessions.openSession();){
            Map result = (Map)session.selectOne(selector, parameters);
            if (result != null) {
                Account account = this.toAccount(result);
                return account;
            }
            Account account = null;
            return account;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Account> getAccounts(Sid accountSid) {
        try (SqlSession session = this.sessions.openSession();){
            List results = session.selectList("org.mobicents.servlet.sip.restcomm.dao.AccountsDao.getAccounts", (Object)accountSid.toString());
            ArrayList<Account> accounts = new ArrayList<Account>();
            if (results != null && !results.isEmpty()) {
                for (Map result : results) {
                    accounts.add(this.toAccount(result));
                }
            }
            ArrayList<Account> arrayList = accounts;
            return arrayList;
        }
    }

    @Override
    public void removeAccount(Sid sid) {
        this.removeAccount("org.mobicents.servlet.sip.restcomm.dao.AccountsDao.removeAccount", sid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAccount(String selector, Sid sid) {
        try (SqlSession session = this.sessions.openSession();){
            session.delete(selector, (Object)sid.toString());
            session.commit();
        }
    }

    @Override
    public void updateAccount(Account account) {
        this.updateAccount("org.mobicents.servlet.sip.restcomm.dao.AccountsDao.updateAccount", account);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateAccount(String selector, Account account) {
        try (SqlSession session = this.sessions.openSession();){
            session.update(selector, this.toMap(account));
            session.commit();
        }
    }

    private Account toAccount(Map<String, Object> map) {
        Sid sid = DaoUtils.readSid(map.get("sid"));
        DateTime dateCreated = DaoUtils.readDateTime(map.get("date_created"));
        DateTime dateUpdated = DaoUtils.readDateTime(map.get("date_updated"));
        String emailAddress = DaoUtils.readString(map.get("email_address"));
        String friendlyName = DaoUtils.readString(map.get("friendly_name"));
        Sid accountSid = DaoUtils.readSid(map.get("account_sid"));
        Account.Type type = DaoUtils.readAccountType(map.get("type"));
        Account.Status status = DaoUtils.readAccountStatus(map.get("status"));
        String authToken = DaoUtils.readString(map.get("auth_token"));
        String role = DaoUtils.readString(map.get("role"));
        URI uri = DaoUtils.readUri(map.get("uri"));
        return new Account(sid, dateCreated, dateUpdated, emailAddress, friendlyName, accountSid, type, status, authToken, role, uri);
    }

    private Map<String, Object> toMap(Account account) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("sid", DaoUtils.writeSid(account.getSid()));
        map.put("date_created", DaoUtils.writeDateTime(account.getDateCreated()));
        map.put("date_updated", DaoUtils.writeDateTime(account.getDateUpdated()));
        map.put("email_address", account.getEmailAddress());
        map.put("friendly_name", account.getFriendlyName());
        map.put("account_sid", DaoUtils.writeSid(account.getAccountSid()));
        map.put("type", DaoUtils.writeAccountType(account.getType()));
        map.put("status", DaoUtils.writeAccountStatus(account.getStatus()));
        map.put("auth_token", account.getAuthToken());
        map.put("role", account.getRole());
        map.put("uri", DaoUtils.writeUri(account.getUri()));
        return map;
    }
}

