/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.mgcp.parser.params;

import jain.protocol.ip.mgcp.message.parms.RequestedEvent;
import java.text.ParseException;
import java.util.ArrayList;
import org.mobicents.protocols.mgcp.parser.params.EventNameHandler;
import org.mobicents.protocols.mgcp.parser.params.RequestedActionHandler;

public class RequestedEventHandler {
    public static RequestedEvent decode(byte[] value, int offset, int length) throws ParseException {
        int startIndex = offset;
        while (value[startIndex] == 32) {
            ++startIndex;
        }
        int endIndex = offset + length - 1;
        while (value[endIndex] == 32) {
            --endIndex;
        }
        if (value[startIndex] == 40) {
            throw new ParseException("Unknown value for Requested Event: " + new String(value, offset, length), 0);
        }
        if (value[endIndex] == 41) {
            int i;
            --endIndex;
            while (value[endIndex] == 32) {
                --endIndex;
            }
            int lastEventNameIndex = startIndex;
            for (i = startIndex; i <= endIndex && value[i] != 40; ++i) {
                if (value[i] == 32) continue;
                lastEventNameIndex = i;
            }
            if (i == endIndex + 1) {
                throw new ParseException("Unknown value for Requested Event: " + new String(value, offset, length), 0);
            }
            ++i;
            while (i <= endIndex && value[i] == 32) {
                ++i;
            }
            int firstBracketIndex = i;
            int middleBracketCloser = i;
            int level = 1;
            while (i <= endIndex) {
                if (value[i] == 40) {
                    ++level;
                    middleBracketCloser = i;
                } else if (value[i] == 41) {
                    if (--level == 0) break;
                    middleBracketCloser = i;
                } else if (value[i] != 32) {
                    middleBracketCloser = i;
                }
                ++i;
            }
            switch (level) {
                case 0: {
                    ++i;
                    while (i < endIndex) {
                        if (value[i] == 40) {
                            ++i;
                            while (i < endIndex && value[i] == 32) {
                                ++i;
                            }
                            return new RequestedEvent(EventNameHandler.decodeWithParams(value, startIndex, lastEventNameIndex - startIndex + 1, i, endIndex - i + 1), RequestedActionHandler.decodeList(value, firstBracketIndex, middleBracketCloser - firstBracketIndex + 1));
                        }
                        if (value[i] != 32) {
                            throw new ParseException("Unknown value for Requested Event: " + new String(value, offset, length), 0);
                        }
                        ++i;
                    }
                    throw new ParseException("Unknown value for Requested Event: " + new String(value, offset, length), 0);
                }
                case 1: {
                    return new RequestedEvent(EventNameHandler.decode(value, startIndex, lastEventNameIndex - startIndex + 1), RequestedActionHandler.decodeList(value, firstBracketIndex, endIndex - firstBracketIndex + 1));
                }
            }
            throw new ParseException("Unknown value for Requested Event: " + new String(value, offset, length), 0);
        }
        return new RequestedEvent(EventNameHandler.decode(value, startIndex, endIndex - startIndex + 1), null);
    }

    public static int encode(byte[] destination, int offset, RequestedEvent requestedEvent) {
        int totalLength = EventNameHandler.encode(destination, offset, requestedEvent.getEventName());
        if (requestedEvent.getRequestedActions() != null) {
            destination[offset + totalLength] = 40;
            ++totalLength;
            totalLength += RequestedActionHandler.encodeList(destination, offset + totalLength, requestedEvent.getRequestedActions());
            destination[offset + totalLength] = 41;
            ++totalLength;
        }
        totalLength += EventNameHandler.encodeParams(destination, offset + totalLength, requestedEvent.getEventName());
        return totalLength;
    }

    public static int encodeList(byte[] destination, int offset, RequestedEvent[] requestedEvents) {
        int i;
        if (requestedEvents.length == 0) {
            return 0;
        }
        int totalLength = 0;
        for (i = 0; i < requestedEvents.length - 1; ++i) {
            totalLength += RequestedEventHandler.encode(destination, offset + totalLength, requestedEvents[i]);
            destination[offset + totalLength] = 44;
            ++totalLength;
        }
        totalLength += RequestedEventHandler.encode(destination, offset + totalLength, requestedEvents[i]);
        return totalLength;
    }

    public static RequestedEvent[] decodeList(byte[] value, int offset, int length) throws ParseException {
        ArrayList<RequestedEvent> result = new ArrayList<RequestedEvent>();
        int currIndex = offset;
        int startIndex = offset;
        int i = 0;
        while (value[startIndex] == 32 && i < length) {
            ++startIndex;
            ++i;
            ++currIndex;
        }
        int depth = 0;
        while (i < length) {
            switch (value[currIndex]) {
                case 40: {
                    ++depth;
                    break;
                }
                case 44: {
                    if (depth != 0 || i >= length) break;
                    result.add(RequestedEventHandler.decode(value, startIndex, currIndex - startIndex));
                    startIndex = currIndex + 1;
                    while (i < length - 1 && value[startIndex] == 32) {
                        ++startIndex;
                        ++i;
                        ++currIndex;
                    }
                    break;
                }
                case 41: {
                    if (--depth != 0 || i >= length) break;
                    while (i < length && value[currIndex] == 32) {
                        ++i;
                        ++currIndex;
                    }
                    if (value[currIndex + 1] != 44) break;
                    result.add(RequestedEventHandler.decode(value, startIndex, currIndex - startIndex + 1));
                    startIndex = currIndex + 2;
                    ++i;
                    ++currIndex;
                    while (i < length - 1 && value[startIndex] == 32) {
                        ++startIndex;
                        ++i;
                        ++currIndex;
                    }
                    break;
                }
            }
            ++i;
            ++currIndex;
        }
        if (startIndex < offset + length) {
            result.add(RequestedEventHandler.decode(value, startIndex, offset + length - startIndex));
        }
        RequestedEvent[] requestedEvents = new RequestedEvent[result.size()];
        requestedEvents = result.toArray(requestedEvents);
        result.clear();
        return requestedEvents;
    }
}

