/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.httpservice;

import java.util.Hashtable;
import org.apache.catalina.Host;
import org.apache.catalina.core.StandardContext;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.as.controller.services.path.PathManagerService;
import org.jboss.as.osgi.httpservice.HttpServiceFactory;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.as.server.ServerEnvironmentService;
import org.jboss.as.server.mgmt.HttpManagementService;
import org.jboss.as.server.mgmt.domain.HttpManagement;
import org.jboss.as.web.VirtualHost;
import org.jboss.as.web.WebServer;
import org.jboss.as.web.WebSubsystemServices;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.osgi.framework.Services;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.http.HttpService;

final class HttpServiceFactoryService
implements Service<StandardContext> {
    static final ServiceName JBOSS_WEB_HTTPSERVICE_FACTORY = WebSubsystemServices.JBOSS_WEB.append(new String[]{"httpservice", "factory"});
    static final String VIRTUAL_HOST = "default-host";
    private final InjectedValue<ServerEnvironment> injectedServerEnvironment = new InjectedValue();
    private final InjectedValue<BundleContext> injectedSystemContext = new InjectedValue();
    private final InjectedValue<PathManager> injectedPathManager = new InjectedValue();
    private final InjectedValue<VirtualHost> injectedVirtualHost = new InjectedValue();
    private final InjectedValue<HttpManagement> injectedHttpManagement = new InjectedValue();
    private final InjectedValue<WebServer> injectedWebServer = new InjectedValue();
    private ServiceRegistration registration;

    static ServiceController<StandardContext> addService(ServiceTarget serviceTarget) {
        HttpServiceFactoryService service = new HttpServiceFactoryService();
        ServiceBuilder builder = serviceTarget.addService(JBOSS_WEB_HTTPSERVICE_FACTORY, (Service)service);
        builder.addDependency(ServerEnvironmentService.SERVICE_NAME, ServerEnvironment.class, service.injectedServerEnvironment);
        builder.addDependency(PathManagerService.SERVICE_NAME, PathManager.class, service.injectedPathManager);
        builder.addDependency(WebSubsystemServices.JBOSS_WEB_HOST.append(new String[]{VIRTUAL_HOST}), VirtualHost.class, service.injectedVirtualHost);
        builder.addDependency(WebSubsystemServices.JBOSS_WEB, WebServer.class, service.injectedWebServer);
        builder.addDependency(ServiceBuilder.DependencyType.OPTIONAL, HttpManagementService.SERVICE_NAME, HttpManagement.class, service.injectedHttpManagement);
        builder.addDependency(Services.FRAMEWORK_CREATE, BundleContext.class, service.injectedSystemContext);
        return builder.install();
    }

    private HttpServiceFactoryService() {
    }

    public void start(StartContext startContext) throws StartException {
        ServerEnvironment serverEnvironment = (ServerEnvironment)this.injectedServerEnvironment.getValue();
        Host virtualHost = ((VirtualHost)this.injectedVirtualHost.getValue()).getHost();
        BundleContext syscontext = (BundleContext)this.injectedSystemContext.getValue();
        WebServer webServer = (WebServer)this.injectedWebServer.getValue();
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("provider", this.getClass().getPackage().getName());
        HttpServiceFactory serviceFactory = new HttpServiceFactory(webServer, virtualHost, serverEnvironment);
        this.registration = syscontext.registerService(HttpService.class.getName(), (Object)serviceFactory, props);
    }

    public void stop(StopContext stopContext) {
        this.registration.unregister();
    }

    public StandardContext getValue() throws IllegalStateException {
        return null;
    }
}

