/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.restcomm.mscontrol.mgcp;

import akka.actor.Actor;
import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.Props;
import akka.actor.UntypedActorFactory;
import org.mobicents.servlet.restcomm.mscontrol.MediaServerControllerFactory;
import org.mobicents.servlet.restcomm.mscontrol.mgcp.MmsBridgeController;
import org.mobicents.servlet.restcomm.mscontrol.mgcp.MmsCallController;
import org.mobicents.servlet.restcomm.mscontrol.mgcp.MmsConferenceController;

public class MmsControllerFactory
implements MediaServerControllerFactory {
    private final ActorSystem system;
    private final ActorRef mediaGateway;
    private final CallControllerFactory callControllerFactory;
    private final ConferenceControllerFactory conferenceControllerFactory;
    private final BridgeControllerFactory bridgeControllerFactory;

    public MmsControllerFactory(ActorSystem system, ActorRef mediaGateway) {
        this.system = system;
        this.mediaGateway = mediaGateway;
        this.callControllerFactory = new CallControllerFactory();
        this.conferenceControllerFactory = new ConferenceControllerFactory();
        this.bridgeControllerFactory = new BridgeControllerFactory();
    }

    public ActorRef provideCallController() {
        return this.system.actorOf(new Props((UntypedActorFactory)this.callControllerFactory));
    }

    public ActorRef provideConferenceController() {
        return this.system.actorOf(new Props((UntypedActorFactory)this.conferenceControllerFactory));
    }

    public ActorRef provideBridgeController() {
        return this.system.actorOf(new Props((UntypedActorFactory)this.bridgeControllerFactory));
    }

    private final class BridgeControllerFactory
    implements UntypedActorFactory {
        private static final long serialVersionUID = 8999152285760508857L;

        private BridgeControllerFactory() {
        }

        public Actor create() throws Exception {
            return new MmsBridgeController(MmsControllerFactory.this.mediaGateway);
        }
    }

    private final class ConferenceControllerFactory
    implements UntypedActorFactory {
        private static final long serialVersionUID = -919317656354678281L;

        private ConferenceControllerFactory() {
        }

        public Actor create() throws Exception {
            return new MmsConferenceController(MmsControllerFactory.this.mediaGateway);
        }
    }

    private final class CallControllerFactory
    implements UntypedActorFactory {
        private static final long serialVersionUID = -4649683839304615853L;

        private CallControllerFactory() {
        }

        public Actor create() throws Exception {
            return new MmsCallController(MmsControllerFactory.this.mediaGateway);
        }
    }
}

