/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.restcomm.mscontrol.mgcp;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.Props;
import akka.actor.UntypedActor;
import akka.actor.UntypedActorFactory;
import akka.event.Logging;
import akka.event.LoggingAdapter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.joda.time.DateTime;
import org.mobicents.servlet.restcomm.annotations.concurrency.Immutable;
import org.mobicents.servlet.restcomm.fsm.Action;
import org.mobicents.servlet.restcomm.fsm.FiniteStateMachine;
import org.mobicents.servlet.restcomm.fsm.State;
import org.mobicents.servlet.restcomm.fsm.Transition;
import org.mobicents.servlet.restcomm.mgcp.CreateConferenceEndpoint;
import org.mobicents.servlet.restcomm.mgcp.DestroyEndpoint;
import org.mobicents.servlet.restcomm.mgcp.MediaGatewayResponse;
import org.mobicents.servlet.restcomm.mgcp.MediaSession;
import org.mobicents.servlet.restcomm.mscontrol.MediaServerController;
import org.mobicents.servlet.restcomm.mscontrol.messages.CloseMediaSession;
import org.mobicents.servlet.restcomm.mscontrol.messages.CreateMediaSession;
import org.mobicents.servlet.restcomm.mscontrol.messages.JoinBridge;
import org.mobicents.servlet.restcomm.mscontrol.messages.JoinCall;
import org.mobicents.servlet.restcomm.mscontrol.messages.MediaGroupStateChanged;
import org.mobicents.servlet.restcomm.mscontrol.messages.MediaServerControllerStateChanged;
import org.mobicents.servlet.restcomm.mscontrol.messages.Play;
import org.mobicents.servlet.restcomm.mscontrol.messages.Record;
import org.mobicents.servlet.restcomm.mscontrol.messages.StartMediaGroup;
import org.mobicents.servlet.restcomm.mscontrol.messages.StartRecording;
import org.mobicents.servlet.restcomm.mscontrol.messages.Stop;
import org.mobicents.servlet.restcomm.mscontrol.messages.StopMediaGroup;
import org.mobicents.servlet.restcomm.mscontrol.messages.StopRecording;
import org.mobicents.servlet.restcomm.mscontrol.mgcp.MgcpMediaGroup;
import org.mobicents.servlet.restcomm.patterns.Observe;
import org.mobicents.servlet.restcomm.patterns.Observing;
import org.mobicents.servlet.restcomm.patterns.StopObserving;

@Immutable
public final class MmsConferenceController
extends MediaServerController {
    private final LoggingAdapter logger = Logging.getLogger((ActorSystem)this.getContext().system(), (Object)((Object)this));
    private final FiniteStateMachine fsm;
    private final State uninitialized;
    private final State active;
    private final State inactive;
    private final State failed;
    private final State acquiringMediaSession;
    private final State acquiringEndpoint;
    private final State creatingMediaGroup;
    private final State destroyingMediaGroup;
    private Boolean fail;
    private final ActorRef mediaGateway;
    private MediaSession mediaSession;
    private ActorRef cnfEndpoint;
    private ActorRef conference;
    private ActorRef mediaGroup;
    private Boolean playing;
    private Boolean recording;
    private DateTime recordStarted;
    private final List<ActorRef> observers;

    public MmsConferenceController(ActorRef mediaGateway) {
        ActorRef source = this.self();
        this.uninitialized = new State("uninitialized", null, null);
        this.active = new State("active", (Action)new Active(source), null);
        this.inactive = new State("inactive", (Action)new Inactive(source), null);
        this.failed = new State("failed", (Action)new Failed(source), null);
        this.acquiringMediaSession = new State("acquiring media session", (Action)new AcquiringMediaSession(source), null);
        this.acquiringEndpoint = new State("acquiring endpoint", (Action)new AcquiringEndpoint(source), null);
        this.creatingMediaGroup = new State("creating media group", (Action)new CreatingMediaGroup(source), null);
        this.destroyingMediaGroup = new State("destroying media group", (Action)new DestroyingMediaGroup(source), null);
        HashSet<Transition> transitions = new HashSet<Transition>();
        transitions.add(new Transition(this.uninitialized, this.acquiringMediaSession));
        transitions.add(new Transition(this.acquiringMediaSession, this.acquiringEndpoint));
        transitions.add(new Transition(this.acquiringMediaSession, this.inactive));
        transitions.add(new Transition(this.acquiringEndpoint, this.creatingMediaGroup));
        transitions.add(new Transition(this.acquiringEndpoint, this.inactive));
        transitions.add(new Transition(this.creatingMediaGroup, this.active));
        transitions.add(new Transition(this.creatingMediaGroup, this.destroyingMediaGroup));
        transitions.add(new Transition(this.creatingMediaGroup, this.failed));
        transitions.add(new Transition(this.active, this.destroyingMediaGroup));
        transitions.add(new Transition(this.destroyingMediaGroup, this.inactive));
        this.fsm = new FiniteStateMachine(this.uninitialized, transitions);
        this.fail = Boolean.FALSE;
        this.mediaGateway = mediaGateway;
        this.playing = Boolean.FALSE;
        this.recording = Boolean.FALSE;
        this.observers = new ArrayList<ActorRef>(2);
    }

    private boolean is(State state) {
        return this.fsm.state().equals((Object)state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void broadcast(Object message) {
        if (!this.observers.isEmpty()) {
            ActorRef self = this.self();
            List<ActorRef> list = this.observers;
            synchronized (list) {
                for (ActorRef observer : this.observers) {
                    observer.tell(message, self);
                }
            }
        }
    }

    public void onReceive(Object message) throws Exception {
        Class<?> klass = message.getClass();
        ActorRef sender = this.sender();
        ActorRef self = this.self();
        State state = this.fsm.state();
        this.logger.info(" ********** Conference Controller Current State: " + state.toString());
        this.logger.info(" ********** Conference Controller Processing Message: " + klass.getName());
        if (Observe.class.equals(klass)) {
            this.onObserve((Observe)message, self, sender);
        } else if (StopObserving.class.equals(klass)) {
            this.onStopObserving((StopObserving)message, self, sender);
        } else if (CreateMediaSession.class.equals(klass)) {
            this.onCreateMediaSession((CreateMediaSession)message, self, sender);
        } else if (CloseMediaSession.class.equals(klass)) {
            this.onCloseMediaSession((CloseMediaSession)message, self, sender);
        } else if (MediaGatewayResponse.class.equals(klass)) {
            this.onMediaGatewayResponse((MediaGatewayResponse)message, self, sender);
        } else if (Stop.class.equals(klass)) {
            this.onStop((Stop)message, self, sender);
        } else if (MediaGroupStateChanged.class.equals(klass)) {
            this.onMediaGroupStateChanged((MediaGroupStateChanged)message, self, sender);
        } else if (StopMediaGroup.class.equals(klass)) {
            this.onStopMediaGroup((StopMediaGroup)message, self, sender);
        } else if (JoinCall.class.equals(klass)) {
            this.onJoinCall((JoinCall)message, self, sender);
        } else if (Play.class.equals(klass)) {
            this.onPlay((Play)message, self, sender);
        } else if (StartRecording.class.equals(klass)) {
            this.onStartRecording((StartRecording)message, self, sender);
        } else if (StopRecording.class.equals(klass)) {
            this.onStopRecording((StopRecording)message, self, sender);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onObserve(Observe message, ActorRef self, ActorRef sender) {
        ActorRef observer = message.observer();
        if (observer != null) {
            List<ActorRef> list = this.observers;
            synchronized (list) {
                this.observers.add(observer);
                observer.tell((Object)new Observing(self), self);
            }
        }
    }

    private void onStopObserving(StopObserving message, ActorRef self, ActorRef sender) {
        ActorRef observer = message.observer();
        if (observer != null) {
            this.observers.remove(observer);
        }
    }

    private void onCreateMediaSession(CreateMediaSession message, ActorRef self, ActorRef sender) throws Exception {
        if (this.is(this.uninitialized)) {
            this.conference = sender;
            this.fsm.transition((Object)message, this.acquiringMediaSession);
        }
    }

    private void onCloseMediaSession(CloseMediaSession message, ActorRef self, ActorRef sender) throws Exception {
        if (this.is(this.active)) {
            this.fsm.transition((Object)message, this.inactive);
        } else {
            this.fsm.transition((Object)message, this.destroyingMediaGroup);
        }
    }

    private void onStop(Stop message, ActorRef self, ActorRef sender) throws Exception {
        if (this.is(this.acquiringMediaSession) || this.is(this.acquiringEndpoint)) {
            this.fsm.transition((Object)message, this.inactive);
        } else if (this.is(this.creatingMediaGroup) || this.is(this.active)) {
            this.fsm.transition((Object)message, this.destroyingMediaGroup);
        }
    }

    private void onMediaGatewayResponse(MediaGatewayResponse<?> message, ActorRef self, ActorRef sender) throws Exception {
        if (this.is(this.acquiringMediaSession)) {
            this.mediaSession = (MediaSession)message.get();
            this.fsm.transition(message, this.acquiringEndpoint);
        } else if (this.is(this.acquiringEndpoint)) {
            this.cnfEndpoint = (ActorRef)message.get();
            this.fsm.transition(message, this.creatingMediaGroup);
        }
    }

    private void onMediaGroupStateChanged(MediaGroupStateChanged message, ActorRef self, ActorRef sender) throws Exception {
        switch (message.state()) {
            case ACTIVE: {
                if (!this.is(this.creatingMediaGroup)) break;
                this.fsm.transition((Object)message, this.active);
                break;
            }
            case INACTIVE: {
                if (this.is(this.creatingMediaGroup)) {
                    this.fail = Boolean.TRUE;
                    this.fsm.transition((Object)message, this.failed);
                    break;
                }
                if (!this.is(this.destroyingMediaGroup)) break;
                if (this.fail.booleanValue()) {
                    this.fsm.transition((Object)message, this.failed);
                    break;
                }
                this.fsm.transition((Object)message, this.inactive);
                break;
            }
        }
    }

    private void onStopMediaGroup(StopMediaGroup message, ActorRef self, ActorRef sender) {
        if (this.is(this.active)) {
            this.mediaGroup.tell((Object)new Stop(), self);
            this.playing = Boolean.FALSE;
        }
    }

    private void onJoinCall(JoinCall message, ActorRef self, ActorRef sender) {
        JoinBridge join = new JoinBridge((Object)this.cnfEndpoint, message.getConnectionMode());
        message.getCall().tell((Object)join, sender);
    }

    private void onPlay(Play message, ActorRef self, ActorRef sender) {
        if (this.is(this.active) && !this.playing.booleanValue()) {
            this.playing = Boolean.TRUE;
            this.mediaGroup.tell((Object)message, sender);
        }
    }

    private void onStartRecording(StartRecording message, ActorRef self, ActorRef sender) throws Exception {
        if (this.is(this.active) && !this.recording.booleanValue()) {
            String finishOnKey = "1234567890*#";
            int maxLength = 3600;
            int timeout = 5;
            this.recording = Boolean.TRUE;
            this.recordStarted = DateTime.now();
            Record record = new Record(message.getRecordingUri(), timeout, maxLength, finishOnKey);
            this.mediaGroup.tell((Object)record, null);
        }
    }

    private void onStopRecording(StopRecording message, ActorRef self, ActorRef sender) throws Exception {
        if (this.is(this.active) && this.recording.booleanValue()) {
            this.recording = Boolean.FALSE;
            this.mediaGroup.tell((Object)new Stop(), null);
        }
    }

    private final class Failed
    extends FinalState {
        public Failed(ActorRef source) {
            super(source, MediaServerControllerStateChanged.MediaServerControllerState.FAILED);
        }
    }

    private final class Inactive
    extends FinalState {
        public Inactive(ActorRef source) {
            super(source, MediaServerControllerStateChanged.MediaServerControllerState.INACTIVE);
        }
    }

    private abstract class FinalState
    extends AbstractAction {
        private final MediaServerControllerStateChanged.MediaServerControllerState state;

        public FinalState(ActorRef source, MediaServerControllerStateChanged.MediaServerControllerState state) {
            super(source);
            this.state = state;
        }

        public void execute(Object message) throws Exception {
            if (MmsConferenceController.this.cnfEndpoint != null) {
                MmsConferenceController.this.mediaGateway.tell((Object)new DestroyEndpoint(MmsConferenceController.this.cnfEndpoint), this.source);
                MmsConferenceController.this.cnfEndpoint = null;
            }
            MmsConferenceController.this.broadcast(new MediaServerControllerStateChanged(this.state));
            MmsConferenceController.this.observers.clear();
            MmsConferenceController.this.getContext().stop(this.source);
        }
    }

    private final class Active
    extends AbstractAction {
        public Active(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            MmsConferenceController.this.broadcast(new MediaServerControllerStateChanged(MediaServerControllerStateChanged.MediaServerControllerState.ACTIVE));
        }
    }

    private final class DestroyingMediaGroup
    extends AbstractAction {
        public DestroyingMediaGroup(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            MmsConferenceController.this.mediaGroup.tell((Object)new StopMediaGroup(), this.source);
        }
    }

    private final class CreatingMediaGroup
    extends AbstractAction {
        public CreatingMediaGroup(ActorRef source) {
            super(source);
        }

        private ActorRef createMediaGroup(Object message) {
            return MmsConferenceController.this.getContext().actorOf(new Props(new UntypedActorFactory(){
                private static final long serialVersionUID = 1L;

                public UntypedActor create() throws Exception {
                    return new MgcpMediaGroup(MmsConferenceController.this.mediaGateway, MmsConferenceController.this.mediaSession, MmsConferenceController.this.cnfEndpoint);
                }
            }));
        }

        public void execute(Object message) throws Exception {
            MmsConferenceController.this.mediaGroup = this.createMediaGroup(message);
            MmsConferenceController.this.mediaGroup.tell((Object)new Observe(this.source), this.source);
            MmsConferenceController.this.mediaGroup.tell((Object)new StartMediaGroup(), this.source);
        }
    }

    private final class AcquiringEndpoint
    extends AbstractAction {
        public AcquiringEndpoint(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            MmsConferenceController.this.mediaGateway.tell((Object)new CreateConferenceEndpoint(MmsConferenceController.this.mediaSession), this.source);
        }
    }

    private final class AcquiringMediaSession
    extends AbstractAction {
        public AcquiringMediaSession(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            MmsConferenceController.this.mediaGateway.tell((Object)new org.mobicents.servlet.restcomm.mgcp.CreateMediaSession(), this.source);
        }
    }

    private abstract class AbstractAction
    implements Action {
        protected final ActorRef source;

        public AbstractAction(ActorRef source) {
            this.source = source;
        }
    }
}

