/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.restcomm.mscontrol.mgcp;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.Props;
import akka.actor.UntypedActor;
import akka.actor.UntypedActorFactory;
import akka.event.Logging;
import akka.event.LoggingAdapter;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.apache.commons.configuration.Configuration;
import org.joda.time.DateTime;
import org.mobicents.servlet.restcomm.dao.DaoManager;
import org.mobicents.servlet.restcomm.dao.RecordingsDao;
import org.mobicents.servlet.restcomm.entities.Recording;
import org.mobicents.servlet.restcomm.entities.Sid;
import org.mobicents.servlet.restcomm.fsm.Action;
import org.mobicents.servlet.restcomm.fsm.FiniteStateMachine;
import org.mobicents.servlet.restcomm.fsm.State;
import org.mobicents.servlet.restcomm.fsm.Transition;
import org.mobicents.servlet.restcomm.mgcp.CreateConferenceEndpoint;
import org.mobicents.servlet.restcomm.mgcp.DestroyEndpoint;
import org.mobicents.servlet.restcomm.mgcp.MediaGatewayResponse;
import org.mobicents.servlet.restcomm.mgcp.MediaSession;
import org.mobicents.servlet.restcomm.mscontrol.MediaServerController;
import org.mobicents.servlet.restcomm.mscontrol.messages.CreateMediaSession;
import org.mobicents.servlet.restcomm.mscontrol.messages.JoinBridge;
import org.mobicents.servlet.restcomm.mscontrol.messages.JoinCall;
import org.mobicents.servlet.restcomm.mscontrol.messages.MediaGroupStateChanged;
import org.mobicents.servlet.restcomm.mscontrol.messages.MediaServerControllerStateChanged;
import org.mobicents.servlet.restcomm.mscontrol.messages.Record;
import org.mobicents.servlet.restcomm.mscontrol.messages.StartMediaGroup;
import org.mobicents.servlet.restcomm.mscontrol.messages.StartRecording;
import org.mobicents.servlet.restcomm.mscontrol.messages.Stop;
import org.mobicents.servlet.restcomm.mscontrol.messages.StopMediaGroup;
import org.mobicents.servlet.restcomm.mscontrol.mgcp.MgcpMediaGroup;
import org.mobicents.servlet.restcomm.patterns.Observe;
import org.mobicents.servlet.restcomm.patterns.Observing;
import org.mobicents.servlet.restcomm.patterns.StopObserving;
import org.mobicents.servlet.restcomm.util.WavUtils;

public class MmsBridgeController
extends MediaServerController {
    private final LoggingAdapter logger = Logging.getLogger((ActorSystem)this.getContext().system(), (Object)((Object)this));
    private final FiniteStateMachine fsm;
    private final State uninitialized;
    private final State active;
    private final State acquiringMediaSession;
    private final State acquiringEndpoint;
    private final State creatingMediaGroup;
    private final State destroyingMediaGroup;
    private final State inactive;
    private final State failed;
    private Boolean fail;
    private final ActorRef mediaGateway;
    private MediaSession mediaSession;
    private ActorRef endpoint;
    private ActorRef bridge;
    private ActorRef mediaGroup;
    private Boolean recording;
    private DateTime recordStarted;
    private StartRecording recordingRequest;
    private final List<ActorRef> observers;

    public MmsBridgeController(ActorRef mediaGateway) {
        ActorRef self = this.self();
        this.uninitialized = new State("uninitialized", null, null);
        this.active = new State("active", (Action)new Active(self), null);
        this.acquiringMediaSession = new State("acquiring media session", (Action)new AcquiringMediaSession(self), null);
        this.acquiringEndpoint = new State("acquiring endpoint", (Action)new AcquiringEndpoint(self), null);
        this.creatingMediaGroup = new State("creating media group", (Action)new CreatingMediaGroup(self), null);
        this.destroyingMediaGroup = new State("destroying media group", (Action)new DestroyingMediaGroup(self), null);
        this.inactive = new State("inactive", (Action)new Inactive(self), null);
        this.failed = new State("failed", (Action)new Failed(self), null);
        HashSet<Transition> transitions = new HashSet<Transition>();
        transitions.add(new Transition(this.uninitialized, this.acquiringMediaSession));
        transitions.add(new Transition(this.acquiringMediaSession, this.acquiringEndpoint));
        transitions.add(new Transition(this.acquiringMediaSession, this.inactive));
        transitions.add(new Transition(this.acquiringEndpoint, this.creatingMediaGroup));
        transitions.add(new Transition(this.acquiringEndpoint, this.inactive));
        transitions.add(new Transition(this.creatingMediaGroup, this.active));
        transitions.add(new Transition(this.creatingMediaGroup, this.destroyingMediaGroup));
        transitions.add(new Transition(this.creatingMediaGroup, this.failed));
        transitions.add(new Transition(this.active, this.destroyingMediaGroup));
        transitions.add(new Transition(this.destroyingMediaGroup, this.inactive));
        this.fsm = new FiniteStateMachine(this.uninitialized, transitions);
        this.fail = Boolean.FALSE;
        this.mediaGateway = mediaGateway;
        this.recording = Boolean.FALSE;
        this.observers = new ArrayList<ActorRef>(1);
    }

    private boolean is(State state) {
        return this.fsm.state().equals((Object)state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void broadcast(Object message) {
        if (!this.observers.isEmpty()) {
            ActorRef self = this.self();
            List<ActorRef> list = this.observers;
            synchronized (list) {
                for (ActorRef observer : this.observers) {
                    observer.tell(message, self);
                }
            }
        }
    }

    private void saveRecording() {
        Double duration;
        Sid accountId = this.recordingRequest.getAccountId();
        Sid callId = this.recordingRequest.getCallId();
        DaoManager daoManager = this.recordingRequest.getDaoManager();
        Sid recordingSid = this.recordingRequest.getRecordingSid();
        URI recordingUri = this.recordingRequest.getRecordingUri();
        Configuration runtimeSettings = this.recordingRequest.getRuntimeSetting();
        try {
            duration = WavUtils.getAudioDuration((URI)recordingUri);
        }
        catch (IOException | UnsupportedAudioFileException e) {
            this.logger.error("Could not measure recording duration: " + e.getMessage(), (Object)e);
            duration = 0.0;
        }
        if (duration.equals(0.0)) {
            this.logger.info("Call wraping up recording. File doesn't exist since duration is 0");
            DateTime end = DateTime.now();
            duration = new Double((end.getMillis() - this.recordStarted.getMillis()) / 1000L);
        } else {
            this.logger.info("Call wraping up recording. File already exists, length: " + new File(recordingUri).length());
        }
        Recording.Builder builder = Recording.builder();
        builder.setSid(recordingSid);
        builder.setAccountSid(accountId);
        builder.setCallSid(callId);
        builder.setDuration(duration.doubleValue());
        builder.setApiVersion(runtimeSettings.getString("api-version"));
        StringBuilder buffer = new StringBuilder();
        buffer.append("/").append(runtimeSettings.getString("api-version")).append("/Accounts/").append(accountId.toString());
        buffer.append("/Recordings/").append(recordingSid.toString());
        builder.setUri(URI.create(buffer.toString()));
        Recording recording = builder.build();
        RecordingsDao recordsDao = daoManager.getRecordingsDao();
        recordsDao.addRecording(recording);
    }

    public void onReceive(Object message) throws Exception {
        Class<?> klass = message.getClass();
        ActorRef self = this.self();
        ActorRef sender = this.sender();
        State state = this.fsm.state();
        this.logger.info("********** Bridge Controller " + this.self().path() + " State: \"" + state.toString());
        this.logger.info("********** Bridge Controller " + this.self().path() + " Processing: \"" + klass.getName() + " Sender: " + sender.getClass());
        if (Observe.class.equals(klass)) {
            this.onObserve((Observe)message, self, sender);
        } else if (StopObserving.class.equals(klass)) {
            this.onStopObserving((StopObserving)message, self, sender);
        } else if (CreateMediaSession.class.equals(klass)) {
            this.onCreateMediaSession((CreateMediaSession)message, self, sender);
        } else if (JoinCall.class.equals(klass)) {
            this.onJoinCall((JoinCall)message, self, sender);
        } else if (Stop.class.equals(klass)) {
            this.onStop((Stop)message, self, sender);
        } else if (MediaGatewayResponse.class.equals(klass)) {
            this.onMediaGatewayResponse((MediaGatewayResponse)message, self, sender);
        } else if (MediaGroupStateChanged.class.equals(klass)) {
            this.onMediaGroupStateChanged((MediaGroupStateChanged)message, self, sender);
        } else if (StartRecording.class.equals(klass)) {
            this.onStartRecording((StartRecording)message, self, sender);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onObserve(Observe message, ActorRef self, ActorRef sender) {
        ActorRef observer = message.observer();
        if (observer != null) {
            List<ActorRef> list = this.observers;
            synchronized (list) {
                this.observers.add(observer);
                observer.tell((Object)new Observing(self), self);
            }
        }
    }

    private void onStopObserving(StopObserving message, ActorRef self, ActorRef sender) {
        ActorRef observer = message.observer();
        if (observer != null) {
            this.observers.remove(observer);
        }
    }

    private void onCreateMediaSession(CreateMediaSession message, ActorRef self, ActorRef sender) throws Exception {
        if (this.is(this.uninitialized)) {
            this.bridge = sender;
            this.fsm.transition((Object)message, this.acquiringMediaSession);
        }
    }

    private void onJoinCall(JoinCall message, ActorRef self, ActorRef sender) {
        JoinBridge join = new JoinBridge((Object)this.endpoint, message.getConnectionMode());
        message.getCall().tell((Object)join, sender);
    }

    private void onStop(Stop message, ActorRef self, ActorRef sender) throws Exception {
        if (this.is(this.acquiringMediaSession) || this.is(this.acquiringEndpoint)) {
            this.fsm.transition((Object)message, this.inactive);
        } else if (this.is(this.creatingMediaGroup) || this.is(this.active)) {
            this.fsm.transition((Object)message, this.destroyingMediaGroup);
        }
    }

    private void onMediaGatewayResponse(MediaGatewayResponse<?> message, ActorRef self, ActorRef sender) throws Exception {
        if (this.is(this.acquiringMediaSession)) {
            this.mediaSession = (MediaSession)message.get();
            this.fsm.transition(message, this.acquiringEndpoint);
        } else if (this.is(this.acquiringEndpoint)) {
            this.endpoint = (ActorRef)message.get();
            this.fsm.transition(message, this.creatingMediaGroup);
        }
    }

    private void onMediaGroupStateChanged(MediaGroupStateChanged message, ActorRef self, ActorRef sender) throws Exception {
        switch (message.state()) {
            case ACTIVE: {
                if (!this.is(this.creatingMediaGroup)) break;
                this.fsm.transition((Object)message, this.active);
                break;
            }
            case INACTIVE: {
                if (this.is(this.creatingMediaGroup)) {
                    this.fail = Boolean.TRUE;
                    this.fsm.transition((Object)message, this.failed);
                    break;
                }
                if (!this.is(this.destroyingMediaGroup)) break;
                if (this.fail.booleanValue()) {
                    this.fsm.transition((Object)message, this.failed);
                    break;
                }
                if (this.recordStarted != null) {
                    this.saveRecording();
                    this.recordStarted = null;
                    this.recordingRequest = null;
                }
                this.fsm.transition((Object)message, this.inactive);
                break;
            }
        }
    }

    private void onStartRecording(StartRecording message, ActorRef self, ActorRef sender) {
        if (this.is(this.active) && !this.recording.booleanValue()) {
            this.logger.info("Start recording bridged call");
            String finishOnKey = "1234567890*#";
            int maxLength = 3600;
            int timeout = 5;
            this.recording = Boolean.TRUE;
            this.recordStarted = DateTime.now();
            this.recordingRequest = message;
            Record record = new Record(message.getRecordingUri(), timeout, maxLength, finishOnKey);
            this.mediaGroup.tell((Object)record, self);
        }
    }

    private final class Failed
    extends FinalState {
        public Failed(ActorRef source) {
            super(source, MediaServerControllerStateChanged.MediaServerControllerState.FAILED);
        }
    }

    private final class Inactive
    extends FinalState {
        public Inactive(ActorRef source) {
            super(source, MediaServerControllerStateChanged.MediaServerControllerState.INACTIVE);
        }
    }

    private abstract class FinalState
    extends AbstractAction {
        private final MediaServerControllerStateChanged.MediaServerControllerState state;

        public FinalState(ActorRef source, MediaServerControllerStateChanged.MediaServerControllerState state) {
            super(source);
            this.state = state;
        }

        public void execute(Object message) throws Exception {
            if (MmsBridgeController.this.endpoint != null) {
                MmsBridgeController.this.mediaGateway.tell((Object)new DestroyEndpoint(MmsBridgeController.this.endpoint), this.source);
                MmsBridgeController.this.endpoint = null;
            }
            MmsBridgeController.this.broadcast(new MediaServerControllerStateChanged(this.state));
            MmsBridgeController.this.observers.clear();
            MmsBridgeController.this.getContext().stop(this.source);
        }
    }

    private final class DestroyingMediaGroup
    extends AbstractAction {
        public DestroyingMediaGroup(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            if (MmsBridgeController.this.recording.booleanValue()) {
                MmsBridgeController.this.mediaGroup.tell((Object)new Stop(), this.source);
                MmsBridgeController.this.recording = Boolean.FALSE;
            }
            MmsBridgeController.this.mediaGroup.tell((Object)new StopMediaGroup(), this.source);
        }
    }

    private final class Active
    extends AbstractAction {
        public Active(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            MmsBridgeController.this.broadcast(new MediaServerControllerStateChanged(MediaServerControllerStateChanged.MediaServerControllerState.ACTIVE));
        }
    }

    private final class CreatingMediaGroup
    extends AbstractAction {
        public CreatingMediaGroup(ActorRef source) {
            super(source);
        }

        private ActorRef createMediaGroup(Object message) {
            return MmsBridgeController.this.getContext().actorOf(new Props(new UntypedActorFactory(){
                private static final long serialVersionUID = 1L;

                public UntypedActor create() throws Exception {
                    return new MgcpMediaGroup(MmsBridgeController.this.mediaGateway, MmsBridgeController.this.mediaSession, MmsBridgeController.this.endpoint);
                }
            }));
        }

        public void execute(Object message) throws Exception {
            MmsBridgeController.this.mediaGroup = this.createMediaGroup(message);
            MmsBridgeController.this.mediaGroup.tell((Object)new Observe(this.source), this.source);
            MmsBridgeController.this.mediaGroup.tell((Object)new StartMediaGroup(), this.source);
        }
    }

    private final class AcquiringEndpoint
    extends AbstractAction {
        public AcquiringEndpoint(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            CreateConferenceEndpoint createEndpoint = new CreateConferenceEndpoint(MmsBridgeController.this.mediaSession);
            MmsBridgeController.this.mediaGateway.tell((Object)createEndpoint, this.source);
        }
    }

    private final class AcquiringMediaSession
    extends AbstractAction {
        public AcquiringMediaSession(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            MmsBridgeController.this.mediaGateway.tell((Object)new org.mobicents.servlet.restcomm.mgcp.CreateMediaSession(), this.source);
        }
    }

    private abstract class AbstractAction
    implements Action {
        protected final ActorRef source;

        public AbstractAction(ActorRef source) {
            this.source = source;
        }
    }
}

