/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.restcomm.mscontrol.mgcp;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.event.Logging;
import akka.event.LoggingAdapter;
import jain.protocol.ip.mgcp.message.parms.ConnectionMode;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.mobicents.servlet.restcomm.fsm.Action;
import org.mobicents.servlet.restcomm.fsm.FiniteStateMachine;
import org.mobicents.servlet.restcomm.fsm.State;
import org.mobicents.servlet.restcomm.fsm.Transition;
import org.mobicents.servlet.restcomm.mgcp.CloseLink;
import org.mobicents.servlet.restcomm.mgcp.CreateIvrEndpoint;
import org.mobicents.servlet.restcomm.mgcp.CreateLink;
import org.mobicents.servlet.restcomm.mgcp.DestroyEndpoint;
import org.mobicents.servlet.restcomm.mgcp.DestroyLink;
import org.mobicents.servlet.restcomm.mgcp.InitializeLink;
import org.mobicents.servlet.restcomm.mgcp.IvrEndpointResponse;
import org.mobicents.servlet.restcomm.mgcp.LinkStateChanged;
import org.mobicents.servlet.restcomm.mgcp.MediaGatewayResponse;
import org.mobicents.servlet.restcomm.mgcp.MediaSession;
import org.mobicents.servlet.restcomm.mgcp.OpenLink;
import org.mobicents.servlet.restcomm.mgcp.Play;
import org.mobicents.servlet.restcomm.mgcp.PlayCollect;
import org.mobicents.servlet.restcomm.mgcp.PlayRecord;
import org.mobicents.servlet.restcomm.mgcp.StopEndpoint;
import org.mobicents.servlet.restcomm.mgcp.UpdateLink;
import org.mobicents.servlet.restcomm.mscontrol.MediaGroup;
import org.mobicents.servlet.restcomm.mscontrol.messages.Collect;
import org.mobicents.servlet.restcomm.mscontrol.messages.Join;
import org.mobicents.servlet.restcomm.mscontrol.messages.MediaGroupResponse;
import org.mobicents.servlet.restcomm.mscontrol.messages.MediaGroupStateChanged;
import org.mobicents.servlet.restcomm.mscontrol.messages.MediaGroupStatus;
import org.mobicents.servlet.restcomm.mscontrol.messages.Record;
import org.mobicents.servlet.restcomm.mscontrol.messages.StartMediaGroup;
import org.mobicents.servlet.restcomm.mscontrol.messages.Stop;
import org.mobicents.servlet.restcomm.mscontrol.messages.StopMediaGroup;
import org.mobicents.servlet.restcomm.patterns.Observe;
import org.mobicents.servlet.restcomm.patterns.Observing;
import org.mobicents.servlet.restcomm.patterns.StopObserving;

public class MgcpMediaGroup
extends MediaGroup {
    private final LoggingAdapter logger = Logging.getLogger((ActorSystem)this.getContext().system(), (Object)((Object)this));
    private final State uninitialized;
    private final State active;
    private final State inactive;
    private final State acquiringIvr;
    private final State acquiringLink;
    private final State initializingLink;
    private final State openingLink;
    private final State updatingLink;
    private final State deactivating;
    private final State acquiringInternalLink;
    private final State initializingInternalLink;
    private final State openingInternalLink;
    private final State updatingInternalLink;
    private final FiniteStateMachine fsm;
    private final ActorRef gateway;
    private final ActorRef endpoint;
    private final MediaSession session;
    private ActorRef link;
    private ActorRef ivr;
    private boolean ivrInUse;
    private final List<ActorRef> observers;
    private ActorRef originator;
    private ActorRef internalLinkEndpoint;
    private ActorRef internalLink;
    private ConnectionMode internalLinkMode;

    public MgcpMediaGroup(ActorRef gateway, MediaSession session, ActorRef endpoint) {
        ActorRef source = this.self();
        this.uninitialized = new State("uninitialized", null, null);
        this.active = new State("active", (Action)new Active(source), null);
        this.inactive = new State("inactive", (Action)new Inactive(source), null);
        this.acquiringIvr = new State("acquiring ivr", (Action)new AcquiringIvr(source), null);
        this.acquiringLink = new State("acquiring link", (Action)new AcquiringLink(source), null);
        this.initializingLink = new State("initializing link", (Action)new InitializingLink(source), null);
        this.openingLink = new State("opening link", (Action)new OpeningLink(source), null);
        this.updatingLink = new State("updating link", (Action)new UpdatingLink(source), null);
        this.deactivating = new State("deactivating", (Action)new Deactivating(source), null);
        this.acquiringInternalLink = new State("acquiring internal link", (Action)new AcquiringInternalLink(source), null);
        this.initializingInternalLink = new State("initializing internal link", (Action)new InitializingInternalLink(source), null);
        this.openingInternalLink = new State("opening internal link", (Action)new OpeningInternalLink(source), null);
        this.updatingInternalLink = new State("updating internal link", (Action)new UpdatingInternalLink(source), null);
        HashSet<Transition> transitions = new HashSet<Transition>();
        transitions.add(new Transition(this.uninitialized, this.acquiringIvr));
        transitions.add(new Transition(this.acquiringIvr, this.inactive));
        transitions.add(new Transition(this.acquiringIvr, this.acquiringLink));
        transitions.add(new Transition(this.acquiringLink, this.inactive));
        transitions.add(new Transition(this.acquiringLink, this.initializingLink));
        transitions.add(new Transition(this.initializingLink, this.inactive));
        transitions.add(new Transition(this.initializingLink, this.openingLink));
        transitions.add(new Transition(this.openingLink, this.inactive));
        transitions.add(new Transition(this.openingLink, this.deactivating));
        transitions.add(new Transition(this.openingLink, this.updatingLink));
        transitions.add(new Transition(this.updatingLink, this.active));
        transitions.add(new Transition(this.updatingLink, this.inactive));
        transitions.add(new Transition(this.updatingLink, this.deactivating));
        transitions.add(new Transition(this.active, this.deactivating));
        transitions.add(new Transition(this.deactivating, this.inactive));
        transitions.add(new Transition(this.active, this.acquiringIvr));
        transitions.add(new Transition(this.active, this.acquiringInternalLink));
        transitions.add(new Transition(this.acquiringInternalLink, this.initializingInternalLink));
        transitions.add(new Transition(this.initializingInternalLink, this.openingInternalLink));
        transitions.add(new Transition(this.openingInternalLink, this.updatingInternalLink));
        transitions.add(new Transition(this.updatingInternalLink, this.active));
        this.fsm = new FiniteStateMachine(this.uninitialized, transitions);
        this.gateway = gateway;
        this.session = session;
        this.endpoint = endpoint;
        this.ivrInUse = false;
        this.observers = new ArrayList<ActorRef>();
    }

    private void collect(Object message) {
        ActorRef self = this.self();
        Collect request = (Collect)message;
        PlayCollect.Builder builder = PlayCollect.builder();
        for (URI prompt : request.prompts()) {
            builder.addPrompt(prompt);
        }
        builder.setClearDigitBuffer(true);
        builder.setDigitPattern(request.pattern());
        builder.setFirstDigitTimer((long)request.timeout());
        builder.setInterDigitTimer((long)request.timeout());
        builder.setEndInputKey(request.endInputKey());
        builder.setMaxNumberOfDigits(request.numberOfDigits());
        this.stop();
        this.originator = this.sender();
        this.ivr.tell((Object)builder.build(), self);
        this.ivrInUse = true;
    }

    private void play(Object message) {
        ActorRef self = this.self();
        org.mobicents.servlet.restcomm.mscontrol.messages.Play request = (org.mobicents.servlet.restcomm.mscontrol.messages.Play)message;
        List uris = request.uris();
        int iterations = request.iterations();
        Play play = new Play(uris, iterations);
        this.stop();
        this.originator = this.sender();
        this.ivr.tell((Object)play, self);
        this.ivrInUse = true;
    }

    private void notification(Object message) {
        IvrEndpointResponse response = (IvrEndpointResponse)message;
        ActorRef self = this.self();
        MediaGroupResponse event = null;
        event = response.succeeded() ? new MediaGroupResponse(response.get()) : new MediaGroupResponse(response.cause(), response.error());
        this.originator.tell((Object)event, self);
        this.ivrInUse = false;
    }

    private void observe(Object message) {
        ActorRef self = this.self();
        Observe request = (Observe)message;
        ActorRef observer = request.observer();
        if (observer != null) {
            this.observers.add(observer);
            observer.tell((Object)new Observing(self), self);
        }
    }

    public void onReceive(Object message) throws Exception {
        Class<?> klass = message.getClass();
        State state = this.fsm.state();
        ActorRef sender = this.sender();
        this.logger.info("********** Media Group " + this.self().path() + " Current State: \"" + state.toString());
        this.logger.info("********** Media Group " + this.self().path() + " Processing Message: \"" + klass.getName() + " sender : " + sender.getClass());
        if (Observe.class.equals(klass)) {
            this.observe(message);
        } else if (StopObserving.class.equals(klass)) {
            this.stopObserving(message);
        } else if (MediaGroupStatus.class.equals(klass)) {
            if (this.active.equals((Object)state)) {
                this.sender().tell((Object)new MediaGroupStateChanged(MediaGroupStateChanged.State.ACTIVE), this.self());
            } else {
                this.sender().tell((Object)new MediaGroupStateChanged(MediaGroupStateChanged.State.INACTIVE), this.self());
            }
        } else if (StartMediaGroup.class.equals(klass)) {
            this.logger.info("MediaGroup: " + this.self().path() + " got StartMediaGroup from: " + this.sender().path() + " endpoint: " + this.endpoint.path() + " isTerminated: " + this.endpoint.isTerminated());
            this.fsm.transition(message, this.acquiringIvr);
        } else if (Join.class.equals(klass)) {
            this.fsm.transition(message, this.acquiringInternalLink);
        } else if (MediaGatewayResponse.class.equals(klass)) {
            if (this.acquiringIvr.equals((Object)state)) {
                this.fsm.transition(message, this.acquiringLink);
            } else if (this.acquiringLink.equals((Object)state)) {
                this.fsm.transition(message, this.initializingLink);
            } else if (this.acquiringInternalLink.equals((Object)state)) {
                this.fsm.transition(message, this.initializingInternalLink);
            }
        } else if (LinkStateChanged.class.equals(klass)) {
            LinkStateChanged response = (LinkStateChanged)message;
            if (LinkStateChanged.State.CLOSED == response.state()) {
                if (this.initializingLink.equals((Object)state)) {
                    this.fsm.transition(message, this.openingLink);
                } else if (this.openingLink.equals((Object)state) || this.deactivating.equals((Object)state) || this.updatingLink.equals((Object)state)) {
                    this.fsm.transition(message, this.inactive);
                }
                if (this.initializingInternalLink.equals((Object)state)) {
                    this.fsm.transition(message, this.openingInternalLink);
                }
            } else if (LinkStateChanged.State.OPEN == response.state()) {
                if (this.openingLink.equals((Object)state)) {
                    this.fsm.transition(message, this.updatingLink);
                } else if (this.updatingLink.equals((Object)state)) {
                    this.fsm.transition(message, this.active);
                }
                if (this.openingInternalLink.equals((Object)state)) {
                    this.fsm.transition(message, this.updatingInternalLink);
                }
                if (this.updatingInternalLink.equals((Object)state)) {
                    this.fsm.transition(message, this.active);
                }
            }
        } else if (StopMediaGroup.class.equals(klass)) {
            if (this.acquiringLink.equals((Object)state) || this.initializingLink.equals((Object)state)) {
                this.fsm.transition(message, this.inactive);
            } else if (this.active.equals((Object)state) || this.openingLink.equals((Object)state) || this.updatingLink.equals((Object)state)) {
                this.fsm.transition(message, this.deactivating);
            }
        } else if (this.active.equals((Object)state)) {
            if (org.mobicents.servlet.restcomm.mscontrol.messages.Play.class.equals(klass)) {
                this.play(message);
            } else if (Collect.class.equals(klass)) {
                this.collect(message);
            } else if (Record.class.equals(klass)) {
                this.record(message);
            } else if (Stop.class.equals(klass)) {
                this.stop();
                this.sender().tell((Object)new MediaGroupResponse((Object)"stopped"), this.self());
            } else if (IvrEndpointResponse.class.equals(klass)) {
                this.notification(message);
            }
        } else if (this.ivrInUse && Stop.class.equals(klass)) {
            this.stop();
        }
    }

    private void record(Object message) {
        ActorRef self = this.self();
        Record request = (Record)message;
        PlayRecord.Builder builder = PlayRecord.builder();
        for (URI prompt : request.prompts()) {
            builder.addPrompt(prompt);
        }
        builder.setClearDigitBuffer(true);
        builder.setPreSpeechTimer((long)request.timeout());
        builder.setPostSpeechTimer((long)request.timeout());
        builder.setRecordingLength((long)request.length());
        builder.setEndInputKey(request.endInputKey());
        builder.setRecordingId(request.destination());
        this.stop();
        this.originator = this.sender();
        this.ivr.tell((Object)builder.build(), self);
        this.ivrInUse = true;
    }

    private void stop() {
        if (this.ivrInUse) {
            ActorRef self = this.self();
            this.ivr.tell((Object)new StopEndpoint(), self);
            this.ivrInUse = false;
            this.originator = null;
        }
    }

    private void stopObserving(Object message) {
        StopObserving request = (StopObserving)message;
        ActorRef observer = request.observer();
        if (observer != null) {
            this.observers.remove(observer);
        }
    }

    public void postStop() {
        if (this.internalLinkEndpoint != null) {
            this.logger.info("MediaGroup: " + this.self().path() + " at postStop, about to stop intenalLinkEndpoint: " + this.internalLinkEndpoint.path() + " sender: " + this.sender().path());
            this.gateway.tell((Object)new DestroyEndpoint(this.internalLinkEndpoint), null);
            this.getContext().stop(this.internalLinkEndpoint);
            this.internalLinkEndpoint = null;
        }
        if (this.ivr != null) {
            this.logger.info("MediaGroup :" + this.self().path() + " at postStop, about to stop ivr endpoint :" + this.ivr.path());
            this.gateway.tell((Object)new DestroyEndpoint(this.ivr), null);
            this.getContext().stop(this.ivr);
            this.ivr = null;
        }
    }

    private final class Deactivating
    extends AbstractAction {
        public Deactivating(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            if (MgcpMediaGroup.this.link != null) {
                MgcpMediaGroup.this.link.tell((Object)new CloseLink(), this.source);
            }
            if (MgcpMediaGroup.this.internalLink != null) {
                MgcpMediaGroup.this.internalLink.tell((Object)new CloseLink(), this.source);
            }
        }
    }

    private final class Inactive
    extends AbstractAction {
        public Inactive(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            if (MgcpMediaGroup.this.link != null) {
                MgcpMediaGroup.this.gateway.tell((Object)new DestroyLink(MgcpMediaGroup.this.link), this.source);
                MgcpMediaGroup.this.link = null;
            }
            if (MgcpMediaGroup.this.internalLink != null) {
                MgcpMediaGroup.this.gateway.tell((Object)new DestroyLink(MgcpMediaGroup.this.internalLink), this.source);
                MgcpMediaGroup.this.internalLink = null;
            }
            MediaGroupStateChanged event = new MediaGroupStateChanged(MediaGroupStateChanged.State.INACTIVE);
            for (ActorRef observer : MgcpMediaGroup.this.observers) {
                observer.tell((Object)event, this.source);
            }
            MgcpMediaGroup.this.getContext().stop(MgcpMediaGroup.this.self());
        }
    }

    private final class Active
    extends AbstractAction {
        public Active(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            MediaGroupStateChanged event = new MediaGroupStateChanged(MediaGroupStateChanged.State.ACTIVE);
            for (ActorRef observer : MgcpMediaGroup.this.observers) {
                observer.tell((Object)event, this.source);
            }
        }
    }

    private final class UpdatingInternalLink
    extends AbstractAction {
        public UpdatingInternalLink(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            UpdateLink update = new UpdateLink(ConnectionMode.SendRecv, UpdateLink.Type.PRIMARY);
            MgcpMediaGroup.this.internalLink.tell((Object)update, this.source);
        }
    }

    private final class OpeningInternalLink
    extends AbstractAction {
        public OpeningInternalLink(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            MgcpMediaGroup.this.internalLink.tell((Object)new OpenLink(MgcpMediaGroup.this.internalLinkMode), this.source);
        }
    }

    private final class InitializingInternalLink
    extends AbstractAction {
        public InitializingInternalLink(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            MediaGatewayResponse response = (MediaGatewayResponse)message;
            MgcpMediaGroup.this.internalLink = (ActorRef)response.get();
            MgcpMediaGroup.this.internalLink.tell((Object)new Observe(this.source), this.source);
            MgcpMediaGroup.this.internalLink.tell((Object)new InitializeLink(MgcpMediaGroup.this.internalLinkEndpoint, MgcpMediaGroup.this.ivr), this.source);
        }
    }

    private final class AcquiringInternalLink
    extends AbstractAction {
        public AcquiringInternalLink(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            Class<?> klass = message.getClass();
            if (Join.class.equals(klass)) {
                Join request = (Join)message;
                MgcpMediaGroup.this.internalLinkEndpoint = request.endpoint();
                MgcpMediaGroup.this.internalLinkMode = request.mode();
            }
            MgcpMediaGroup.this.gateway.tell((Object)new CreateLink(MgcpMediaGroup.this.session), this.source);
        }
    }

    private final class UpdatingLink
    extends AbstractAction {
        public UpdatingLink(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            UpdateLink update = new UpdateLink(ConnectionMode.SendRecv, UpdateLink.Type.PRIMARY);
            MgcpMediaGroup.this.link.tell((Object)update, this.source);
        }
    }

    private final class OpeningLink
    extends AbstractAction {
        public OpeningLink(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            MgcpMediaGroup.this.logger.info("MediaGroup :" + MgcpMediaGroup.this.self().path() + " state: " + MgcpMediaGroup.this.fsm.state().toString() + " session: " + MgcpMediaGroup.this.session.id() + " link: " + MgcpMediaGroup.this.link.path() + " will ask to open Link");
            MgcpMediaGroup.this.link.tell((Object)new OpenLink(ConnectionMode.SendRecv), this.source);
        }
    }

    private final class InitializingLink
    extends AbstractAction {
        public InitializingLink(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            MediaGatewayResponse response = (MediaGatewayResponse)message;
            MgcpMediaGroup.this.link = (ActorRef)response.get();
            if (MgcpMediaGroup.this.endpoint == null) {
                MgcpMediaGroup.this.logger.info("MediaGroup :" + MgcpMediaGroup.this.self().path() + " state: " + MgcpMediaGroup.this.fsm.state().toString() + " session: " + MgcpMediaGroup.this.session.id() + " link: " + MgcpMediaGroup.this.link.path() + " endpoint is null will have exception");
            }
            MgcpMediaGroup.this.link.tell((Object)new Observe(this.source), this.source);
            MgcpMediaGroup.this.link.tell((Object)new InitializeLink(MgcpMediaGroup.this.endpoint, MgcpMediaGroup.this.ivr), this.source);
            MgcpMediaGroup.this.logger.info("MediaGroup :" + MgcpMediaGroup.this.self().path() + " state: " + MgcpMediaGroup.this.fsm.state().toString() + " session: " + MgcpMediaGroup.this.session.id() + " link: " + MgcpMediaGroup.this.link.path() + " endpoint: " + MgcpMediaGroup.this.endpoint.path() + " initializeLink sent, endpoint isTerminated: " + MgcpMediaGroup.this.endpoint.isTerminated());
        }
    }

    private final class AcquiringLink
    extends AbstractAction {
        public AcquiringLink(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            MediaGatewayResponse response = (MediaGatewayResponse)message;
            MgcpMediaGroup.this.ivr = (ActorRef)response.get();
            MgcpMediaGroup.this.ivr.tell((Object)new Observe(this.source), this.source);
            if (MgcpMediaGroup.this.link != null && !MgcpMediaGroup.this.link.isTerminated()) {
                MgcpMediaGroup.this.logger.info("MediaGroup :" + MgcpMediaGroup.this.self().path() + " got request to create link endpoint, will stop the existing one first: " + MgcpMediaGroup.this.link.path());
                MgcpMediaGroup.this.gateway.tell((Object)new DestroyLink(MgcpMediaGroup.this.link), null);
                MgcpMediaGroup.this.getContext().stop(MgcpMediaGroup.this.link);
            }
            MgcpMediaGroup.this.logger.info("MediaGroup :" + MgcpMediaGroup.this.self().path() + " state: " + MgcpMediaGroup.this.fsm.state().toString() + " session: " + MgcpMediaGroup.this.session.id() + " ivr endpoint: " + MgcpMediaGroup.this.ivr.path() + " will ask to get Link");
            MgcpMediaGroup.this.gateway.tell((Object)new CreateLink(MgcpMediaGroup.this.session), this.source);
        }
    }

    private final class AcquiringIvr
    extends AbstractAction {
        public AcquiringIvr(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            if (MgcpMediaGroup.this.ivr != null && !MgcpMediaGroup.this.ivr.isTerminated()) {
                MgcpMediaGroup.this.logger.info("MediaGroup :" + MgcpMediaGroup.this.self().path() + " got request to create ivr endpoint, will stop the existing one first: " + MgcpMediaGroup.this.ivr.path());
                MgcpMediaGroup.this.gateway.tell((Object)new DestroyEndpoint(MgcpMediaGroup.this.ivr), null);
                MgcpMediaGroup.this.getContext().stop(MgcpMediaGroup.this.ivr);
                MgcpMediaGroup.this.ivr = null;
            }
            MgcpMediaGroup.this.logger.info("MediaGroup :" + MgcpMediaGroup.this.self().path() + " state: " + MgcpMediaGroup.this.fsm.state().toString() + " session: " + MgcpMediaGroup.this.session.id() + " will ask to get IvrEndpoint");
            MgcpMediaGroup.this.gateway.tell((Object)new CreateIvrEndpoint(MgcpMediaGroup.this.session), this.source);
        }
    }

    private abstract class AbstractAction
    implements Action {
        protected final ActorRef source;

        public AbstractAction(ActorRef source) {
            this.source = source;
        }
    }
}

