/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.lowlevel.gsm;

import org.tritonus.lowlevel.gsm.Add;

public class Lpc {
    private int[] L_ACF = new int[9];

    public void Gsm_LPC_Analysis(short[] so, short[] LARc) {
        this.Autocorrelation(so);
        this.Reflection_coefficients(LARc);
        this.Transformation_to_Log_Area_Ratios(LARc);
        this.Quantization_and_coding(LARc);
    }

    private void Autocorrelation(short[] so) throws IllegalArgumentException {
        int k;
        int i = 0;
        int sp_index = 0;
        short temp = 0;
        short smax = 0;
        int scalauto = 0;
        boolean L_temp = false;
        boolean L_temp2 = false;
        for (k = 0; k <= 159; ++k) {
            temp = Add.GSM_ADD(so[k], (short)0);
            if (temp <= smax) continue;
            smax = temp;
        }
        if (smax == 0) {
            scalauto = 0;
        } else {
            if (smax <= 0) {
                throw new IllegalArgumentException("Autocorrelation: smax = " + smax + " should be > 0.");
            }
            scalauto = (short)(4 - Add.gsm_norm(smax << 16));
        }
        if (scalauto > 0) {
            if (scalauto > 4) {
                throw new IllegalArgumentException("Autocorrelation: scalauto = " + scalauto + " should be <= 4.");
            }
            switch (scalauto) {
                case 1: {
                    for (k = 0; k <= 159; ++k) {
                        so[k] = Add.GSM_MULT_R(so[k], (short)16384);
                    }
                    break;
                }
                case 2: {
                    for (k = 0; k <= 159; ++k) {
                        so[k] = Add.GSM_MULT_R(so[k], (short)8192);
                    }
                    break;
                }
                case 3: {
                    for (k = 0; k <= 159; ++k) {
                        so[k] = Add.GSM_MULT_R(so[k], (short)4096);
                    }
                    break;
                }
                case 4: {
                    for (k = 0; k <= 159; ++k) {
                        so[k] = Add.GSM_MULT_R(so[k], (short)2048);
                    }
                    break;
                }
            }
        }
        short[] sp = so;
        short sl = sp[sp_index];
        int[] temp_arr = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0};
        System.arraycopy(temp_arr, 0, this.L_ACF, 0, this.L_ACF.length);
        this.L_ACF[0] = this.L_ACF[0] + sl * sp[sp_index - 0];
        sl = sp[++sp_index];
        this.L_ACF[0] = this.L_ACF[0] + sl * sp[sp_index - 0];
        this.L_ACF[1] = this.L_ACF[1] + sl * sp[sp_index - 1];
        sl = sp[++sp_index];
        this.L_ACF[0] = this.L_ACF[0] + sl * sp[sp_index - 0];
        this.L_ACF[1] = this.L_ACF[1] + sl * sp[sp_index - 1];
        this.L_ACF[2] = this.L_ACF[2] + sl * sp[sp_index - 2];
        sl = sp[++sp_index];
        this.L_ACF[0] = this.L_ACF[0] + sl * sp[sp_index - 0];
        this.L_ACF[1] = this.L_ACF[1] + sl * sp[sp_index - 1];
        this.L_ACF[2] = this.L_ACF[2] + sl * sp[sp_index - 2];
        this.L_ACF[3] = this.L_ACF[3] + sl * sp[sp_index - 3];
        sl = sp[++sp_index];
        this.L_ACF[0] = this.L_ACF[0] + sl * sp[sp_index - 0];
        this.L_ACF[1] = this.L_ACF[1] + sl * sp[sp_index - 1];
        this.L_ACF[2] = this.L_ACF[2] + sl * sp[sp_index - 2];
        this.L_ACF[3] = this.L_ACF[3] + sl * sp[sp_index - 3];
        this.L_ACF[4] = this.L_ACF[4] + sl * sp[sp_index - 4];
        sl = sp[++sp_index];
        this.L_ACF[0] = this.L_ACF[0] + sl * sp[sp_index - 0];
        this.L_ACF[1] = this.L_ACF[1] + sl * sp[sp_index - 1];
        this.L_ACF[2] = this.L_ACF[2] + sl * sp[sp_index - 2];
        this.L_ACF[3] = this.L_ACF[3] + sl * sp[sp_index - 3];
        this.L_ACF[4] = this.L_ACF[4] + sl * sp[sp_index - 4];
        this.L_ACF[5] = this.L_ACF[5] + sl * sp[sp_index - 5];
        sl = sp[++sp_index];
        this.L_ACF[0] = this.L_ACF[0] + sl * sp[sp_index - 0];
        this.L_ACF[1] = this.L_ACF[1] + sl * sp[sp_index - 1];
        this.L_ACF[2] = this.L_ACF[2] + sl * sp[sp_index - 2];
        this.L_ACF[3] = this.L_ACF[3] + sl * sp[sp_index - 3];
        this.L_ACF[4] = this.L_ACF[4] + sl * sp[sp_index - 4];
        this.L_ACF[5] = this.L_ACF[5] + sl * sp[sp_index - 5];
        this.L_ACF[6] = this.L_ACF[6] + sl * sp[sp_index - 6];
        sl = sp[++sp_index];
        this.L_ACF[0] = this.L_ACF[0] + sl * sp[sp_index - 0];
        this.L_ACF[1] = this.L_ACF[1] + sl * sp[sp_index - 1];
        this.L_ACF[2] = this.L_ACF[2] + sl * sp[sp_index - 2];
        this.L_ACF[3] = this.L_ACF[3] + sl * sp[sp_index - 3];
        this.L_ACF[4] = this.L_ACF[4] + sl * sp[sp_index - 4];
        this.L_ACF[5] = this.L_ACF[5] + sl * sp[sp_index - 5];
        this.L_ACF[6] = this.L_ACF[6] + sl * sp[sp_index - 6];
        this.L_ACF[7] = this.L_ACF[7] + sl * sp[sp_index - 7];
        sl = sp[++sp_index];
        for (i = sp_index; i < 160; ++i) {
            sl = sp[i];
            this.L_ACF[0] = this.L_ACF[0] + sl * sp[i - 0];
            this.L_ACF[1] = this.L_ACF[1] + sl * sp[i - 1];
            this.L_ACF[2] = this.L_ACF[2] + sl * sp[i - 2];
            this.L_ACF[3] = this.L_ACF[3] + sl * sp[i - 3];
            this.L_ACF[4] = this.L_ACF[4] + sl * sp[i - 4];
            this.L_ACF[5] = this.L_ACF[5] + sl * sp[i - 5];
            this.L_ACF[6] = this.L_ACF[6] + sl * sp[i - 6];
            this.L_ACF[7] = this.L_ACF[7] + sl * sp[i - 7];
            this.L_ACF[8] = this.L_ACF[8] + sl * sp[i - 8];
        }
        int k2 = 0;
        while (k2 < 9) {
            int n = k2++;
            this.L_ACF[n] = this.L_ACF[n] << 1;
        }
        if (scalauto > 0) {
            if (scalauto > 4) {
                throw new IllegalArgumentException("Autocorrelation: scalauto = " + scalauto + " should be <= 4.");
            }
            k2 = 0;
            while (k2 < 160) {
                int n = k2++;
                so[n] = (short)(so[n] << scalauto);
            }
        }
    }

    private void Reflection_coefficients(short[] r) throws IllegalArgumentException {
        short temp = 0;
        boolean ltmp = false;
        int r_index = 0;
        short[] ACF = new short[9];
        short[] P = new short[9];
        short[] K = new short[9];
        if (this.L_ACF[0] == 0) {
            for (int i = 0; i < 8; ++i) {
                r[i] = 0;
            }
            return;
        }
        if (this.L_ACF[0] == 0) {
            throw new IllegalArgumentException("Reflection_coefficients: L_ACF[0] = " + this.L_ACF[0] + " should not = 0.");
        }
        temp = Add.gsm_norm(this.L_ACF[0]);
        if (temp < 0 || temp >= 32) {
            throw new IllegalArgumentException("Reflection_coefficients: temp = " + temp + " should be >= 0 and < 32.");
        }
        for (int i = 0; i <= 8; ++i) {
            ACF[i] = Add.SASR(this.L_ACF[i] << temp, 16);
        }
        System.arraycopy(ACF, 0, K, 0, 7);
        System.arraycopy(ACF, 0, P, 0, 8);
        int n = 1;
        while (n <= 8) {
            temp = P[1];
            if (P[0] < (temp = Add.GSM_ABS(temp))) {
                for (int i = n; i < 8; ++i) {
                    r[i] = 0;
                }
                return;
            }
            r[r_index] = Add.gsm_div(temp, P[0]);
            if (r[r_index] < 0) {
                throw new IllegalArgumentException("Reflection_coefficients: r[" + r_index + "] = " + r[r_index] + " should be >= 0");
            }
            if (P[1] > 0) {
                r[r_index] = -r[r_index];
            }
            if (r[r_index] == Short.MIN_VALUE) {
                throw new IllegalArgumentException("Reflection_coefficients: r[" + r_index + "] = " + r[r_index] + " should not be " + Short.MIN_VALUE);
            }
            if (n == 8) {
                return;
            }
            temp = Add.GSM_MULT_R(P[1], r[r_index]);
            P[0] = Add.GSM_ADD(P[0], temp);
            for (int m = 1; m <= 8 - n; ++m) {
                temp = Add.GSM_MULT_R(K[m], r[r_index]);
                P[m] = Add.GSM_ADD(P[m + 1], temp);
                temp = Add.GSM_MULT_R(P[m + 1], r[r_index]);
                K[m] = Add.GSM_ADD(K[m], temp);
            }
            ++n;
            ++r_index;
        }
    }

    private void Transformation_to_Log_Area_Ratios(short[] r) throws IllegalArgumentException {
        for (int i = 0; i < 8; ++i) {
            short temp = r[i];
            if ((temp = Add.GSM_ABS(temp)) < 0) {
                throw new IllegalArgumentException("Transformation_to_Log_Area_Ratios: temp = " + temp + " should be >= 0 ");
            }
            if (temp < 22118) {
                temp = (short)(temp >> 1);
            } else if (temp < 31130) {
                if (temp < 11059) {
                    throw new IllegalArgumentException("Transformation_to_Log_Area_Ratios: temp = " + temp + " should be >= 11059 ");
                }
                temp = (short)(temp - 11059);
            } else {
                if (temp < 26112) {
                    throw new IllegalArgumentException("Transformation_to_Log_Area_Ratios: temp = " + temp + " should be >= 26112 ");
                }
                temp = (short)(temp - 26112);
                temp = (short)(temp << 2);
            }
            r[i] = r[i] < 0 ? -temp : temp;
            if (r[i] != Short.MIN_VALUE) continue;
            throw new IllegalArgumentException("Transformation_to_Log_Area_Ratios: r[" + i + "] = " + r[i] + " should not be = " + Short.MIN_VALUE);
        }
    }

    private void Quantization_and_coding(short[] LAR) {
        int index = 0;
        this.STEP2(20480, 0, 31, -32, LAR, index++);
        this.STEP2(20480, 0, 31, -32, LAR, index++);
        this.STEP2(20480, 2048, 15, -16, LAR, index++);
        this.STEP2(20480, -2560, 15, -16, LAR, index++);
        this.STEP2(13964, 94, 7, -8, LAR, index++);
        this.STEP2(15360, -1792, 7, -8, LAR, index++);
        this.STEP2(8534, -341, 3, -4, LAR, index++);
        this.STEP2(9036, -1144, 3, -4, LAR, index++);
    }

    private void STEP2(int A, int B, int MAC, int MIC, short[] LAR, int index) {
        short temp = 0;
        temp = Add.GSM_MULT((short)A, LAR[index]);
        temp = Add.GSM_ADD(temp, (short)B);
        temp = Add.GSM_ADD(temp, (short)256);
        LAR[index] = (short)((temp = Add.SASR(temp, 9)) > MAC ? MAC - MIC : (temp < MIC ? 0 : temp - MIC));
    }
}

