/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.moduleservice;

import java.util.concurrent.CountDownLatch;
import org.jboss.as.server.Bootstrap;
import org.jboss.as.server.ServerLogger;
import org.jboss.as.server.ServerMessages;
import org.jboss.as.server.Services;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.jboss.modules.ModuleSpec;
import org.jboss.msc.service.AbstractServiceListener;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;

public class ServiceModuleLoader
extends ModuleLoader
implements Service<ServiceModuleLoader> {
    private static final ServerLogger log = ServerLogger.MODULE_SERVICE_LOGGER;
    public static final ServiceName MODULE_SPEC_SERVICE_PREFIX = ServiceName.JBOSS.append(new String[]{"module", "spec", "service"});
    public static final ServiceName MODULE_SERVICE_PREFIX = ServiceName.JBOSS.append(new String[]{"module", "service"});
    public static final String MODULE_PREFIX = "deployment.";
    private final ModuleLoader mainModuleLoader;
    private volatile ServiceContainer serviceContainer;

    public ServiceModuleLoader(ModuleLoader mainModuleLoader) {
        this.mainModuleLoader = mainModuleLoader;
    }

    protected Module preloadModule(ModuleIdentifier identifier) throws ModuleLoadException {
        if (identifier.getName().startsWith(MODULE_PREFIX)) {
            return super.preloadModule(identifier);
        }
        return ServiceModuleLoader.preloadModule((ModuleIdentifier)identifier, (ModuleLoader)this.mainModuleLoader);
    }

    public ModuleSpec findModule(ModuleIdentifier identifier) throws ModuleLoadException {
        ServiceController controller = this.serviceContainer.getService(ServiceModuleLoader.moduleSpecServiceName(identifier));
        if (controller == null) {
            ServerLogger.MODULE_SERVICE_LOGGER.debugf("Could not load module '%s' as corresponding module spec service '%s' was not found", identifier, identifier);
            return null;
        }
        ModuleSpecLoadListener listener = new ModuleSpecLoadListener(identifier);
        controller.addListener((ServiceListener)listener);
        return listener.getModuleSpec();
    }

    public String toString() {
        return "Service Module Loader";
    }

    public synchronized void start(StartContext context) throws StartException {
        if (this.serviceContainer != null) {
            throw ServerMessages.MESSAGES.serviceModuleLoaderAlreadyStarted();
        }
        this.serviceContainer = context.getController().getServiceContainer();
    }

    public synchronized void stop(StopContext context) {
        if (this.serviceContainer == null) {
            throw ServerMessages.MESSAGES.serviceModuleLoaderAlreadyStopped();
        }
        this.serviceContainer = null;
    }

    public ServiceModuleLoader getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    public void relinkModule(Module module) throws ModuleLoadException {
        this.relink(module);
    }

    public static void addService(ServiceTarget serviceTarget, Bootstrap.Configuration configuration) {
        ServiceModuleLoader service = new ServiceModuleLoader(configuration.getModuleLoader());
        ServiceBuilder serviceBuilder = serviceTarget.addService(Services.JBOSS_SERVICE_MODULE_LOADER, (Service)service);
        serviceBuilder.install();
    }

    public static ServiceName moduleSpecServiceName(ModuleIdentifier identifier) {
        if (!identifier.getName().startsWith(MODULE_PREFIX)) {
            ServerMessages.MESSAGES.missingModulePrefix(identifier, MODULE_PREFIX);
        }
        return MODULE_SPEC_SERVICE_PREFIX.append(new String[]{identifier.getName()}).append(new String[]{identifier.getSlot()});
    }

    public static ServiceName moduleServiceName(ModuleIdentifier identifier) {
        if (!identifier.getName().startsWith(MODULE_PREFIX)) {
            ServerMessages.MESSAGES.missingModulePrefix(identifier, MODULE_PREFIX);
        }
        return MODULE_SERVICE_PREFIX.append(new String[]{identifier.getName()}).append(new String[]{identifier.getSlot()});
    }

    private class ModuleSpecLoadListener
    extends AbstractServiceListener<ModuleSpec> {
        private final CountDownLatch latch = new CountDownLatch(1);
        private volatile StartException startException;
        private volatile ModuleSpec moduleSpec;

        private ModuleSpecLoadListener(ModuleIdentifier identifier) {
        }

        public void listenerAdded(ServiceController<? extends ModuleSpec> controller) {
            log.tracef("listenerAdded: %s", controller);
            ServiceController.State state = controller.getState();
            if (state == ServiceController.State.UP || state == ServiceController.State.START_FAILED) {
                this.done(controller, controller.getStartException());
            }
        }

        public void transition(ServiceController<? extends ModuleSpec> controller, ServiceController.Transition transition) {
            switch (transition) {
                case STARTING_to_UP: {
                    log.tracef("serviceStarted: %s", controller);
                    this.done(controller, null);
                    break;
                }
                case STARTING_to_START_FAILED: {
                    log.tracef((Throwable)controller.getStartException(), "serviceFailed: %s", controller);
                    this.done(controller, controller.getStartException());
                    break;
                }
                case STOP_REQUESTED_to_STOPPING: {
                    log.tracef("serviceStopping: %s", controller);
                    ModuleSpec moduleSpec = this.moduleSpec;
                    ModuleIdentifier identifier = moduleSpec.getModuleIdentifier();
                    Module module = ServiceModuleLoader.this.findLoadedModuleLocal(identifier);
                    if (module != null) {
                        ServiceModuleLoader.this.unloadModuleLocal(module);
                    }
                    controller.removeListener((ServiceListener)this);
                    break;
                }
            }
        }

        private void done(ServiceController<? extends ModuleSpec> controller, StartException reason) {
            this.startException = reason;
            if (this.startException == null) {
                this.moduleSpec = (ModuleSpec)controller.getValue();
            }
            this.latch.countDown();
        }

        public ModuleSpec getModuleSpec() throws ModuleLoadException {
            if (this.startException != null) {
                throw new ModuleLoadException(this.startException.getCause());
            }
            return this.moduleSpec;
        }
    }
}

