/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.restcomm.provisioning.number.bandwidth;

import com.google.i18n.phonenumbers.PhoneNumberUtil;
import com.google.i18n.phonenumbers.Phonenumber;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.servlet.sip.SipURI;
import javax.xml.stream.XMLInputFactory;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;
import org.mobicents.servlet.restcomm.provisioning.number.api.ContainerConfiguration;
import org.mobicents.servlet.restcomm.provisioning.number.api.PhoneNumber;
import org.mobicents.servlet.restcomm.provisioning.number.api.PhoneNumberParameters;
import org.mobicents.servlet.restcomm.provisioning.number.api.PhoneNumberProvisioningManager;
import org.mobicents.servlet.restcomm.provisioning.number.api.PhoneNumberSearchFilters;
import org.mobicents.servlet.restcomm.provisioning.number.api.PhoneNumberType;
import org.mobicents.servlet.restcomm.provisioning.number.api.ProvisionProvider;
import org.mobicents.servlet.restcomm.provisioning.number.bandwidth.DisconnectTelephoneNumberOrder;
import org.mobicents.servlet.restcomm.provisioning.number.bandwidth.DisconnectTelephoneNumberOrderResponse;
import org.mobicents.servlet.restcomm.provisioning.number.bandwidth.DisconnectTelephoneNumberOrderType;
import org.mobicents.servlet.restcomm.provisioning.number.bandwidth.ExistingTelephoneNumberOrderType;
import org.mobicents.servlet.restcomm.provisioning.number.bandwidth.Order;
import org.mobicents.servlet.restcomm.provisioning.number.bandwidth.OrderResponse;
import org.mobicents.servlet.restcomm.provisioning.number.bandwidth.SearchResult;
import org.mobicents.servlet.restcomm.provisioning.number.bandwidth.TelephoneNumberDetail;
import org.mobicents.servlet.restcomm.provisioning.number.bandwidth.utils.XmlUtils;

public class BandwidthNumberProvisioningManager
implements PhoneNumberProvisioningManager {
    private static final Logger logger = Logger.getLogger(BandwidthNumberProvisioningManager.class);
    protected String uri;
    protected String username;
    protected String password;
    protected String accountId;
    protected String siteId;
    protected Configuration activeConfiguration;
    protected ContainerConfiguration containerConfiguration;
    protected boolean telestaxProxyEnabled;
    private DefaultHttpClient httpClient;
    private XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();

    public void init(Configuration phoneNumberProvisioningConfiguration, Configuration telestaxProxyConfiguration, ContainerConfiguration containerConfiguration) {
        this.containerConfiguration = containerConfiguration;
        this.telestaxProxyEnabled = telestaxProxyConfiguration.getBoolean("enabled", false);
        if (this.telestaxProxyEnabled) {
            this.uri = telestaxProxyConfiguration.getString("uri");
            this.username = telestaxProxyConfiguration.getString("login");
            this.password = telestaxProxyConfiguration.getString("password");
            this.accountId = telestaxProxyConfiguration.getString("endpoint");
            this.siteId = telestaxProxyConfiguration.getString("siteId");
            this.activeConfiguration = telestaxProxyConfiguration;
        } else {
            Configuration bandwidthConfiguration = phoneNumberProvisioningConfiguration.subset("bandwidth");
            this.uri = bandwidthConfiguration.getString("uri");
            this.username = bandwidthConfiguration.getString("username");
            this.password = bandwidthConfiguration.getString("password");
            this.accountId = bandwidthConfiguration.getString("accountId");
            this.siteId = bandwidthConfiguration.getString("siteId");
            this.activeConfiguration = bandwidthConfiguration;
        }
        this.httpClient = new DefaultHttpClient();
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(this.username, this.password);
        this.httpClient.getCredentialsProvider().setCredentials(AuthScope.ANY, (Credentials)credentials);
    }

    public List<String> getAvailableCountries() {
        ArrayList<String> countries = new ArrayList<String>();
        countries.add("US");
        return countries;
    }

    public boolean buyNumber(PhoneNumber phoneNumberObject, PhoneNumberParameters parameters) {
        String phoneNumber = phoneNumberObject.getPhoneNumber();
        boolean isSucceeded = false;
        phoneNumber = phoneNumber.substring(2);
        Order order = new Order();
        order.setSiteId(this.siteId);
        order.setName("Order For Number: " + phoneNumber);
        ExistingTelephoneNumberOrderType existingTelephoneNumberOrderType = new ExistingTelephoneNumberOrderType();
        existingTelephoneNumberOrderType.getTelephoneNumberList().add(phoneNumber);
        order.setExistingTelephoneNumberOrderType(existingTelephoneNumberOrderType);
        try {
            OrderResponse response;
            HttpPost post = new HttpPost(this.buildOrdersUri());
            String xml = XmlUtils.toXml(order);
            StringEntity entity = new StringEntity(xml, ContentType.APPLICATION_XML);
            post.setEntity((HttpEntity)entity);
            if (this.telestaxProxyEnabled) {
                this.addTelestaxProxyHeaders((HttpRequest)post, ProvisionProvider.REQUEST_TYPE.ASSIGNDID.name());
            }
            if ((response = (OrderResponse)XmlUtils.fromXml(this.executeRequest((HttpUriRequest)post), OrderResponse.class)).getOrder().getExistingTelephoneNumberOrderType().getTelephoneNumberList().get(0).equals(phoneNumber)) {
                isSucceeded = true;
            }
        }
        catch (Exception e) {
            logger.error((Object)("Error creating order: " + e.getMessage()));
            isSucceeded = false;
        }
        return isSucceeded;
    }

    public boolean cancelNumber(PhoneNumber phoneNumberObj) {
        String phoneNumber = phoneNumberObj.getPhoneNumber();
        boolean isSucceeded = false;
        phoneNumber = phoneNumber.substring(2);
        DisconnectTelephoneNumberOrder order = new DisconnectTelephoneNumberOrder();
        order.setName("Disconnect Order For Number: " + phoneNumber);
        DisconnectTelephoneNumberOrderType disconnectTelephoneNumberOrderType = new DisconnectTelephoneNumberOrderType();
        disconnectTelephoneNumberOrderType.getTelephoneNumberList().add(phoneNumber);
        order.setDisconnectTelephoneNumberOrderType(disconnectTelephoneNumberOrderType);
        try {
            DisconnectTelephoneNumberOrderResponse response;
            HttpPost post = new HttpPost(this.buildDisconnectsUri());
            StringEntity entity = new StringEntity(XmlUtils.toXml(order), ContentType.APPLICATION_XML);
            post.setEntity((HttpEntity)entity);
            if (this.telestaxProxyEnabled) {
                this.addTelestaxProxyHeaders((HttpRequest)post, ProvisionProvider.REQUEST_TYPE.RELEASEDID.name());
            }
            if ((response = (DisconnectTelephoneNumberOrderResponse)XmlUtils.fromXml(this.executeRequest((HttpUriRequest)post), DisconnectTelephoneNumberOrderResponse.class)).getErrorList().size() == 0 && response.getorderRequest().getDisconnectTelephoneNumberOrderType().getTelephoneNumberList().get(0).equals(phoneNumber)) {
                isSucceeded = true;
            }
        }
        catch (Exception e) {
            logger.error((Object)String.format("Error disconnecting number: %s : %s ", phoneNumber, e.getMessage()));
            isSucceeded = false;
        }
        return isSucceeded;
    }

    public List<PhoneNumber> searchForNumbers(String country, PhoneNumberSearchFilters listFilters) {
        List<PhoneNumber> availableNumbers = new ArrayList<PhoneNumber>();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("searchPattern: " + listFilters.getFilterPattern()));
        }
        try {
            String uri = this.buildSearchUri(listFilters);
            HttpGet httpGet = new HttpGet(uri);
            if (this.telestaxProxyEnabled) {
                this.addTelestaxProxyHeaders((HttpRequest)httpGet, ProvisionProvider.REQUEST_TYPE.GETDIDS.name());
            }
            String response = this.executeRequest((HttpUriRequest)httpGet);
            availableNumbers = this.toPhoneNumbers((SearchResult)XmlUtils.fromXml(response, SearchResult.class));
            return availableNumbers;
        }
        catch (Exception e) {
            logger.error((Object)("Could not execute search request: " + this.uri), (Throwable)e);
            return availableNumbers;
        }
    }

    public boolean updateNumber(PhoneNumber phoneNumberObj, PhoneNumberParameters parameters) {
        return true;
    }

    private String buildDisconnectsUri() throws URISyntaxException {
        URIBuilder builder = new URIBuilder(this.uri);
        builder.setPath("/v1.0/accounts/" + this.accountId + "/disconnects");
        return builder.build().toString();
    }

    private String buildOrdersUri() throws URISyntaxException {
        URIBuilder builder = new URIBuilder(this.uri);
        builder.setPath("/v1.0/accounts/" + this.accountId + "/orders");
        return builder.build().toString();
    }

    private String buildSearchUri(PhoneNumberSearchFilters filters) throws URISyntaxException {
        Pattern filterPattern = filters.getFilterPattern();
        URIBuilder builder = new URIBuilder(this.uri);
        builder.setPath("/v1.0/accounts/" + this.accountId + "/availableNumbers");
        if (filters.getPhoneNumberTypeSearch().equals((Object)PhoneNumberType.Local)) {
            if (!StringUtils.isEmpty((String)filters.getAreaCode())) {
                builder.addParameter("areaCode", filters.getAreaCode());
            }
            if (!StringUtils.isEmpty((String)filters.getInLata())) {
                builder.addParameter("lata", filters.getInLata());
            }
            if (!StringUtils.isEmpty((String)filters.getInPostalCode())) {
                builder.addParameter("zip", filters.getInPostalCode());
            }
            if (!StringUtils.isEmpty((String)filters.getInRateCenter())) {
                builder.addParameter("rateCenter", filters.getInRateCenter());
                builder.addParameter("state", filters.getInRegion());
            }
            builder.addParameter("enableTNDetail", String.valueOf(true));
        } else if (filters.getPhoneNumberTypeSearch().equals((Object)PhoneNumberType.TollFree)) {
            if (filterPattern == null || StringUtils.isEmpty((String)filterPattern.toString())) {
                builder.addParameter("tollFreeWildCardPattern", "8**");
            } else if (filterPattern.toString().contains("*")) {
                builder.addParameter("tollFreeWildCardPattern", filterPattern.toString());
            } else {
                builder.addParameter("tollFreeVanity", filterPattern.toString());
            }
        } else {
            logger.error((Object)("Phone Number Type: " + filters.getPhoneNumberTypeSearch().name() + " is not supported"));
        }
        builder.addParameter("quantity", String.valueOf(filters.getRangeSize() == -1 ? 5 : filters.getRangeSize()));
        logger.debug((Object)("building uri: " + builder.build().toString()));
        return builder.build().toString();
    }

    protected String executeRequest(HttpUriRequest request) throws IOException {
        String response = "";
        try {
            HttpResponse httpResponse = this.httpClient.execute(request);
            response = httpResponse.getEntity() != null ? EntityUtils.toString((HttpEntity)httpResponse.getEntity()) : "";
        }
        catch (ClientProtocolException cpe) {
            logger.error((Object)("Error in execute request: " + cpe.getMessage()));
            throw new IOException(cpe);
        }
        return response;
    }

    private List<PhoneNumber> toPhoneNumbers(SearchResult searchResult) {
        ArrayList<PhoneNumber> numbers;
        block3: {
            block2: {
                numbers = new ArrayList<PhoneNumber>();
                if (searchResult.getTelephoneNumberDetailList().size() <= 0) break block2;
                for (TelephoneNumberDetail detail : searchResult.getTelephoneNumberDetailList()) {
                    String name = this.getFriendlyName(detail.getFullNumber(), "US");
                    PhoneNumber phoneNumber = new PhoneNumber(name, name, Integer.valueOf(Integer.parseInt(detail.getLATA())), detail.getRateCenter(), null, null, detail.getState(), null, "US", Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false));
                    numbers.add(phoneNumber);
                }
                break block3;
            }
            if (searchResult.getTelephoneNumberList().size() <= 0) break block3;
            for (String number : searchResult.getTelephoneNumberList()) {
                String name = this.getFriendlyName(number, "US");
                PhoneNumber phoneNumber = new PhoneNumber(name, name, null, null, null, null, null, null, "US", Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false));
                numbers.add(phoneNumber);
            }
        }
        return numbers;
    }

    private String getFriendlyName(String number, String countryCode) {
        try {
            PhoneNumberUtil phoneNumberUtil = PhoneNumberUtil.getInstance();
            Phonenumber.PhoneNumber phoneNumber = phoneNumberUtil.parse(number, countryCode);
            String friendlyName = phoneNumberUtil.format(phoneNumber, PhoneNumberUtil.PhoneNumberFormat.E164);
            return friendlyName;
        }
        catch (Exception ignored) {
            return number;
        }
    }

    private void addTelestaxProxyHeaders(HttpRequest httpRequest, String requestType) {
        httpRequest.addHeader("TelestaxProxy", "true");
        httpRequest.addHeader("Provider", ProvisionProvider.bandiwidthClass);
        httpRequest.addHeader("RequestType", requestType);
        httpRequest.addHeader("SiteId", this.siteId);
        List uris = this.containerConfiguration.getOutboundInterfaces();
        for (SipURI uri : uris) {
            httpRequest.addHeader("OutboundIntf", uri.getHost() + ":" + uri.getPort() + ":" + uri.getTransportParam());
        }
    }
}

