/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.metadata;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.jboss.osgi.metadata.ManifestBuilder;
import org.jboss.osgi.metadata.MetadataMessages;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;

public final class OSGiManifestBuilder
implements Asset {
    private final ManifestBuilder delegate = ManifestBuilder.newInstance();
    private final Set<String> importPackages = new LinkedHashSet<String>();
    private final Set<String> exportPackages = new LinkedHashSet<String>();
    private final Set<String> dynamicImportPackages = new LinkedHashSet<String>();
    private final Set<String> requiredBundles = new LinkedHashSet<String>();
    private final Set<String> requiredEnvironments = new LinkedHashSet<String>();
    private final Set<String> providedCapabilities = new LinkedHashSet<String>();
    private final Set<String> requiredCapabilities = new LinkedHashSet<String>();
    private Manifest manifest;

    public static OSGiManifestBuilder newInstance() {
        return new OSGiManifestBuilder();
    }

    private OSGiManifestBuilder() {
    }

    public OSGiManifestBuilder addBundleManifestVersion(int version) {
        this.delegate.append("Bundle-ManifestVersion: " + version);
        return this;
    }

    public OSGiManifestBuilder addBundleSymbolicName(String symbolicName) {
        this.delegate.append("Bundle-SymbolicName: " + symbolicName);
        return this;
    }

    public OSGiManifestBuilder addBundleName(String name) {
        this.delegate.append("Bundle-Name: " + name);
        return this;
    }

    public OSGiManifestBuilder addBundleVersion(Version version) {
        this.delegate.append("Bundle-Version: " + version);
        return this;
    }

    public OSGiManifestBuilder addBundleVersion(String version) {
        return this.addBundleVersion(Version.parseVersion((String)version));
    }

    public OSGiManifestBuilder addBundleActivator(Class<?> bundleActivator) {
        return this.addBundleActivator(bundleActivator.getName());
    }

    public OSGiManifestBuilder addBundleActivator(String bundleActivator) {
        this.delegate.append("Bundle-Activator: " + bundleActivator);
        return this;
    }

    public OSGiManifestBuilder addBundleActivationPolicy(String activationPolicy) {
        this.delegate.append("Bundle-ActivationPolicy: " + activationPolicy);
        return this;
    }

    public OSGiManifestBuilder addBundleClasspath(String classpath) {
        this.delegate.append("Bundle-ClassPath: " + classpath);
        return this;
    }

    public OSGiManifestBuilder addFragmentHost(String fragmentHost) {
        this.delegate.append("Fragment-Host: " + fragmentHost);
        return this;
    }

    public OSGiManifestBuilder addManifestHeader(String key, String value) {
        this.delegate.addManifestHeader(key, value);
        return this;
    }

    public OSGiManifestBuilder addRequireBundle(String requiredBundle) {
        this.requiredBundles.add(requiredBundle);
        return this;
    }

    public OSGiManifestBuilder addRequireExecutionEnvironment(String ... environments) {
        for (String aux : environments) {
            this.requiredEnvironments.add(aux);
        }
        return this;
    }

    public OSGiManifestBuilder addImportPackages(Class<?> ... packages) {
        for (Class<?> aux : packages) {
            this.importPackages.add(aux.getPackage().getName());
        }
        return this;
    }

    public OSGiManifestBuilder addImportPackages(String ... packages) {
        for (String aux : packages) {
            this.importPackages.add(aux);
        }
        return this;
    }

    public OSGiManifestBuilder addDynamicImportPackages(String ... packages) {
        for (String aux : packages) {
            this.dynamicImportPackages.add(aux);
        }
        return this;
    }

    public OSGiManifestBuilder addExportPackages(Class<?> ... packages) {
        for (Class<?> aux : packages) {
            this.exportPackages.add(aux.getPackage().getName());
        }
        return this;
    }

    public OSGiManifestBuilder addExportPackages(String ... packages) {
        for (String aux : packages) {
            this.exportPackages.add(aux);
        }
        return this;
    }

    public OSGiManifestBuilder addProvidedCapabilities(String ... capabilities) {
        for (String aux : capabilities) {
            this.providedCapabilities.add(aux);
        }
        return this;
    }

    public OSGiManifestBuilder addRequiredCapabilities(String ... capabilities) {
        for (String aux : capabilities) {
            this.requiredCapabilities.add(aux);
        }
        return this;
    }

    public Manifest getManifest() {
        if (this.manifest == null) {
            Iterator<String> iterator;
            StringBuffer buffer;
            if (this.requiredBundles.size() > 0) {
                buffer = new StringBuffer();
                buffer.append("Require-Bundle: ");
                iterator = this.requiredBundles.iterator();
                buffer.append(iterator.next());
                while (iterator.hasNext()) {
                    buffer.append("," + iterator.next());
                }
                this.delegate.append(buffer.toString());
            }
            if (this.requiredEnvironments.size() > 0) {
                buffer = new StringBuffer();
                buffer.append("Bundle-RequiredExecutionEnvironment: ");
                iterator = this.requiredEnvironments.iterator();
                buffer.append(iterator.next());
                while (iterator.hasNext()) {
                    buffer.append("," + iterator.next());
                }
                this.delegate.append(buffer.toString());
            }
            if (this.exportPackages.size() > 0) {
                buffer = new StringBuffer();
                buffer.append("Export-Package: ");
                iterator = this.exportPackages.iterator();
                buffer.append(iterator.next());
                while (iterator.hasNext()) {
                    buffer.append("," + iterator.next());
                }
                this.delegate.append(buffer.toString());
            }
            if (this.importPackages.size() > 0) {
                buffer = new StringBuffer();
                buffer.append("Import-Package: ");
                iterator = this.importPackages.iterator();
                buffer.append(iterator.next());
                while (iterator.hasNext()) {
                    buffer.append("," + iterator.next());
                }
                this.delegate.append(buffer.toString());
            }
            if (this.dynamicImportPackages.size() > 0) {
                buffer = new StringBuffer();
                buffer.append("DynamicImport-Package: ");
                iterator = this.dynamicImportPackages.iterator();
                buffer.append(iterator.next());
                while (iterator.hasNext()) {
                    buffer.append("," + iterator.next());
                }
                this.delegate.append(buffer.toString());
            }
            if (this.providedCapabilities.size() > 0) {
                buffer = new StringBuffer();
                buffer.append("Provide-Capability: ");
                iterator = this.providedCapabilities.iterator();
                buffer.append(iterator.next());
                while (iterator.hasNext()) {
                    buffer.append("," + iterator.next());
                }
                this.delegate.append(buffer.toString());
            }
            if (this.requiredCapabilities.size() > 0) {
                buffer = new StringBuffer();
                buffer.append("Require-Capability: ");
                iterator = this.requiredCapabilities.iterator();
                buffer.append(iterator.next());
                while (iterator.hasNext()) {
                    buffer.append("," + iterator.next());
                }
                this.delegate.append(buffer.toString());
            }
            Manifest auxmanifest = this.delegate.getManifest();
            try {
                OSGiManifestBuilder.validateBundleManifest(auxmanifest);
            }
            catch (BundleException ex) {
                throw new IllegalStateException(ex);
            }
            this.manifest = auxmanifest;
        }
        return this.manifest;
    }

    public static boolean isValidBundleManifest(Manifest manifest) {
        if (manifest == null) {
            return false;
        }
        try {
            OSGiManifestBuilder.validateBundleManifest(manifest);
            return true;
        }
        catch (BundleException e) {
            return false;
        }
    }

    public static void validateBundleManifest(Manifest manifest) throws BundleException {
        int manifestVersion;
        if (manifest == null) {
            MetadataMessages.MESSAGES.illegalArgumentNull("manifest");
        }
        if ((manifestVersion = OSGiManifestBuilder.getBundleManifestVersion(manifest)) < 0) {
            throw MetadataMessages.MESSAGES.bundleCannotObtainBundleManifestVersion();
        }
        if (manifestVersion > 2) {
            throw MetadataMessages.MESSAGES.bundleUnsupportedBundleManifestVersion(manifestVersion);
        }
        String symbolicName = OSGiManifestBuilder.getManifestHeaderInternal(manifest, "Bundle-SymbolicName");
        if (manifestVersion == 1 && symbolicName != null) {
            throw MetadataMessages.MESSAGES.bundleInvalidBundleManifestVersion(symbolicName);
        }
        if (manifestVersion == 2 && symbolicName == null) {
            throw MetadataMessages.MESSAGES.bundleCannotObtainBundleSymbolicName();
        }
    }

    public static int getBundleManifestVersion(Manifest manifest) {
        if (manifest == null) {
            throw MetadataMessages.MESSAGES.illegalArgumentNull("manifest");
        }
        String manifestVersion = OSGiManifestBuilder.getManifestHeaderInternal(manifest, "Bundle-ManifestVersion");
        if (manifestVersion != null) {
            return Integer.parseInt(manifestVersion);
        }
        String bundleName = OSGiManifestBuilder.getManifestHeaderInternal(manifest, "Bundle-Name");
        String bundleSymbolicName = OSGiManifestBuilder.getManifestHeaderInternal(manifest, "Bundle-SymbolicName");
        String bundleVersion = OSGiManifestBuilder.getManifestHeaderInternal(manifest, "Bundle-Version");
        if (bundleName == null && bundleSymbolicName == null && bundleVersion == null) {
            return -1;
        }
        return 1;
    }

    public InputStream openStream() {
        Manifest manifest = this.getManifest();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            manifest.write(baos);
            return new ByteArrayInputStream(baos.toByteArray());
        }
        catch (IOException ex) {
            throw MetadataMessages.MESSAGES.illegalStateCannotProvideManifestInputStream(ex);
        }
    }

    private static String getManifestHeaderInternal(Manifest manifest, String key) {
        Attributes attribs = manifest.getMainAttributes();
        String value = attribs.getValue(key);
        return value != null ? value.trim() : null;
    }
}

