/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.resource.mediaplayer.mpeg;

import java.io.DataInputStream;
import java.io.IOException;
import org.mobicents.media.server.impl.resource.mediaplayer.mpeg.CleanApertureBox;
import org.mobicents.media.server.impl.resource.mediaplayer.mpeg.ESDBox;
import org.mobicents.media.server.impl.resource.mediaplayer.mpeg.PixelAspectRatioBox;
import org.mobicents.media.server.impl.resource.mediaplayer.mpeg.SampleEntry;

public class VisualSampleEntry
extends SampleEntry {
    static byte[] TYPE = new byte[]{109, 112, 52, 118};
    static String TYPE_S = "mp4v";
    private int[] predefined = new int[3];
    private int width;
    private int height;
    private double horizresolution;
    private double vertresolution;
    private int frameCount = 1;
    private String compressorname;
    private int depth;
    private PixelAspectRatioBox pixelAspectRatioBox;
    private CleanApertureBox cleanApertureBox;
    private ESDBox eSDBox;

    public VisualSampleEntry(long size) {
        super(size, TYPE_S);
    }

    @Override
    protected int load(DataInputStream fin) throws IOException {
        int count = 8;
        count += super.load(fin);
        fin.skip(4L);
        count += 4;
        this.predefined[0] = fin.readInt();
        this.predefined[1] = fin.readInt();
        this.predefined[2] = fin.readInt();
        count += 12;
        this.width = this.read16(fin);
        count += 2;
        this.height = this.read16(fin);
        count += 2;
        this.horizresolution = this.readFixedPoint1616(fin);
        this.vertresolution = this.readFixedPoint1616(fin);
        count += 8;
        fin.readInt();
        count += 4;
        this.frameCount = this.read16(fin);
        count += 2;
        int length = fin.read();
        byte[] compnamebyte = new byte[length];
        fin.read(compnamebyte, 0, length);
        this.compressorname = new String(compnamebyte, "UTF-8");
        byte[] zerosDiscard = new byte[31 - length];
        fin.read(zerosDiscard, 0, 31 - length);
        count += 32;
        this.depth = this.read16(fin);
        count += 2;
        this.read16(fin);
        count += 2;
        while ((long)count < this.getSize()) {
            int len = fin.readInt();
            byte[] type = this.read(fin);
            if (this.comparebytes(type, CleanApertureBox.TYPE)) {
                this.cleanApertureBox = new CleanApertureBox(len);
                count += this.cleanApertureBox.load(fin);
                continue;
            }
            if (this.comparebytes(type, PixelAspectRatioBox.TYPE)) {
                this.pixelAspectRatioBox = new PixelAspectRatioBox(len);
                count += this.pixelAspectRatioBox.load(fin);
                continue;
            }
            if (!this.comparebytes(type, ESDBox.TYPE)) continue;
            this.eSDBox = new ESDBox(len);
            count += this.eSDBox.load(fin);
        }
        return (int)this.getSize();
    }

    public int[] getPredefined() {
        return this.predefined;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public double getHorizresolution() {
        return this.horizresolution;
    }

    public double getVertresolution() {
        return this.vertresolution;
    }

    public int getFrameCount() {
        return this.frameCount;
    }

    public String getCompressorname() {
        return this.compressorname;
    }

    public int getDepth() {
        return this.depth;
    }

    public PixelAspectRatioBox getPixelAspectRatioBox() {
        return this.pixelAspectRatioBox;
    }

    public CleanApertureBox getCleanApertureBox() {
        return this.cleanApertureBox;
    }

    public ESDBox getESDBox() {
        return this.eSDBox;
    }

    static {
        bytetoTypeMap.put(TYPE, TYPE_S);
    }
}

