/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.resource.mediaplayer.mpeg;

import java.io.DataInputStream;
import java.io.IOException;
import org.mobicents.media.server.impl.resource.mediaplayer.mpeg.AMRSampleEntry;
import org.mobicents.media.server.impl.resource.mediaplayer.mpeg.AMRWidebandSampleEntry;
import org.mobicents.media.server.impl.resource.mediaplayer.mpeg.FullBox;
import org.mobicents.media.server.impl.resource.mediaplayer.mpeg.MP4AudioSampleEntry;
import org.mobicents.media.server.impl.resource.mediaplayer.mpeg.RtpHintSampleEntry;
import org.mobicents.media.server.impl.resource.mediaplayer.mpeg.SampleEntry;
import org.mobicents.media.server.impl.resource.mediaplayer.mpeg.UndefinedBox;
import org.mobicents.media.server.impl.resource.mediaplayer.mpeg.VisualSampleEntry;

public class SampleDescriptionBox
extends FullBox {
    static byte[] TYPE = new byte[]{115, 116, 115, 100};
    static String TYPE_S = "stsd";
    private SampleEntry[] sampleEntries = null;

    public SampleDescriptionBox(long size) {
        super(size, TYPE_S);
    }

    @Override
    protected int load(DataInputStream fin) throws IOException {
        super.load(fin);
        long entryCount = this.readU32(fin);
        this.sampleEntries = new SampleEntry[(int)entryCount];
        int i = 0;
        while ((long)i < entryCount) {
            long len1 = this.readU32(fin);
            byte[] type = this.read(fin);
            SampleEntry sampleEntry = null;
            if (this.comparebytes(type, AMRSampleEntry.TYPE)) {
                sampleEntry = new AMRSampleEntry(len1);
                sampleEntry.load(fin);
            } else if (this.comparebytes(type, AMRWidebandSampleEntry.TYPE)) {
                sampleEntry = new AMRWidebandSampleEntry(len1);
                sampleEntry.load(fin);
            } else if (this.comparebytes(type, MP4AudioSampleEntry.TYPE)) {
                sampleEntry = new MP4AudioSampleEntry(len1);
                sampleEntry.load(fin);
            } else if (this.comparebytes(type, VisualSampleEntry.TYPE)) {
                sampleEntry = new VisualSampleEntry(len1);
                sampleEntry.load(fin);
            } else if (this.comparebytes(type, RtpHintSampleEntry.TYPE)) {
                sampleEntry = new RtpHintSampleEntry(len1);
                sampleEntry.load(fin);
            } else {
                UndefinedBox undefinedBox = new UndefinedBox(len1, new String(type));
                undefinedBox.load(fin);
            }
            this.sampleEntries[i] = sampleEntry;
            ++i;
        }
        return (int)this.getSize();
    }

    public SampleEntry[] getSampleEntries() {
        return this.sampleEntries;
    }

    static {
        bytetoTypeMap.put(TYPE, TYPE_S);
    }
}

