/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.resource.mediaplayer.mpeg;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.mobicents.media.server.impl.resource.mediaplayer.mpeg.Box;
import org.mobicents.media.server.impl.resource.mediaplayer.mpeg.SampleEntry;
import org.mobicents.media.server.impl.resource.mediaplayer.mpeg.SequenceOffSet;
import org.mobicents.media.server.impl.resource.mediaplayer.mpeg.TimeOffSet;
import org.mobicents.media.server.impl.resource.mediaplayer.mpeg.TimeScaleEntry;

public class RtpHintSampleEntry
extends SampleEntry {
    static byte[] TYPE = new byte[]{114, 116, 112, 32};
    static String TYPE_S = "rtp ";
    private int hintTrackVersion;
    private int highestCompatibleVersion;
    private long maxPacketSize;
    private List<Box> additionaldata = new ArrayList<Box>();

    public RtpHintSampleEntry(long size) {
        super(size, TYPE_S);
    }

    @Override
    protected int load(DataInputStream fin) throws IOException {
        int count = 8;
        count += super.load(fin);
        this.hintTrackVersion = this.read16(fin);
        this.highestCompatibleVersion = this.read16(fin);
        this.maxPacketSize = this.readU32(fin);
        count += 8;
        while ((long)count < this.getSize()) {
            long length = this.readU32(fin);
            byte[] type = this.read(fin);
            Box box = null;
            if (this.comparebytes(type, TimeScaleEntry.TYPE)) {
                box = new TimeScaleEntry(length);
                count += box.load(fin);
            } else if (this.comparebytes(type, TimeOffSet.TYPE)) {
                box = new TimeOffSet(length);
                count += box.load(fin);
            } else if (this.comparebytes(type, SequenceOffSet.TYPE)) {
                box = new SequenceOffSet(length);
                count += box.load(fin);
            } else {
                throw new IOException("Unknown box=" + new String(type) + " From parent RtpHintSampleEntry");
            }
            this.additionaldata.add(box);
        }
        return (int)this.getSize();
    }

    public int getHintTrackVersion() {
        return this.hintTrackVersion;
    }

    public int getHighestCompatibleVersion() {
        return this.highestCompatibleVersion;
    }

    public long getMaxPacketSize() {
        return this.maxPacketSize;
    }

    public List<Box> getAdditionaldata() {
        return this.additionaldata;
    }

    static {
        bytetoTypeMap.put(TYPE, TYPE_S);
    }
}

