/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.resource.mediaplayer.mpeg;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.List;
import org.mobicents.media.server.impl.resource.mediaplayer.mpeg.RTPConstructor;
import org.mobicents.media.server.impl.resource.mediaplayer.mpeg.RTPImmediateConstructor;
import org.mobicents.media.server.impl.resource.mediaplayer.mpeg.RTPNoOpConstructor;
import org.mobicents.media.server.impl.resource.mediaplayer.mpeg.RTPSampleConstructor;
import org.mobicents.media.server.impl.resource.mediaplayer.mpeg.RTPSampleDescriptionConstructor;

public class RTPLocalPacket {
    private int relativeTime;
    private int Pbit;
    private int Xbit;
    private int Mbit;
    private int payloadType;
    private int extraFlag;
    private int bframeFlag;
    private int repeatFlag;
    private int rtpSequenceSeed;
    private byte[] payload;
    private long rtpTimestamp;
    private int MandPayloadType;
    private List<RTPConstructor> rtConsList = new ArrayList<RTPConstructor>();

    public int load(RandomAccessFile raAccFile) throws IOException {
        int count = 12;
        this.relativeTime = raAccFile.readInt();
        int PandXbit = raAccFile.read();
        this.Pbit = PandXbit & 0x40;
        this.Xbit = (PandXbit & 0x20) >> 5;
        this.MandPayloadType = raAccFile.read();
        this.Mbit = (this.MandPayloadType & 0x80) >> 7;
        this.payloadType = this.MandPayloadType & 0x7F;
        this.rtpSequenceSeed = raAccFile.read() << 8 | raAccFile.read();
        raAccFile.read();
        int flags = raAccFile.read();
        this.extraFlag = (flags & 4) >> 2;
        this.bframeFlag = (flags & 2) >> 1;
        this.repeatFlag = flags & 1;
        int entrycount = raAccFile.read() << 8 | raAccFile.read();
        if (this.extraFlag == 1) {
            int extraInfLength = raAccFile.read() << 24 | raAccFile.read() << 16 | raAccFile.read() << 8 | raAccFile.read() << 0;
            count += extraInfLength;
            for (int skipped = 0; skipped < extraInfLength; skipped += raAccFile.skipBytes(extraInfLength)) {
            }
        }
        for (int i = 0; i < entrycount; ++i) {
            int type = raAccFile.read();
            RTPConstructor rtpConstructor = null;
            switch (type) {
                case 0: {
                    rtpConstructor = new RTPNoOpConstructor();
                    count += rtpConstructor.load(raAccFile);
                    break;
                }
                case 1: {
                    rtpConstructor = new RTPImmediateConstructor();
                    count += rtpConstructor.load(raAccFile);
                    break;
                }
                case 2: {
                    rtpConstructor = new RTPSampleConstructor();
                    count += rtpConstructor.load(raAccFile);
                    break;
                }
                case 3: {
                    rtpConstructor = new RTPSampleDescriptionConstructor();
                    count += rtpConstructor.load(raAccFile);
                    break;
                }
                default: {
                    throw new IOException("Unknown RTPConstructor Type = " + type);
                }
            }
            this.rtConsList.add(rtpConstructor);
        }
        return count;
    }

    public int getRelativeTime() {
        return this.relativeTime;
    }

    public int getPbit() {
        return this.Pbit;
    }

    public int getXbit() {
        return this.Xbit;
    }

    public int getMbit() {
        return this.Mbit;
    }

    public int getPayloadType() {
        return this.payloadType;
    }

    public int getExtraFlag() {
        return this.extraFlag;
    }

    public int getBframeFlag() {
        return this.bframeFlag;
    }

    public int getRepeatFlag() {
        return this.repeatFlag;
    }

    public int getRtpSequenceSeed() {
        return this.rtpSequenceSeed;
    }

    public List<RTPConstructor> RTPConstructorList() {
        return this.rtConsList;
    }

    public byte[] getPayload() {
        return this.payload;
    }

    public void setPayload(byte[] payload) {
        this.payload = payload;
    }

    public long getRtpTimestamp() {
        return this.rtpTimestamp;
    }

    public void setRtpTimestamp(long timestamp) {
        this.rtpTimestamp = timestamp;
    }

    public byte[] toByteArray(long ssrc) {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        int b = 128;
        b |= this.Pbit << 6;
        bout.write(b |= this.Xbit << 5);
        bout.write(this.MandPayloadType);
        bout.write((byte)((this.rtpSequenceSeed & 0xFF00) >> 8));
        bout.write((byte)(this.rtpSequenceSeed & 0xFF));
        bout.write((byte)((this.rtpTimestamp & 0xFFFFFFFFFF000000L) >> 24));
        bout.write((byte)((this.rtpTimestamp & 0xFF0000L) >> 16));
        bout.write((byte)((this.rtpTimestamp & 0xFF00L) >> 8));
        bout.write((byte)(this.rtpTimestamp & 0xFFL));
        bout.write((byte)((ssrc & 0xFFFFFFFFFF000000L) >> 24));
        bout.write((byte)((ssrc & 0xFF0000L) >> 16));
        bout.write((byte)((ssrc & 0xFF00L) >> 8));
        bout.write((byte)(ssrc & 0xFFL));
        bout.write(this.payload, 0, this.payload.length);
        return bout.toByteArray();
    }
}

