/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.resource.mediaplayer.mpeg;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.mobicents.media.server.impl.resource.mediaplayer.mpeg.Box;
import org.mobicents.media.server.impl.resource.mediaplayer.mpeg.MovieHeaderBox;
import org.mobicents.media.server.impl.resource.mediaplayer.mpeg.TrackBox;
import org.mobicents.media.server.impl.resource.mediaplayer.mpeg.UserDataBox;

public class MovieBox
extends Box {
    static byte[] TYPE = new byte[]{109, 111, 111, 118};
    static String TYPE_S = "moov";
    private MovieHeaderBox movieHeaderBox;
    private List<TrackBox> trackBoxes = new ArrayList<TrackBox>();
    private TrackBox track;
    private UserDataBox userDataBox = null;

    public MovieBox(long size) {
        super(size, TYPE_S);
    }

    @Override
    protected int load(DataInputStream in) throws IOException {
        int count = 8;
        long len = this.readU32(in);
        byte[] type = this.read(in);
        if (!this.comparebytes(type, MovieHeaderBox.TYPE)) {
            throw new IOException("Movie Header Box expected");
        }
        this.movieHeaderBox = new MovieHeaderBox(len);
        count += this.movieHeaderBox.load(in);
        while ((long)count < this.getSize()) {
            len = this.readU32(in);
            type = this.read(in);
            if (this.comparebytes(type, TrackBox.TYPE)) {
                this.track = new TrackBox(len);
                count += this.track.load(in);
                this.trackBoxes.add(this.track);
                continue;
            }
            if (this.comparebytes(type, UserDataBox.TYPE)) {
                this.userDataBox = new UserDataBox(len, false);
                count += this.userDataBox.load(in);
                continue;
            }
            throw new IOException("Track box expected. But is " + new String(type));
        }
        return (int)this.getSize();
    }

    public MovieHeaderBox getMovieHeaderBox() {
        return this.movieHeaderBox;
    }

    public List<TrackBox> getTrackBoxes() {
        return this.trackBoxes;
    }

    static {
        bytetoTypeMap.put(TYPE, TYPE_S);
    }
}

