/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.resource.mediaplayer.mpeg;

import java.io.DataInputStream;
import java.io.IOException;
import org.mobicents.media.server.impl.resource.mediaplayer.mpeg.Box;
import org.mobicents.media.server.impl.resource.mediaplayer.mpeg.DataInformationBox;
import org.mobicents.media.server.impl.resource.mediaplayer.mpeg.HandlerReferenceBox;
import org.mobicents.media.server.impl.resource.mediaplayer.mpeg.HintMediaHeaderBox;
import org.mobicents.media.server.impl.resource.mediaplayer.mpeg.NullMediaHeaderBox;
import org.mobicents.media.server.impl.resource.mediaplayer.mpeg.SampleTableBox;
import org.mobicents.media.server.impl.resource.mediaplayer.mpeg.SoundMediaHeaderBox;
import org.mobicents.media.server.impl.resource.mediaplayer.mpeg.UndefinedBox;
import org.mobicents.media.server.impl.resource.mediaplayer.mpeg.VideoMediaHeaderBox;

public class MediaInformationBox
extends Box {
    static byte[] TYPE = new byte[]{109, 105, 110, 102};
    static String TYPE_S = "minf";
    private SoundMediaHeaderBox soundMediaHeaderBox;
    private VideoMediaHeaderBox videoMediaHeaderBox;
    private HintMediaHeaderBox hintMediaHeaderBox;
    private NullMediaHeaderBox nullMediaHeaderBox;
    private DataInformationBox dataInformationBox;
    private SampleTableBox sampleTableBox;
    private HandlerReferenceBox handlerReferenceBox;

    public MediaInformationBox(long size) {
        super(size, TYPE_S);
    }

    @Override
    protected int load(DataInputStream fin) throws IOException {
        int count = 8;
        while ((long)count < this.getSize()) {
            long len = this.readU32(fin);
            byte[] type = this.read(fin);
            if (this.comparebytes(type, VideoMediaHeaderBox.TYPE)) {
                this.videoMediaHeaderBox = new VideoMediaHeaderBox(len);
                count += this.videoMediaHeaderBox.load(fin);
                continue;
            }
            if (this.comparebytes(type, SoundMediaHeaderBox.TYPE)) {
                this.soundMediaHeaderBox = new SoundMediaHeaderBox(len);
                count += this.soundMediaHeaderBox.load(fin);
                continue;
            }
            if (this.comparebytes(type, HintMediaHeaderBox.TYPE)) {
                this.hintMediaHeaderBox = new HintMediaHeaderBox(len);
                count += this.hintMediaHeaderBox.load(fin);
                continue;
            }
            if (this.comparebytes(type, NullMediaHeaderBox.TYPE)) {
                this.nullMediaHeaderBox = new NullMediaHeaderBox(len);
                count += this.nullMediaHeaderBox.load(fin);
                continue;
            }
            if (this.comparebytes(type, DataInformationBox.TYPE)) {
                this.dataInformationBox = new DataInformationBox(len);
                count += this.dataInformationBox.load(fin);
                continue;
            }
            if (this.comparebytes(type, SampleTableBox.TYPE)) {
                this.sampleTableBox = new SampleTableBox(len);
                count += this.sampleTableBox.load(fin);
                continue;
            }
            if (this.comparebytes(type, HandlerReferenceBox.TYPE)) {
                this.handlerReferenceBox = new HandlerReferenceBox(len);
                count += this.handlerReferenceBox.load(fin);
                continue;
            }
            UndefinedBox box = new UndefinedBox(len, new String(type));
            count += box.load(fin);
        }
        return (int)this.getSize();
    }

    public SoundMediaHeaderBox getSoundMediaHeaderBox() {
        return this.soundMediaHeaderBox;
    }

    public VideoMediaHeaderBox getVideoMediaHeaderBox() {
        return this.videoMediaHeaderBox;
    }

    public HintMediaHeaderBox getHintMediaHeaderBox() {
        return this.hintMediaHeaderBox;
    }

    public NullMediaHeaderBox getNullMediaHeaderBox() {
        return this.nullMediaHeaderBox;
    }

    public DataInformationBox getDataInformationBox() {
        return this.dataInformationBox;
    }

    public SampleTableBox getSampleTableBox() {
        return this.sampleTableBox;
    }

    public HandlerReferenceBox getHandlerReferenceBox() {
        return this.handlerReferenceBox;
    }

    static {
        bytetoTypeMap.put(TYPE, TYPE_S);
    }
}

