/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.resource.mediaplayer.mpeg;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.Date;
import org.mobicents.media.server.impl.resource.mediaplayer.mpeg.FullBox;

public class MediaHeaderBox
extends FullBox {
    static byte[] TYPE = new byte[]{109, 100, 104, 100};
    static String TYPE_S = "mdhd";
    private long creationTime;
    private long modificationTime;
    private long timescale;
    private long duration;
    private int language;

    public MediaHeaderBox(long size) {
        super(size, TYPE_S);
    }

    public Date getCreationTime() {
        return new Date(this.creationTime);
    }

    public Date getModificationTime() {
        return new Date(this.modificationTime);
    }

    public long getDuration() {
        return this.duration;
    }

    @Override
    protected int load(DataInputStream fin) throws IOException {
        super.load(fin);
        if (this.getVersion() == 1) {
            this.creationTime = this.readU64(fin);
            this.modificationTime = this.readU64(fin);
            this.timescale = this.readU64(fin);
            this.duration = this.read64(fin);
        } else {
            this.creationTime = this.readU32(fin);
            this.modificationTime = this.readU32(fin);
            this.timescale = this.readU32(fin);
            this.duration = this.readU32(fin);
        }
        this.language = this.read16(fin);
        fin.readByte();
        fin.readByte();
        return (int)this.getSize();
    }

    public long getTimescale() {
        return this.timescale;
    }

    public int getLanguage() {
        return this.language;
    }

    static {
        bytetoTypeMap.put(TYPE, TYPE_S);
    }
}

