/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.resource.mediaplayer.mpeg;

import java.io.DataInputStream;
import java.io.IOException;
import org.mobicents.media.server.impl.resource.mediaplayer.mpeg.Box;

public class FileTypeBox
extends Box {
    static byte[] TYPE = new byte[]{102, 116, 121, 112};
    static String TYPE_S = "ftyp";
    private String majorBrand;
    private long minorVersion;
    private String[] compatibleBrands;

    public FileTypeBox(long size) {
        super(size, TYPE_S);
    }

    public String getMajorBrand() {
        return this.majorBrand;
    }

    public long getMinorVersion() {
        return this.minorVersion;
    }

    public String[] getCompatibleBrands() {
        return this.compatibleBrands;
    }

    @Override
    protected int load(DataInputStream fin) throws IOException {
        this.majorBrand = new String(this.read(fin));
        this.minorVersion = this.readU32(fin);
        long remainder = this.getSize() - 16L;
        int count = (int)(remainder / 4L);
        this.compatibleBrands = new String[count];
        for (int i = 0; i < count; ++i) {
            this.compatibleBrands[i] = new String(this.read(fin));
        }
        return (int)this.getSize();
    }

    public String toString() {
        StringBuffer b = new StringBuffer("FileTypeBox(ftyp)[majorBrand=").append(this.majorBrand).append(",minorVersion=").append(this.minorVersion).append(",compatibleBrands[");
        for (String s : this.compatibleBrands) {
            b.append(s);
            b.append(",");
        }
        b.append("]]");
        return b.toString();
    }

    static {
        bytetoTypeMap.put(TYPE, TYPE_S);
    }
}

