/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.resource.mediaplayer.mpeg;

import java.io.DataInputStream;
import java.io.IOException;
import org.mobicents.media.server.impl.resource.mediaplayer.mpeg.FullBox;

public class EditListBox
extends FullBox {
    static byte[] TYPE = new byte[]{101, 108, 115, 116};
    static String TYPE_S = "elst";
    private long entryCount;
    private long[] segmentDuration;
    private long[] mediaTime;
    private int[] rate;
    private int[] fraction;

    public EditListBox(long size) {
        super(size, TYPE_S);
    }

    @Override
    protected int load(DataInputStream fin) throws IOException {
        super.load(fin);
        this.entryCount = this.readU32(fin);
        this.segmentDuration = new long[(int)this.entryCount];
        this.mediaTime = new long[(int)this.entryCount];
        this.rate = new int[(int)this.entryCount];
        this.fraction = new int[(int)this.entryCount];
        int i = 0;
        while ((long)i < this.entryCount) {
            if (this.getVersion() == 1) {
                this.segmentDuration[i] = this.read64(fin);
                this.mediaTime[i] = this.read64(fin);
            } else {
                this.segmentDuration[i] = fin.readInt();
                this.mediaTime[i] = fin.readInt();
            }
            this.rate[i] = fin.readByte() << 8 | fin.readByte();
            this.fraction[i] = fin.readByte() << 8 | fin.readByte();
            ++i;
        }
        return (int)this.getSize();
    }

    public long[] getSegmentDuration() {
        return this.segmentDuration;
    }

    public long[] getMediaTime() {
        return this.mediaTime;
    }

    public int[] getRate() {
        return this.rate;
    }

    public int[] getFraction() {
        return this.fraction;
    }

    static {
        bytetoTypeMap.put(TYPE, TYPE_S);
    }
}

