/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.resource.mediaplayer.audio.wav;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.SimpleDateFormat;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.apache.log4j.Logger;
import org.mobicents.media.server.impl.resource.mediaplayer.Track;
import org.mobicents.media.server.spi.format.AudioFormat;
import org.mobicents.media.server.spi.format.Format;
import org.mobicents.media.server.spi.format.FormatFactory;
import org.mobicents.media.server.spi.memory.Frame;
import org.mobicents.media.server.spi.memory.Memory;

public class WavTrackImpl
implements Track {
    private InputStream inStream;
    private AudioFormat format;
    private int period = 20;
    private int frameSize;
    private boolean eom;
    private long duration;
    private int totalRead = 0;
    private int sizeOfData;
    private boolean first = true;
    private SimpleDateFormat fmt = new SimpleDateFormat("HH:mm:ss,SSS");
    private static final Logger logger = Logger.getLogger(WavTrackImpl.class);
    private static final byte PCM_PADDING_BYTE = 0;
    private static final byte ALAW_PADDING_BYTE = -43;
    private static final byte ULAW_PADDING_BYTE = -1;
    private static final byte[] factBytes = new byte[]{102, 97, 99, 116};
    private byte paddingByte = 0;

    public WavTrackImpl(URL url) throws UnsupportedAudioFileException, IOException {
        this.inStream = url.openStream();
        this.getFormat(this.inStream);
        if (this.format == null) {
            throw new UnsupportedAudioFileException();
        }
    }

    public void setPeriod(int period) {
        this.period = period;
        this.frameSize = period * this.format.getChannels() * this.format.getSampleSize() * this.format.getSampleRate() / 8000;
    }

    public int getPeriod() {
        return this.period;
    }

    @Override
    public long getMediaTime() {
        return 0L;
    }

    @Override
    public long getDuration() {
        return this.duration;
    }

    @Override
    public void setMediaTime(long timestamp) {
    }

    private void skip(long timestamp) {
        try {
            int len;
            long offset = (long)this.frameSize * (timestamp / (long)this.period / 1000000L);
            byte[] skip = new byte[(int)offset];
            for (int bytesRead = 0; bytesRead < skip.length && this.inStream.available() > 0; bytesRead += len) {
                len = this.inStream.read(skip, bytesRead, skip.length - bytesRead);
                if (len == -1) {
                    return;
                }
                this.totalRead += len;
            }
        }
        catch (IOException e) {
            logger.error((Object)e);
        }
    }

    private void getFormat(InputStream stream) throws IOException {
        int len;
        int bytesRead;
        int len2;
        byte[] header = new byte[36];
        byte[] headerEnd = null;
        for (bytesRead = 0; bytesRead < 36 && stream.available() > 0; bytesRead += len2) {
            len2 = stream.read(header, bytesRead, 36 - bytesRead);
            if (len2 != -1) continue;
            return;
        }
        int ckSize = header[16] & 0xFF | (header[17] & 0xFF) << 8 | (header[18] & 0xFF) << 16 | (header[19] & 0xFF) << 24;
        int formatValue = header[20] & 0xFF | (header[21] & 0xFF) << 8;
        int channels = header[22] & 0xFF | (header[23] & 0xFF) << 8;
        int bitsPerSample = header[34] & 0xFF | (header[35] & 0xFF) << 8;
        int sampleRate = header[24] & 0xFF | (header[25] & 0xFF) << 8 | (header[26] & 0xFF) << 16 | (header[27] & 0xFF) << 24;
        this.sizeOfData = header[4] & 0xFF | (header[5] & 0xFF) << 8 | (header[6] & 0xFF) << 16 | (header[7] & 0xFF) << 24;
        this.sizeOfData -= 12;
        this.sizeOfData -= ckSize;
        int extraHeaderSize = 0;
        this.format = null;
        switch (formatValue) {
            case 1: {
                this.format = FormatFactory.createAudioFormat((String)"linear", (int)sampleRate, (int)bitsPerSample, (int)channels);
                break;
            }
            case 6: {
                this.format = FormatFactory.createAudioFormat((String)"pcma", (int)sampleRate, (int)bitsPerSample, (int)channels);
                this.paddingByte = (byte)-43;
                break;
            }
            case 7: {
                this.format = FormatFactory.createAudioFormat((String)"pcmu", (int)sampleRate, (int)bitsPerSample, (int)channels);
                this.paddingByte = (byte)-1;
            }
        }
        headerEnd = new byte[8 + ckSize - 16];
        extraHeaderSize = headerEnd.length;
        for (bytesRead = 0; bytesRead < extraHeaderSize && stream.available() > 0; bytesRead += len) {
            len = stream.read(headerEnd, bytesRead, extraHeaderSize - bytesRead);
            if (len != -1) continue;
            return;
        }
        int byteIndex = headerEnd.length - 4 - factBytes.length;
        boolean hasFact = true;
        for (int i = 0; i < factBytes.length; ++i) {
            if (factBytes[i] == headerEnd[byteIndex++]) continue;
            hasFact = false;
            break;
        }
        if (hasFact) {
            int len3;
            this.sizeOfData -= 12;
            headerEnd = new byte[12];
            for (bytesRead = 0; bytesRead < 12 && stream.available() > 0; bytesRead += len3) {
                len3 = stream.read(headerEnd, bytesRead, 12 - bytesRead);
                if (len3 != -1) continue;
                return;
            }
        }
        if (this.format != null) {
            this.frameSize = this.period * this.format.getChannels() * this.format.getSampleSize() * this.format.getSampleRate() / 8000;
            this.duration = (long)(this.sizeOfData * this.period) * 1000000L / (long)this.frameSize;
        }
    }

    private int readPacket(byte[] packet, int offset, int psize) throws IOException {
        int length;
        try {
            int len;
            for (length = 0; length < psize && this.inStream.available() > 0; length += len) {
                len = this.inStream.read(packet, offset + length, psize - length);
                if (len != -1) continue;
                return length;
            }
            return length;
        }
        catch (Exception e) {
            logger.error((Object)e);
            return length;
        }
    }

    private void padding(byte[] data, int count) {
        int offset = data.length - count;
        for (int i = 0; i < count; ++i) {
            data[i + offset] = this.paddingByte;
        }
    }

    @Override
    public Frame process(long timestamp) throws IOException {
        Frame frame;
        byte[] data;
        if (this.first) {
            if (timestamp > 0L) {
                this.skip(timestamp);
            }
            this.first = false;
        }
        if ((data = (frame = Memory.allocate((int)this.frameSize)).getData()) == null) {
            data = new byte[this.frameSize];
        }
        int len = this.readPacket(data, 0, this.frameSize);
        this.totalRead += len;
        if (len == 0) {
            this.eom = true;
        }
        if (len < this.frameSize) {
            this.padding(data, this.frameSize - len);
            this.eom = true;
        }
        if (this.totalRead >= this.sizeOfData) {
            this.eom = true;
        }
        frame.setOffset(0);
        frame.setLength(this.frameSize);
        frame.setEOM(this.eom);
        frame.setDuration((long)this.period * 1000000L);
        frame.setFormat((Format)this.format);
        return frame;
    }

    @Override
    public void close() {
        try {
            this.inStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public Format getFormat() {
        return this.format;
    }
}

