/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.resource.mediaplayer.audio.tts;

import com.sun.speech.freetts.Voice;
import com.sun.speech.freetts.audio.AudioPlayer;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Vector;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import org.apache.log4j.Logger;
import org.mobicents.media.server.impl.resource.mediaplayer.Track;
import org.mobicents.media.server.impl.resource.mediaplayer.audio.tts.VoicesCache;
import org.mobicents.media.server.spi.format.Format;
import org.mobicents.media.server.spi.format.FormatFactory;
import org.mobicents.media.server.spi.memory.Frame;
import org.mobicents.media.server.spi.memory.Memory;

public class TtsTrackImpl
implements Track {
    private transient AudioInputStream stream = null;
    private org.mobicents.media.server.spi.format.AudioFormat format = FormatFactory.createAudioFormat((String)"linear", (int)8000, (int)16, (int)1);
    private int period = 20;
    private int frameSize;
    private boolean eom;
    private boolean isReady = false;
    private Vector<byte[]> outputList;
    private Voice voice;
    private long duration;
    private long timestamp;
    private VoicesCache voiceCache;
    private static final Logger logger = Logger.getLogger(TtsTrackImpl.class);

    public TtsTrackImpl(URL url, String voiceName, VoicesCache vc) throws IOException {
        this.voiceCache = vc;
        this.isReady = false;
        URLConnection connection = url.openConnection();
        this.frameSize = this.period * this.format.getChannels() * this.format.getSampleSize() * this.format.getSampleRate() / 8000;
        this.voice = this.voiceCache.allocateVoice(voiceName);
        TTSAudioBuffer audioBuffer = new TTSAudioBuffer();
        this.voice.setAudioPlayer((AudioPlayer)audioBuffer);
        this.voice.speak(connection.getInputStream());
        audioBuffer.flip();
    }

    public TtsTrackImpl(String text, String voiceName, VoicesCache vc) {
        this.voiceCache = vc;
        this.isReady = false;
        this.voice = this.voiceCache.allocateVoice(voiceName);
        TTSAudioBuffer audioBuffer = new TTSAudioBuffer();
        this.voice.setAudioPlayer((AudioPlayer)audioBuffer);
        this.voice.speak(text);
        audioBuffer.flip();
        this.frameSize = this.period * this.format.getChannels() * this.format.getSampleSize() * this.format.getSampleRate() / 8000;
    }

    public void setPeriod(int period) {
        this.period = period;
        this.frameSize = period * this.format.getChannels() * this.format.getSampleSize() * this.format.getSampleRate() / 8000;
    }

    public int getPeriod() {
        return this.period;
    }

    @Override
    public long getMediaTime() {
        return this.timestamp;
    }

    @Override
    public void setMediaTime(long timestamp) {
        this.timestamp = timestamp;
        try {
            this.stream.reset();
            long offset = (long)this.frameSize * (timestamp / (long)this.period);
            this.stream.skip(offset);
        }
        catch (IOException e) {
            logger.error((Object)e);
        }
    }

    @Override
    public long getDuration() {
        return this.duration;
    }

    private int readPacket(byte[] packet, int offset, int psize) throws IOException {
        int length;
        try {
            int len;
            for (length = 0; length < psize; length += len) {
                len = this.stream.read(packet, offset + length, psize - length);
                if (len != -1) continue;
                return length;
            }
            return length;
        }
        catch (Exception e) {
            logger.error((Object)e);
            return length;
        }
    }

    private void padding(byte[] data, int count) {
        int offset = data.length - count;
        for (int i = 0; i < count; ++i) {
            data[i + offset] = 0;
        }
    }

    private void switchEndian(byte[] b, int off, int readCount) {
        for (int i = off; i < off + readCount; i += 2) {
            byte temp = b[i];
            b[i] = b[i + 1];
            b[i + 1] = temp;
        }
    }

    @Override
    public Frame process(long timestamp) throws IOException {
        if (!this.isReady) {
            return null;
        }
        Frame frame = Memory.allocate((int)this.frameSize);
        byte[] data = frame.getData();
        int len = this.readPacket(data, 0, this.frameSize);
        if (len == 0) {
            this.eom = true;
        }
        if (len < this.frameSize) {
            this.padding(data, this.frameSize - len);
            this.eom = true;
        }
        frame.setOffset(0);
        frame.setLength(this.frameSize);
        frame.setEOM(this.eom);
        frame.setDuration(20L);
        return frame;
    }

    @Override
    public void close() {
        try {
            this.voiceCache.releaseVoice(this.voice);
            this.voice = null;
            this.stream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public Format getFormat() {
        return this.format;
    }

    private class TTSAudioBuffer
    implements AudioPlayer {
        private AudioFormat fmt;
        private float volume;
        private byte[] localBuff;
        private int curIndex = 0;
        private int totalBytes = 0;

        public TTSAudioBuffer() {
            TtsTrackImpl.this.outputList = new Vector();
        }

        public void setAudioFormat(AudioFormat fmt) {
            this.fmt = fmt;
        }

        public AudioFormat getAudioFormat() {
            return this.fmt;
        }

        public void pause() {
        }

        public void resume() {
        }

        public void reset() {
            this.curIndex = 0;
            this.localBuff = null;
            TtsTrackImpl.this.isReady = false;
        }

        public boolean drain() {
            return true;
        }

        public void begin(int size) {
            this.localBuff = new byte[size];
            this.curIndex = 0;
        }

        public boolean end() {
            TtsTrackImpl.this.outputList.add(this.localBuff);
            this.totalBytes += this.localBuff.length;
            System.out.println("end() called totalBytes = " + this.totalBytes);
            TtsTrackImpl.this.isReady = true;
            return true;
        }

        public void cancel() {
        }

        public void close() {
        }

        public void flip() {
            byte[] rawData = null;
            if (TtsTrackImpl.this.outputList.size() == 1) {
                rawData = (byte[])TtsTrackImpl.this.outputList.firstElement();
            } else {
                int offSet = 0;
                rawData = new byte[this.totalBytes];
                for (byte[] byteArr : TtsTrackImpl.this.outputList) {
                    System.arraycopy(byteArr, 0, rawData, offSet, byteArr.length);
                    offSet += byteArr.length;
                }
            }
            if (this.fmt.isBigEndian()) {
                TtsTrackImpl.this.switchEndian(rawData, 0, rawData.length);
                this.fmt = new AudioFormat(this.fmt.getEncoding(), this.fmt.getSampleRate(), this.fmt.getSampleSizeInBits(), this.fmt.getChannels(), this.fmt.getFrameSize(), this.fmt.getFrameRate(), false);
            }
            TtsTrackImpl.this.duration = (long)((float)(this.totalBytes * 1000) / ((float)(this.fmt.getSampleSizeInBits() / 8) * this.fmt.getSampleRate()));
            if (this.fmt.getSampleRate() != 8000.0f) {
                double originalFrequency = this.fmt.getSampleRate();
                double targetFrequency = 8000.0;
                double targetDX = 1.0 / targetFrequency;
                double originalDX = 1.0 / originalFrequency;
                int byteCount = this.fmt.getSampleSizeInBits() / 8;
                int originalSampleCount = this.totalBytes / byteCount;
                int[] originalSignal = new int[originalSampleCount];
                int j = 0;
                for (int i = 0; i < originalSignal.length; ++i) {
                    originalSignal[i] = rawData[j++] & 0xFF | rawData[j++] << 8;
                }
                double ratio = this.fmt.getSampleRate() / 8000.0f;
                int count = (int)((double)originalSignal.length / ratio);
                int[] resampledSignal = new int[count];
                for (int k = 0; k < count; ++k) {
                    double xk = targetDX * (double)k;
                    int i = (int)(xk / originalDX);
                    double tang = (double)(originalSignal[i + 1] - originalSignal[i]) / originalDX;
                    double resampled = (double)originalSignal[i] + (xk - (double)i * originalDX) * tang;
                    resampledSignal[k] = (int)resampled;
                }
                rawData = new byte[resampledSignal.length * 2];
                j = 0;
                for (int i = 0; i < resampledSignal.length; ++i) {
                    rawData[j++] = (byte)resampledSignal[i];
                    rawData[j++] = (byte)(resampledSignal[i] >> 8);
                }
                AudioFormat targetFormat = new AudioFormat(this.fmt.getEncoding(), 8000.0f, this.fmt.getSampleSizeInBits(), this.fmt.getChannels(), this.fmt.getFrameSize(), 8000.0f, this.fmt.isBigEndian());
            }
            ByteArrayInputStream is = new ByteArrayInputStream(rawData);
            TtsTrackImpl.this.stream = new AudioInputStream(is, this.fmt, rawData.length / this.fmt.getFrameSize());
        }

        public float getVolume() {
            return this.volume;
        }

        public void setVolume(float volume) {
            this.volume = volume;
        }

        public long getTime() {
            return 0L;
        }

        public void resetTime() {
        }

        public void startFirstSampleTimer() {
        }

        public boolean write(byte[] buff) {
            return this.write(buff, 0, buff.length);
        }

        public boolean write(byte[] buff, int off, int len) {
            System.arraycopy(buff, off, this.localBuff, this.curIndex, len);
            this.curIndex += len;
            return true;
        }

        public void showMetrics() {
        }
    }
}

